/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.poi.util;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.imageio.ImageIO;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPicture;
import org.apache.poi.hssf.usermodel.HSSFPictureData;
import org.apache.poi.hssf.usermodel.HSSFShape;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ooxml.POIXMLDocumentPart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFPicture;
import org.apache.poi.xssf.usermodel.XSSFPictureData;
import org.apache.poi.xssf.usermodel.XSSFShape;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jeecgframework.poi.excel.annotation.Excel;
import org.jeecgframework.poi.excel.annotation.ExcelCollection;
import org.jeecgframework.poi.excel.annotation.ExcelEntity;
import org.jeecgframework.poi.excel.annotation.ExcelIgnore;
import org.jeecgframework.poi.util.ExcelUtil;
import org.jeecgframework.poi.util.PoiElUtil;
import org.jeecgframework.poi.word.entity.WordImageEntity;
import org.jeecgframework.poi.word.entity.params.ExcelListEntity;
import org.openxmlformats.schemas.drawingml.x2006.spreadsheetDrawing.CTMarker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PoiPublicUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(PoiPublicUtil.class);

    private PoiPublicUtil() {
    }

    public static <K, V> Map<K, V> mapFor(Object ... mapping) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < mapping.length; i += 2) {
            map.put(mapping[i], mapping[i + 1]);
        }
        return map;
    }

    public static Object createObject(Class<?> clazz, String targetId) {
        Object obj = null;
        try {
            Field[] fields;
            if (clazz.equals(Map.class)) {
                return new LinkedHashMap();
            }
            obj = clazz.newInstance();
            for (Field field : fields = PoiPublicUtil.getClassFields(clazz)) {
                Method setMethod;
                if (PoiPublicUtil.isNotUserExcelUserThis(null, field, targetId)) continue;
                if (PoiPublicUtil.isCollection(field.getType())) {
                    ExcelCollection collection = field.getAnnotation(ExcelCollection.class);
                    setMethod = PoiPublicUtil.getMethod(field.getName(), clazz, field.getType());
                    setMethod.invoke(obj, collection.type().newInstance());
                    continue;
                }
                if (PoiPublicUtil.isJavaClass(field)) continue;
                setMethod = PoiPublicUtil.getMethod(field.getName(), clazz, field.getType());
                setMethod.invoke(obj, PoiPublicUtil.createObject(field.getType(), targetId));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u521b\u5efa\u5bf9\u8c61\u5f02\u5e38");
        }
        return obj;
    }

    public static Field[] getClassFields(Class<?> clazz) {
        Field[] fields;
        ArrayList<Field> list = new ArrayList<Field>();
        do {
            fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                list.add(fields[i]);
            }
        } while ((clazz = clazz.getSuperclass()) != Object.class && clazz != null);
        return list.toArray(fields);
    }

    public static String getFileExtendName(byte[] photoByte) {
        String strFileExtendName = "JPG";
        if (photoByte[0] == 71 && photoByte[1] == 73 && photoByte[2] == 70 && photoByte[3] == 56 && (photoByte[4] == 55 || photoByte[4] == 57) && photoByte[5] == 97) {
            strFileExtendName = "GIF";
        } else if (photoByte[6] == 74 && photoByte[7] == 70 && photoByte[8] == 73 && photoByte[9] == 70) {
            strFileExtendName = "JPG";
        } else if (photoByte[0] == 66 && photoByte[1] == 77) {
            strFileExtendName = "BMP";
        } else if (photoByte[1] == 80 && photoByte[2] == 78 && photoByte[3] == 71) {
            strFileExtendName = "PNG";
        }
        return strFileExtendName;
    }

    public static Method getMethod(String name, Class<?> pojoClass) throws Exception {
        StringBuffer getMethodName = new StringBuffer("get");
        getMethodName.append(name.substring(0, 1).toUpperCase());
        getMethodName.append(name.substring(1));
        Method method = null;
        try {
            method = pojoClass.getMethod(getMethodName.toString(), new Class[0]);
        }
        catch (Exception e) {
            method = pojoClass.getMethod(getMethodName.toString().replace("get", "is"), new Class[0]);
        }
        return method;
    }

    public static Method getMethod(String name, Class<?> pojoClass, Class<?> type) throws Exception {
        StringBuffer getMethodName = new StringBuffer("set");
        getMethodName.append(name.substring(0, 1).toUpperCase());
        getMethodName.append(name.substring(1));
        return pojoClass.getMethod(getMethodName.toString(), type);
    }

    public static Method getMethod(String name, Class<?> pojoClass, boolean convert) throws Exception {
        StringBuffer getMethodName = new StringBuffer();
        if (convert) {
            getMethodName.append("convert");
        }
        getMethodName.append("get");
        getMethodName.append(name.substring(0, 1).toUpperCase());
        getMethodName.append(name.substring(1));
        Method method = null;
        try {
            method = pojoClass.getMethod(getMethodName.toString(), new Class[0]);
        }
        catch (Exception e) {
            method = pojoClass.getMethod(getMethodName.toString().replace("get", "is"), new Class[0]);
        }
        return method;
    }

    public static Method getMethod(String name, Class<?> pojoClass, Class<?> type, boolean convert) throws Exception {
        StringBuffer setMethodName = new StringBuffer();
        if (convert) {
            setMethodName.append("convert");
        }
        setMethodName.append("set");
        setMethodName.append(name.substring(0, 1).toUpperCase());
        setMethodName.append(name.substring(1));
        return pojoClass.getMethod(setMethodName.toString(), type);
    }

    public static Map<String, PictureData> getSheetPictrues03(HSSFSheet sheet, HSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        List pictures = workbook.getAllPictures();
        if (!pictures.isEmpty()) {
            for (HSSFShape shape : sheet.getDrawingPatriarch().getChildren()) {
                HSSFClientAnchor anchor = (HSSFClientAnchor)shape.getAnchor();
                if (!(shape instanceof HSSFPicture)) continue;
                HSSFPicture pic = (HSSFPicture)shape;
                int pictureIndex = pic.getPictureIndex() - 1;
                HSSFPictureData picData = (HSSFPictureData)pictures.get(pictureIndex);
                String picIndex = String.valueOf(anchor.getRow1()) + "_" + String.valueOf(anchor.getCol1());
                sheetIndexPicMap.put(picIndex, (PictureData)picData);
            }
            return sheetIndexPicMap;
        }
        return null;
    }

    public static Map<String, PictureData> getSheetPictrues07(XSSFSheet sheet, XSSFWorkbook workbook) {
        HashMap<String, PictureData> sheetIndexPicMap = new HashMap<String, PictureData>();
        for (POIXMLDocumentPart dr : sheet.getRelations()) {
            if (!(dr instanceof XSSFDrawing)) continue;
            XSSFDrawing drawing = (XSSFDrawing)dr;
            List shapes = drawing.getShapes();
            for (XSSFShape shape : shapes) {
                XSSFPicture pic = (XSSFPicture)shape;
                XSSFClientAnchor anchor = pic.getPreferredSize();
                CTMarker ctMarker = anchor.getFrom();
                String picIndex = ctMarker.getRow() + "_" + ctMarker.getCol();
                sheetIndexPicMap.put(picIndex, (PictureData)pic.getPictureData());
            }
        }
        return sheetIndexPicMap;
    }

    public static Map<String, PictureData> getCellImages(Sheet sheet, ByteArrayOutputStream isCopy, Workbook book) {
        HashMap<Object, CellImage> cellImageMap = new HashMap<Object, CellImage>();
        Iterator rows = sheet.rowIterator();
        while (rows.hasNext()) {
            Row row = (Row)rows.next();
            Iterator cells = row.cellIterator();
            while (cells.hasNext()) {
                String cellVal;
                CellType resultType;
                Cell cell = (Cell)cells.next();
                CellType cellType = cell.getCellType();
                if (!cellType.equals((Object)CellType.FORMULA) || !(resultType = cell.getCachedFormulaResultType()).equals((Object)CellType.STRING) || null == (cellVal = cell.getStringCellValue()) || !cellVal.startsWith("=DISPIMG")) continue;
                int start = cellVal.indexOf("\"");
                int end = cellVal.lastIndexOf("\"");
                if (start == -1 || end == -1) continue;
                String imgId = cellVal.substring(start + 1, end);
                CellImage cellImage2 = new CellImage();
                cellImage2.setImgId(imgId);
                cellImage2.setCellStr(cellVal);
                cellImageMap.put(row.getRowNum() + "_" + cell.getColumnIndex(), cellImage2);
            }
        }
        try (ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(isCopy.toByteArray()));
             ZipInputStream fzis = new ZipInputStream(new ByteArrayInputStream(isCopy.toByteArray()));){
            String content;
            String fileName;
            ZipEntry entry;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            while ((entry = zis.getNextEntry()) != null) {
                try {
                    Document document;
                    NodeList cellImages;
                    fileName = entry.getName();
                    if (!Objects.equals(fileName, "xl/cellimages.xml") || Objects.isNull(cellImages = (document = documentBuilder.parse(new InputSource(new ByteArrayInputStream((content = IOUtils.toString((InputStream)zis, (Charset)StandardCharsets.UTF_8)).getBytes(StandardCharsets.UTF_8))))).getElementsByTagName("etc:cellImage"))) continue;
                    for (int i2 = 0; i2 < cellImages.getLength(); ++i2) {
                        Node blip;
                        String embed;
                        NodeList blips;
                        CellImage tempCellimage;
                        Node cNvPrNode;
                        String name;
                        Node cellImageNode = cellImages.item(i2);
                        NodeList cNvPr = ((Element)cellImageNode).getElementsByTagName("xdr:cNvPr");
                        if (cNvPr.getLength() < 1 || !StringUtils.isNotEmpty((CharSequence)(name = ((Element)(cNvPrNode = cNvPr.item(0))).getAttribute("name"))) || !Objects.nonNull(tempCellimage = (CellImage)cellImageMap.values().stream().filter(item -> Objects.equals(item.getImgId(), name)).findFirst().orElse(null)) || (blips = ((Element)cellImageNode).getElementsByTagName("a:blip")).getLength() < 1 || (embed = ((Element)(blip = blips.item(0))).getAttribute("r:embed")).isEmpty()) continue;
                        tempCellimage.setRId(embed);
                    }
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    zis.closeEntry();
                }
            }
            while ((entry = fzis.getNextEntry()) != null) {
                try {
                    Document document;
                    NodeList relationships;
                    fileName = entry.getName();
                    if (!Objects.equals(fileName, "xl/_rels/cellimages.xml.rels") || Objects.isNull(relationships = (document = documentBuilder.parse(new InputSource(new ByteArrayInputStream((content = IOUtils.toString((InputStream)fzis, (Charset)StandardCharsets.UTF_8)).getBytes(StandardCharsets.UTF_8))))).getElementsByTagName("Relationship"))) continue;
                    for (int i3 = 0; i3 < relationships.getLength(); ++i3) {
                        Node relationshipNode = relationships.item(i3);
                        if (!(relationshipNode instanceof Element)) continue;
                        Element relationshipEl = (Element)relationshipNode;
                        String id = relationshipEl.getAttribute("Id");
                        String target = "/xl/" + relationshipEl.getAttribute("Target");
                        if (!StringUtils.isNotEmpty((CharSequence)id)) continue;
                        List cellImages = cellImageMap.values().stream().filter(item -> Objects.equals(item.getRId(), id)).collect(Collectors.toList());
                        cellImages.stream().filter(Objects::nonNull).forEach(cellImage -> cellImage.setImgName(target));
                    }
                }
                catch (SAXException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    fzis.closeEntry();
                }
            }
            List allPictures = book.getAllPictures();
            for (XSSFPictureData pictureData : allPictures) {
                PackagePartName partName = pictureData.getPackagePart().getPartName();
                URI uri = partName.getURI();
                List cellImages = cellImageMap.values().stream().filter(i -> Objects.equals(i.getImgName(), uri.toString())).collect(Collectors.toList());
                cellImages.stream().filter(Objects::nonNull).forEach(cellImage -> cellImage.setPictureData(pictureData));
            }
        }
        catch (IOException | ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, PictureData> resp = new HashMap<String, PictureData>();
        if (!cellImageMap.isEmpty()) {
            cellImageMap.forEach((key, cellImage) -> resp.put((String)key, (PictureData)cellImage.getPictureData()));
        }
        return resp;
    }

    public static String getWebRootPath(String filePath) {
        try {
            String path = null;
            try {
                path = PoiPublicUtil.class.getClassLoader().getResource("").toURI().getPath();
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (NullPointerException e) {
                path = PoiPublicUtil.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            }
            if (path == null || path == "") {
                path = ClassUtils.getDefaultClassLoader().getResource("").getPath();
            }
            LOGGER.debug("--- getWebRootPath ----filePath--- " + path);
            path = path.replace("WEB-INF/classes/", "");
            path = path.replace("file:/", "");
            LOGGER.debug("--- path---  " + path);
            LOGGER.debug("--- filePath---  " + filePath);
            return path + filePath;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean isCollection(Class<?> clazz) {
        return Collection.class.isAssignableFrom(clazz);
    }

    public static boolean isJavaClass(Field field) {
        Class<?> fieldType = field.getType();
        boolean isBaseClass = false;
        if (fieldType.isArray()) {
            isBaseClass = false;
        } else if (fieldType.isPrimitive() || fieldType.getPackage() == null || fieldType.getPackage().getName().equals("java.lang") || fieldType.getPackage().getName().equals("java.math") || fieldType.getPackage().getName().equals("java.sql") || fieldType.getPackage().getName().equals("java.util") || fieldType.getPackage().getName().equals("java.time")) {
            isBaseClass = true;
        }
        return isBaseClass;
    }

    public static boolean isNotUserExcelUserThis(List<String> exclusionsList, Field field, String targetId) {
        boolean boo = true;
        if (field.getAnnotation(ExcelIgnore.class) != null) {
            boo = true;
        } else if (boo && field.getAnnotation(ExcelCollection.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelCollection.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelCollection.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(Excel.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(Excel.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(Excel.class).name()))) {
            boo = false;
        } else if (boo && field.getAnnotation(ExcelEntity.class) != null && PoiPublicUtil.isUseInThis(field.getAnnotation(ExcelEntity.class).name(), targetId) && (exclusionsList == null || !exclusionsList.contains(field.getAnnotation(ExcelEntity.class).name()))) {
            boo = false;
        }
        return boo;
    }

    private static boolean isUseInThis(String exportName, String targetId) {
        return targetId == null || exportName.equals("") || exportName.indexOf("_") < 0 || exportName.indexOf(targetId) != -1;
    }

    private static Integer getImageType(String type) {
        if (type.equalsIgnoreCase("JPG") || type.equalsIgnoreCase("JPEG")) {
            return 5;
        }
        if (type.equalsIgnoreCase("GIF")) {
            return 8;
        }
        if (type.equalsIgnoreCase("BMP")) {
            return 8;
        }
        if (type.equalsIgnoreCase("PNG")) {
            return 6;
        }
        return 5;
    }

    public static Object[] getIsAndType(WordImageEntity entity) throws Exception {
        String type;
        Object[] result = new Object[2];
        if (entity.getType().equals(WordImageEntity.URL)) {
            ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
            Object path = Thread.currentThread().getContextClassLoader().getResource("").toURI().getPath() + entity.getUrl();
            path = ((String)path).replace("WEB-INF/classes/", "");
            path = ((String)path).replace("file:/", "");
            BufferedImage bufferImg = ImageIO.read(new File((String)path));
            ImageIO.write((RenderedImage)bufferImg, entity.getUrl().substring(entity.getUrl().lastIndexOf(".") + 1, entity.getUrl().length()), byteArrayOut);
            result[0] = byteArrayOut.toByteArray();
            type = entity.getUrl().split("/.")[entity.getUrl().split("/.").length - 1];
        } else {
            result[0] = entity.getData();
            type = PoiPublicUtil.getFileExtendName(entity.getData());
        }
        result[1] = PoiPublicUtil.getImageType(type);
        return result;
    }

    public static Object getParamsValue(String params, Object object) throws Exception {
        if (params.indexOf(".") != -1) {
            String[] paramsArr = params.split("\\.");
            return PoiPublicUtil.getValueDoWhile(object, paramsArr, 0);
        }
        if (object instanceof Map) {
            return ((Map)object).get(params);
        }
        return PoiPublicUtil.getMethod(params, object.getClass()).invoke(object, new Object[0]);
    }

    public static Object getRealValue(String currentText, Map<String, Object> map) throws Exception {
        String params = "";
        while (currentText.indexOf("{{") != -1) {
            params = currentText.substring(currentText.indexOf("{{") + 2, currentText.indexOf("}}"));
            Object obj = PoiElUtil.eval(params.trim(), map);
            if (obj == null) {
                obj = "";
            }
            if (obj instanceof WordImageEntity || obj instanceof List || obj instanceof ExcelListEntity) {
                return obj;
            }
            currentText = currentText.replace("{{" + params + "}}", obj.toString());
        }
        return currentText;
    }

    public static Object getValueDoWhile(Object object, String[] paramsArr, int index) throws Exception {
        if (object == null) {
            return "";
        }
        if (object instanceof WordImageEntity) {
            return object;
        }
        object = object instanceof Map ? ((Map)object).get(paramsArr[index]) : PoiPublicUtil.getMethod(paramsArr[index], object.getClass()).invoke(object, new Object[0]);
        return index == paramsArr.length - 1 ? (object == null ? "" : object) : PoiPublicUtil.getValueDoWhile(object, paramsArr, ++index);
    }

    public static String doubleToString(Double value) {
        String temp = value.toString();
        if (temp.contains("E")) {
            BigDecimal bigDecimal = new BigDecimal(temp);
            temp = bigDecimal.toPlainString();
        }
        return ExcelUtil.remove0Suffix(temp);
    }

    public static boolean isNumber(String xclass) {
        if (xclass == null) {
            return false;
        }
        String temp = xclass.toLowerCase();
        return temp.indexOf("int") >= 0 || temp.indexOf("double") >= 0 || temp.indexOf("decimal") >= 0;
    }

    public static String getValueByTargetId(String key, String targetId, String defalut) {
        String[] arr;
        if (StringUtils.isEmpty((CharSequence)targetId) || key.indexOf("_") < 0) {
            return key;
        }
        for (String str : arr = key.split(",")) {
            String[] tempArr = str.split("_");
            if (tempArr == null || tempArr.length < 2) {
                return defalut;
            }
            if (!targetId.equals(tempArr[1])) continue;
            return tempArr[0];
        }
        return defalut;
    }

    static class CellImage {
        private String imgId;
        private String cellStr;
        private String rId;
        private String imgName;
        private XSSFPictureData pictureData;

        CellImage() {
        }

        public String getImgId() {
            return this.imgId;
        }

        public void setImgId(String imgId) {
            this.imgId = imgId;
        }

        public String getCellStr() {
            return this.cellStr;
        }

        public void setCellStr(String cellStr) {
            this.cellStr = cellStr;
        }

        public String getRId() {
            return this.rId;
        }

        public void setRId(String rId) {
            this.rId = rId;
        }

        public String getImgName() {
            return this.imgName;
        }

        public void setImgName(String imgName) {
            this.imgName = imgName;
        }

        public XSSFPictureData getPictureData() {
            return this.pictureData;
        }

        public void setPictureData(XSSFPictureData pictureData) {
            this.pictureData = pictureData;
        }
    }
}

