/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.AndroidExtensionsExtension;
import org.jetbrains.kotlin.gradle.model.builder.KotlinAndroidExtensionModelBuilder;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginKt;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/AndroidExtensionsSubpluginIndicator;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "addAndroidExtensionsRuntimeIfNeeded", "", "project", "apply", "kotlin-gradle-plugin"})
public final class AndroidExtensionsSubpluginIndicator
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry registry;

    public void apply(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        AndroidExtensionsExtension extension = (AndroidExtensionsExtension)project.getExtensions().create("androidExtensions", AndroidExtensionsExtension.class, new Object[0]);
        extension.setEvaluatedHandler((Function1<? super AndroidExtensionsExtension, Unit>)((Function1)new Function1<AndroidExtensionsExtension, Unit>(this, project){
            final /* synthetic */ AndroidExtensionsSubpluginIndicator this$0;
            final /* synthetic */ Project $project;

            public final void invoke(@NotNull AndroidExtensionsExtension evaluatedExtension) {
                Intrinsics.checkParameterIsNotNull((Object)evaluatedExtension, (String)"evaluatedExtension");
                if (evaluatedExtension.isExperimental()) {
                    AndroidExtensionsSubpluginIndicator.access$addAndroidExtensionsRuntimeIfNeeded(this.this$0, this.$project);
                }
            }
            {
                this.this$0 = androidExtensionsSubpluginIndicator;
                this.$project = project;
                super(1);
            }
        }));
        this.registry.register((ToolingModelBuilder)new KotlinAndroidExtensionModelBuilder());
    }

    private final void addAndroidExtensionsRuntimeIfNeeded(Project project) {
        String string = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
        if (string == null) {
            AndroidExtensionsSubpluginIndicator androidExtensionsSubpluginIndicator;
            AndroidExtensionsSubpluginIndicator $receiver = androidExtensionsSubpluginIndicator = this;
            project.getLogger().error("Kotlin plugin should be enabled before 'kotlin-android-extensions'");
            return;
        }
        String kotlinPluginVersion = string;
        project.getConfigurations().all((Action)new Action<Configuration>(project, kotlinPluginVersion){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $kotlinPluginVersion;

            public final void execute(Configuration configuration) {
                String requiredConfigurationName;
                Configuration configuration2 = configuration;
                Intrinsics.checkExpressionValueIsNotNull((Object)configuration2, (String)"configuration");
                String name = configuration2.getName();
                if (Intrinsics.areEqual((Object)name, (Object)"implementation") ^ true && Intrinsics.areEqual((Object)name, (Object)"compile") ^ true) {
                    return;
                }
                String string = KotlinPluginKt.loadAndroidPluginVersion();
                if (string == null) {
                    return;
                }
                String androidPluginVersion = string;
                String string2 = requiredConfigurationName = KotlinPluginKt.compareVersionNumbers(androidPluginVersion, "2.5") > 0 ? "implementation" : "compile";
                if (Intrinsics.areEqual((Object)name, (Object)requiredConfigurationName) ^ true) {
                    return;
                }
                configuration.getDependencies().add((Object)this.$project.getDependencies().create((Object)("org.jetbrains.kotlin:kotlin-android-extensions-runtime:" + this.$kotlinPluginVersion)));
            }
            {
                this.$project = project;
                this.$kotlinPluginVersion = string;
            }
        });
    }

    @Inject
    public AndroidExtensionsSubpluginIndicator(@NotNull ToolingModelBuilderRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
    }

    public static final /* synthetic */ void access$addAndroidExtensionsRuntimeIfNeeded(AndroidExtensionsSubpluginIndicator $this, @NotNull Project project) {
        $this.addAndroidExtensionsRuntimeIfNeeded(project);
    }
}

