/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.internal;

import java.io.File;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.artifacts.Configuration;
import org.gradle.tooling.provider.model.ToolingModelBuilder;
import org.gradle.tooling.provider.model.ToolingModelBuilderRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.internal.Kapt3KotlinGradleSubplugin;
import org.jetbrains.kotlin.gradle.model.builder.KaptModelBuilder;
import org.jetbrains.kotlin.gradle.plugin.KaptExtension;
import org.jetbrains.kotlin.gradle.plugin.KotlinPluginWrapperKt;
import org.jetbrains.kotlin.gradle.plugin.SubpluginArtifact;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3GradleSubplugin;", "Lorg/gradle/api/Plugin;", "Lorg/gradle/api/Project;", "registry", "Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;", "(Lorg/gradle/tooling/provider/model/ToolingModelBuilderRegistry;)V", "apply", "", "project", "Companion", "kotlin-gradle-plugin"})
public final class Kapt3GradleSubplugin
implements Plugin<Project> {
    private final ToolingModelBuilderRegistry registry;
    public static final Companion Companion = new Companion(null);

    public void apply(@NotNull Project project) {
        Kapt3KotlinGradleSubplugin kapt3KotlinGradleSubplugin;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        project.getExtensions().create("kapt", KaptExtension.class, new Object[0]);
        Kapt3KotlinGradleSubplugin $receiver = kapt3KotlinGradleSubplugin = new Kapt3KotlinGradleSubplugin();
        Object object = project.getConfigurations().create("kotlinKaptWorkerDependencies");
        Configuration $receiver2 = (Configuration)object;
        String string = KotlinPluginWrapperKt.getKotlinPluginVersion(project);
        if (string != null) {
            SubpluginArtifact subpluginArtifact;
            String string2;
            String kotlinPluginVersion = string2 = string;
            SubpluginArtifact $receiver3 = subpluginArtifact = $receiver.getPluginArtifact();
            String kaptDependency = $receiver3.getGroupId() + ':' + $receiver3.getArtifactId() + ':' + kotlinPluginVersion;
            $receiver2.getDependencies().add((Object)project.getDependencies().create((Object)kaptDependency));
        } else {
            project.getLogger().error("Kotlin plugin should be enabled before 'kotlin-kapt'");
        }
        Configuration cfr_ignored_0 = (Configuration)object;
        this.registry.register((ToolingModelBuilder)new KaptModelBuilder());
    }

    @Inject
    public Kapt3GradleSubplugin(@NotNull ToolingModelBuilderRegistry registry) {
        Intrinsics.checkParameterIsNotNull((Object)registry, (String)"registry");
        this.registry = registry;
    }

    @JvmStatic
    @NotNull
    public static final File getKaptGeneratedClassesDir(@NotNull Project project, @NotNull String sourceSetName) {
        return Companion.getKaptGeneratedClassesDir(project, sourceSetName);
    }

    @JvmStatic
    @NotNull
    public static final File getKaptGeneratedSourcesDir(@NotNull Project project, @NotNull String sourceSetName) {
        return Companion.getKaptGeneratedSourcesDir(project, sourceSetName);
    }

    @JvmStatic
    @NotNull
    public static final File getKaptGeneratedKotlinSourcesDir(@NotNull Project project, @NotNull String sourceSetName) {
        return Companion.getKaptGeneratedKotlinSourcesDir(project, sourceSetName);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/internal/Kapt3GradleSubplugin$Companion;", "", "()V", "getKaptGeneratedClassesDir", "Ljava/io/File;", "project", "Lorg/gradle/api/Project;", "sourceSetName", "", "getKaptGeneratedKotlinSourcesDir", "getKaptGeneratedSourcesDir", "isEnabled", "", "kotlin-gradle-plugin"})
    public static final class Companion {
        public final boolean isEnabled(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            return project.getPlugins().findPlugin(Kapt3GradleSubplugin.class) != null;
        }

        @JvmStatic
        @NotNull
        public final File getKaptGeneratedClassesDir(@NotNull Project project, @NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            Project project2 = project.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.project");
            return new File(project2.getBuildDir(), "tmp/kapt3/classes/" + sourceSetName);
        }

        @JvmStatic
        @NotNull
        public final File getKaptGeneratedSourcesDir(@NotNull Project project, @NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            Project project2 = project.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.project");
            return new File(project2.getBuildDir(), "generated/source/kapt/" + sourceSetName);
        }

        @JvmStatic
        @NotNull
        public final File getKaptGeneratedKotlinSourcesDir(@NotNull Project project, @NotNull String sourceSetName) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)sourceSetName, (String)"sourceSetName");
            Project project2 = project.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project.project");
            return new File(project2.getBuildDir(), "generated/source/kaptKotlin/" + sourceSetName);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

