/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.plugin;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.logging.Logger;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.compile.JavaCompile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.gradle.dsl.KotlinJvmProjectExtension;
import org.jetbrains.kotlin.gradle.plugin.CopyClassesToJavaOutputStatus;
import org.jetbrains.kotlin.gradle.plugin.GradleUtilsKt;
import org.jetbrains.kotlin.gradle.utils.ParsedGradleVersion;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\bH\u0002J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bJ\u0010\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0011\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R2\u0010\u0006\u001a&\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*\u0012\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0018\u00010\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/gradle/plugin/CopyClassesToJavaOutputStatus;", "", "()V", "buildCacheWarningMessage", "", "gradleVersionTooLowWarningMessage", "warningReportedForProject", "", "Lorg/gradle/api/Project;", "kotlin.jvm.PlatformType", "", "kotlinJvmExt", "Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmProjectExtension;", "getKotlinJvmExt", "(Lorg/gradle/api/Project;)Lorg/jetbrains/kotlin/gradle/dsl/KotlinJvmProjectExtension;", "addCacheWarningToJavaTasks", "", "project", "isEnabled", "", "isGradleVersionTooLow", "kotlin-gradle-plugin"})
public final class CopyClassesToJavaOutputStatus {
    private static final Set<Project> warningReportedForProject;
    @NotNull
    public static final String buildCacheWarningMessage = "The 'kotlin.copyClassesToJavaOutput' option should not be used with Gradle build cache";
    @NotNull
    public static final String gradleVersionTooLowWarningMessage = "The 'kotlin.copyClassesToJavaOutput' option has no effect when used with Gradle < 4.0";
    public static final CopyClassesToJavaOutputStatus INSTANCE;

    public final boolean isEnabled(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        KotlinJvmProjectExtension kotlinJvmProjectExtension = this.getKotlinJvmExt(project);
        if (kotlinJvmProjectExtension == null) {
            return false;
        }
        KotlinJvmProjectExtension kotlinJvmExt = kotlinJvmProjectExtension;
        if (kotlinJvmExt.getCopyClassesToJavaOutput()) {
            if (this.isGradleVersionTooLow(project)) {
                if (warningReportedForProject.add(project)) {
                    Logger logger = project.getLogger();
                    Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
                    GradleUtilsKt.kotlinWarn(logger, gradleVersionTooLowWarningMessage);
                }
            } else {
                this.addCacheWarningToJavaTasks(project);
            }
            return true;
        }
        return false;
    }

    private final boolean isGradleVersionTooLow(Project project) {
        Gradle gradle = project.getGradle();
        Intrinsics.checkExpressionValueIsNotNull((Object)gradle, (String)"project.gradle");
        String string = gradle.getGradleVersion();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"project.gradle.gradleVersion");
        ParsedGradleVersion parsedGradleVersion = ParsedGradleVersion.Companion.parse(string);
        if (parsedGradleVersion == null) {
            return false;
        }
        return parsedGradleVersion.compareTo(new ParsedGradleVersion(4, 0)) < 0;
    }

    private final void addCacheWarningToJavaTasks(Project project) {
        project.getTasks().withType(JavaCompile.class).all((Action)new Action<JavaCompile>(project){
            final /* synthetic */ Project $project;

            public final void execute(JavaCompile it) {
                Spec warningCacheIfSpec2 = (Spec)new Spec<Task>(this){
                    final /* synthetic */ addCacheWarningToJavaTasks.1 this$0;

                    public final boolean isSatisfiedBy(Task it) {
                        if (CopyClassesToJavaOutputStatus.access$getWarningReportedForProject$p(CopyClassesToJavaOutputStatus.INSTANCE).add(this.this$0.$project)) {
                            Logger logger = this.this$0.$project.getLogger();
                            Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"project.logger");
                            GradleUtilsKt.kotlinWarn(logger, "The 'kotlin.copyClassesToJavaOutput' option should not be used with Gradle build cache");
                        }
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                };
                JavaCompile javaCompile = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)javaCompile, (String)"it");
                javaCompile.getOutputs().getClass().getMethod("cacheIf", Spec.class).invoke((Object)it.getOutputs(), warningCacheIfSpec2);
            }
            {
                this.$project = project;
            }
        });
    }

    private final KotlinJvmProjectExtension getKotlinJvmExt(@NotNull Project $receiver) {
        return (KotlinJvmProjectExtension)$receiver.getExtensions().findByType(KotlinJvmProjectExtension.class);
    }

    private CopyClassesToJavaOutputStatus() {
    }

    static {
        CopyClassesToJavaOutputStatus copyClassesToJavaOutputStatus;
        INSTANCE = copyClassesToJavaOutputStatus = new CopyClassesToJavaOutputStatus();
        warningReportedForProject = Collections.newSetFromMap(new WeakHashMap());
    }

    public static final /* synthetic */ Set access$getWarningReportedForProject$p(CopyClassesToJavaOutputStatus $this) {
        CopyClassesToJavaOutputStatus copyClassesToJavaOutputStatus = $this;
        return warningReportedForProject;
    }
}

