/*
 * Decompiled with CFR 0.152.
 */
package jodd;

public class Jodd {
    private static boolean initialized = false;
    public static String JODD;

    private static synchronized void initAllModules() {
        if (initialized) {
            return;
        }
        for (JoddModule joddModule : JoddModule.values()) {
            joddModule.load();
        }
        for (JoddModule joddModule : JoddModule.values()) {
            joddModule.start();
        }
        initialized = true;
    }

    public static boolean isModuleLoaded(JoddModule module) {
        return module.moduleClass != null;
    }

    public static void initModule() {
        Jodd.initModule(null);
    }

    public static void initModule(Runnable initRunnable) {
        StackTraceElement[] stackTrace;
        for (StackTraceElement stackTraceElement : stackTrace = Thread.currentThread().getStackTrace()) {
            String className = stackTraceElement.getClassName();
            for (JoddModule joddModule : JoddModule.values()) {
                if (!className.equals(Jodd.resolveClassName(joddModule))) continue;
                joddModule.load();
                if (initRunnable != null) {
                    initRunnable.run();
                }
                return;
            }
        }
        throw new RuntimeException("Only Jodd module can be initialized!");
    }

    private static String resolveClassName(JoddModule joddModule) {
        int ndx;
        String moduleName = joddModule.name();
        String packageName = moduleName.toLowerCase();
        while ((ndx = packageName.indexOf(95)) != -1) {
            packageName = packageName.substring(0, ndx) + packageName.substring(ndx + 1);
        }
        moduleName = moduleName.substring(0, 1).toUpperCase() + moduleName.substring(1, moduleName.length()).toLowerCase();
        while ((ndx = moduleName.indexOf(95)) != -1) {
            moduleName = moduleName.substring(0, ndx) + moduleName.substring(ndx + 1, ndx + 2).toUpperCase() + moduleName.substring(ndx + 2);
        }
        return "jodd." + packageName + ".Jodd" + moduleName;
    }

    static {
        Jodd.initAllModules();
        JODD = "\n          __          __    __\n         / /___  ____/ /___/ /\n    __  / / __ \\/ __  / __  / \n   / /_/ / /_/ / /_/ / /_/ /  \n   \\____/\\____/\\__,_/\\__,_/   \n";
    }

    public static enum JoddModule {
        CORE,
        BEAN,
        DB,
        DECORA,
        HTTP,
        HTML_STAPLER,
        JSON,
        JTX,
        LAGARTO,
        MADVOC,
        MAIL,
        PETITE,
        PROPS,
        PROXETTA,
        SERVLET,
        UPLOAD,
        VTOR;

        private Class<?> moduleClass;

        private synchronized void load() {
            if (Jodd.isModuleLoaded(this)) {
                return;
            }
            String moduleClassName = Jodd.resolveClassName(this);
            try {
                this.moduleClass = Jodd.class.getClassLoader().loadClass(moduleClassName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }

        private synchronized void start() {
            if (!Jodd.isModuleLoaded(this)) {
                return;
            }
            try {
                this.moduleClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        static {
            Jodd.initAllModules();
        }
    }
}

