/*
 * Decompiled with CFR 0.152.
 */
package jodd.util.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import jodd.util.ClassUtil;
import jodd.util.StringUtil;
import jodd.util.annotation.AnnotationData;

public abstract class AnnotationDataReader<A extends Annotation, D extends AnnotationData<A>> {
    protected final Annotation defaultAnnotation;
    protected final Class<A> annotationClass;

    protected AnnotationDataReader(Class<A> annotationClass, Class<? extends Annotation> defaultAnnotationClass) {
        if (annotationClass == null) {
            Class[] genericSupertypes = ClassUtil.getGenericSupertypes(this.getClass());
            if (genericSupertypes != null) {
                annotationClass = genericSupertypes[0];
            }
            if (annotationClass == null || annotationClass == Annotation.class) {
                throw new IllegalArgumentException("Missing annotation from generics supertype");
            }
        }
        this.annotationClass = annotationClass;
        if (defaultAnnotationClass != null && defaultAnnotationClass != annotationClass) {
            Annotation defaultAnnotation = annotationClass.getAnnotation(defaultAnnotationClass);
            if (defaultAnnotation == null) {
                try {
                    defaultAnnotation = defaultAnnotationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.defaultAnnotation = defaultAnnotation;
        } else {
            this.defaultAnnotation = null;
        }
    }

    public Class<A> getAnnotationClass() {
        return this.annotationClass;
    }

    public boolean hasAnnotationOn(AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(this.annotationClass);
    }

    public D readAnnotatedElement(AnnotatedElement annotatedElement) {
        A annotation = annotatedElement.getAnnotation(this.annotationClass);
        if (annotation == null) {
            return null;
        }
        return this.createAnnotationData(annotation);
    }

    protected abstract D createAnnotationData(A var1);

    protected String readStringElement(A annotation, String name) {
        Object annotationValue = ClassUtil.readAnnotationValue(annotation, name);
        if (annotationValue == null) {
            if (this.defaultAnnotation == null) {
                return null;
            }
            annotationValue = ClassUtil.readAnnotationValue(this.defaultAnnotation, name);
            if (annotationValue == null) {
                return null;
            }
        }
        String value = StringUtil.toSafeString(annotationValue);
        return value.trim();
    }

    protected Object readElement(A annotation, String name) {
        Object annotationValue = ClassUtil.readAnnotationValue(annotation, name);
        if (annotationValue == null && this.defaultAnnotation != null) {
            annotationValue = ClassUtil.readAnnotationValue(this.defaultAnnotation, name);
        }
        return annotationValue;
    }

    protected String readString(A annotation, String name, String defaultValue) {
        String value = this.readStringElement(annotation, name);
        if (StringUtil.isEmpty(value)) {
            value = defaultValue;
        }
        return value;
    }

    protected boolean readBoolean(A annotation, String name, boolean defaultValue) {
        Boolean value = (Boolean)this.readElement(annotation, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected int readInt(A annotation, String name, int defaultValue) {
        Integer value = (Integer)this.readElement(annotation, name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }
}

