/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.console;

import java.io.PrintWriter;
import org.apiguardian.api.API;
import org.junit.platform.console.options.CommandFacade;
import org.junit.platform.console.options.CommandResult;
import org.junit.platform.console.tasks.ConsoleTestExecutor;

@API(status=API.Status.MAINTAINED, since="1.0")
public class ConsoleLauncher {
    private final ConsoleTestExecutor.Factory consoleTestExecutorFactory;
    private final PrintWriter out;
    private final PrintWriter err;

    public static void main(String ... args) {
        PrintWriter out = new PrintWriter(System.out);
        PrintWriter err = new PrintWriter(System.err);
        CommandResult<?> result = ConsoleLauncher.run(out, err, args);
        System.exit(result.getExitCode());
    }

    @API(status=API.Status.INTERNAL, since="1.0")
    public static CommandResult<?> run(PrintWriter out, PrintWriter err, String ... args) {
        ConsoleLauncher consoleLauncher = new ConsoleLauncher(ConsoleTestExecutor::new, out, err);
        return consoleLauncher.run(args);
    }

    ConsoleLauncher(ConsoleTestExecutor.Factory consoleTestExecutorFactory, PrintWriter out, PrintWriter err) {
        this.consoleTestExecutorFactory = consoleTestExecutorFactory;
        this.out = out;
        this.err = err;
    }

    CommandResult<?> run(String ... args) {
        try {
            CommandResult<?> commandResult = new CommandFacade(this.consoleTestExecutorFactory).run(this.out, this.err, args);
            return commandResult;
        }
        finally {
            this.out.flush();
            this.err.flush();
        }
    }
}

