/*
 * Decompiled with CFR 0.152.
 */
package org.kie.spring.factorybeans.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.command.Command;
import org.kie.api.command.KieCommands;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.RuleRuntimeEventListener;
import org.kie.api.logger.KieRuntimeLogger;
import org.kie.api.runtime.Channel;
import org.kie.api.runtime.Globals;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.command.CommandFactory;
import org.kie.spring.factorybeans.KSessionFactoryBean;
import org.kie.spring.factorybeans.helper.KSessionFactoryBeanHelper;

public class StatelessKSessionFactoryBeanHelper
extends KSessionFactoryBeanHelper {
    protected StatelessKieSession kieSession;
    private List<Command<?>> commands;

    public StatelessKSessionFactoryBeanHelper(KSessionFactoryBean factoryBean, StatelessKieSession kieSession) {
        super(factoryBean);
        this.kieSession = kieSession;
    }

    @Override
    public void internalAfterPropertiesSet() throws Exception {
        if (this.factoryBean.getBatch() != null && !this.factoryBean.getBatch().isEmpty()) {
            this.commands = this.factoryBean.getBatch();
        }
    }

    @Override
    public Object internalGetObject() {
        return this.commands == null ? this.kieSession : new DelegateStatelessKieSession(this.kieSession, this.commands);
    }

    @Override
    public Object internalNewObject() {
        if (this.kieBase != null) {
            return this.kieBase.newStatelessKieSession(this.factoryBean.getConf());
        }
        return null;
    }

    public static class DelegateStatelessKieSession
    implements StatelessKieSession {
        private final StatelessKieSession delegate;
        private final List<Command<?>> commands;

        public DelegateStatelessKieSession(StatelessKieSession delegate, List<Command<?>> commands) {
            this.delegate = delegate;
            this.commands = commands;
        }

        public Globals getGlobals() {
            return this.delegate.getGlobals();
        }

        public void setGlobal(String s, Object o) {
            this.delegate.setGlobal(s, o);
        }

        public void registerChannel(String s, Channel channel) {
            this.delegate.registerChannel(s, channel);
        }

        public void unregisterChannel(String s) {
            this.delegate.unregisterChannel(s);
        }

        public Map<String, Channel> getChannels() {
            return this.delegate.getChannels();
        }

        public KieBase getKieBase() {
            return this.delegate.getKieBase();
        }

        public KieRuntimeLogger getLogger() {
            return this.delegate.getLogger();
        }

        public void addEventListener(ProcessEventListener processEventListener) {
            this.delegate.addEventListener(processEventListener);
        }

        public void removeEventListener(ProcessEventListener processEventListener) {
            this.delegate.removeEventListener(processEventListener);
        }

        public Collection<ProcessEventListener> getProcessEventListeners() {
            return this.delegate.getProcessEventListeners();
        }

        public void addEventListener(RuleRuntimeEventListener ruleRuntimeEventListener) {
            this.delegate.addEventListener(ruleRuntimeEventListener);
        }

        public void removeEventListener(RuleRuntimeEventListener ruleRuntimeEventListener) {
            this.delegate.removeEventListener(ruleRuntimeEventListener);
        }

        public Collection<RuleRuntimeEventListener> getRuleRuntimeEventListeners() {
            return this.delegate.getRuleRuntimeEventListeners();
        }

        public void addEventListener(AgendaEventListener agendaEventListener) {
            this.delegate.addEventListener(agendaEventListener);
        }

        public void removeEventListener(AgendaEventListener agendaEventListener) {
            this.delegate.removeEventListener(agendaEventListener);
        }

        public Collection<AgendaEventListener> getAgendaEventListeners() {
            return this.delegate.getAgendaEventListeners();
        }

        public <T> T execute(Command<T> command) {
            KieCommands kieCommands = KieServices.Factory.get().getCommands();
            ArrayList cmds = new ArrayList();
            cmds.addAll(this.commands);
            cmds.add(command);
            return (T)this.delegate.execute((Command)CommandFactory.newBatchExecution(cmds));
        }

        public void execute(Object object) {
            KieCommands kieCommands = KieServices.Factory.get().getCommands();
            ArrayList<Object> cmds = new ArrayList<Object>();
            cmds.addAll(this.commands);
            cmds.add(kieCommands.newInsert(object));
            cmds.add(kieCommands.newFireAllRules());
            this.delegate.execute((Command)CommandFactory.newBatchExecution(cmds));
        }

        public void execute(Iterable objects) {
            KieCommands kieCommands = KieServices.Factory.get().getCommands();
            ArrayList<Object> cmds = new ArrayList<Object>();
            cmds.addAll(this.commands);
            for (Object object : objects) {
                cmds.add(kieCommands.newInsert(object));
            }
            cmds.add(kieCommands.newFireAllRules());
            this.delegate.execute((Command)CommandFactory.newBatchExecution(cmds));
        }
    }
}

