/*
 * Decompiled with CFR 0.152.
 */
package org.kurento.jsonrpc.internal.server;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;

class BeanCreatingHelper<T>
implements BeanFactoryAware {
    private static final Logger logger = LoggerFactory.getLogger(BeanCreatingHelper.class);
    private AutowireCapableBeanFactory beanFactory;
    private final Class<? extends T> beanType;
    private final String beanName;
    private Class<?> createdBeanType;

    public BeanCreatingHelper(Class<? extends T> handlerType, String beanName) {
        this.beanType = handlerType;
        this.beanName = beanName;
        this.createdBeanType = this.beanType;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        if (beanFactory instanceof AutowireCapableBeanFactory) {
            this.beanFactory = (AutowireCapableBeanFactory)beanFactory;
        }
    }

    public Class<?> getCreatedBeanType() {
        return this.createdBeanType;
    }

    public void setCreatedBeanType(Class<?> createdBeanType) {
        this.createdBeanType = createdBeanType;
    }

    public T createBean() {
        if (logger.isTraceEnabled()) {
            logger.trace("Creating instance for handler type {}", this.beanType);
        }
        if (this.beanFactory == null) {
            logger.warn("No BeanFactory available, attempting to use default constructor");
            return (T)BeanUtils.instantiate(this.beanType);
        }
        if (this.beanType != null) {
            return (T)this.beanFactory.createBean(this.beanType);
        }
        Object bean = this.beanFactory.getBean(this.beanName);
        this.createdBeanType = bean.getClass();
        return (T)bean;
    }

    public void destroy(T handler) {
        if (this.beanFactory != null) {
            if (logger.isTraceEnabled()) {
                logger.trace("Destroying handler instance {}", handler);
            }
            this.beanFactory.destroyBean(handler);
        }
    }

    public String toString() {
        return "BeanCreatingHelper [beanType=" + this.beanType + ", beanName=" + this.beanName + "]";
    }
}

