/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.markup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.languagetool.markup.AnnotatedText;
import org.languagetool.markup.TextPart;

public class AnnotatedTextBuilder {
    private final List<TextPart> parts = new ArrayList<TextPart>();

    public AnnotatedTextBuilder addText(String text) {
        this.parts.add(new TextPart(text, TextPart.Type.TEXT));
        return this;
    }

    public AnnotatedTextBuilder addMarkup(String markup) {
        this.parts.add(new TextPart(markup, TextPart.Type.MARKUP));
        return this;
    }

    public AnnotatedText build() {
        int plainTextPosition = 0;
        int totalPosition = 0;
        HashMap<Integer, Integer> mapping = new HashMap<Integer, Integer>();
        mapping.put(0, 0);
        for (TextPart part : this.parts) {
            if (part.getType().equals((Object)TextPart.Type.TEXT)) {
                plainTextPosition += part.getPart().length();
                totalPosition += part.getPart().length();
            } else if (part.getType().equals((Object)TextPart.Type.MARKUP)) {
                totalPosition += part.getPart().length();
            }
            mapping.put(plainTextPosition, totalPosition);
        }
        return new AnnotatedText(this.parts, mapping);
    }
}

