/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.rules.Rule;
import org.languagetool.tools.StringTools;

public class RuleMatch
implements Comparable<RuleMatch> {
    private static final Pattern SUGGESTION_PATTERN = Pattern.compile("<suggestion>(.*?)</suggestion>");
    private int fromLine = -1;
    private int column = -1;
    private int offset = -1;
    private int endLine = -1;
    private int endColumn = -1;
    private final Rule rule;
    private final int fromPos;
    private final int toPos;
    private final String message;
    private final String shortMessage;
    private List<String> suggestedReplacements = new ArrayList<String>();

    public RuleMatch(Rule rule, int fromPos, int toPos, String message) {
        this(rule, fromPos, toPos, message, null, false, null);
    }

    public RuleMatch(Rule rule, int fromPos, int toPos, String message, String shortMessage) {
        this(rule, fromPos, toPos, message, shortMessage, false, null);
    }

    public RuleMatch(Rule rule, int fromPos, int toPos, String message, String shortMessage, boolean startWithUppercase, String suggestionsOutMsg) {
        this.rule = rule;
        this.fromPos = fromPos;
        this.toPos = toPos;
        this.message = message;
        this.shortMessage = shortMessage;
        Matcher matcher = SUGGESTION_PATTERN.matcher(message + suggestionsOutMsg);
        int pos = 0;
        while (matcher.find(pos)) {
            pos = matcher.end();
            String replacement = matcher.group(1);
            if (startWithUppercase) {
                replacement = StringTools.uppercaseFirstChar(replacement);
            }
            this.suggestedReplacements.add(replacement);
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    public void setLine(int fromLine) {
        this.fromLine = fromLine;
    }

    public int getLine() {
        return this.fromLine;
    }

    public void setEndLine(int endLine) {
        this.endLine = endLine;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public void setColumn(int column) {
        this.column = column;
    }

    public int getColumn() {
        return this.column;
    }

    public void setEndColumn(int endColumn) {
        this.endColumn = endColumn;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getFromPos() {
        return this.fromPos;
    }

    public int getToPos() {
        return this.toPos;
    }

    public String getMessage() {
        return this.message;
    }

    public String getShortMessage() {
        return this.shortMessage;
    }

    public void setSuggestedReplacement(String replacement) {
        Objects.requireNonNull(replacement, "replacement may be empty but not null");
        ArrayList<String> replacements = new ArrayList<String>();
        replacements.add(replacement);
        this.setSuggestedReplacements(replacements);
    }

    public void setSuggestedReplacements(List<String> replacements) {
        this.suggestedReplacements = Objects.requireNonNull(replacements, "replacements may be empty but not null");
    }

    public List<String> getSuggestedReplacements() {
        return this.suggestedReplacements;
    }

    public String toString() {
        return this.rule.getId() + ":" + this.fromPos + "-" + this.toPos + ":" + this.message;
    }

    @Override
    public int compareTo(RuleMatch other) {
        Objects.requireNonNull(other);
        return Integer.compare(this.getFromPos(), other.getFromPos());
    }
}

