/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.patterns;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.patterns.AbstractPatternRulePerformer;
import org.languagetool.rules.patterns.ElementMatcher;
import org.languagetool.rules.patterns.Match;
import org.languagetool.rules.patterns.MatchState;
import org.languagetool.rules.patterns.PatternRule;
import org.languagetool.tools.StringTools;

class PatternRuleMatcher
extends AbstractPatternRulePerformer {
    private static final String SUGGESTION_START_TAG = "<suggestion>";
    private static final String SUGGESTION_END_TAG = "</suggestion>";
    private static final String MISTAKE = "<mistake/>";
    private final boolean useList;

    PatternRuleMatcher(PatternRule rule, boolean useList) {
        super(rule, rule.getLanguage().getUnifier());
        this.useList = useList;
    }

    final RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        List<ElementMatcher> elementMatchers = this.createElementMatchers();
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
        int[] tokenPositions = new int[tokens.length + 1];
        int patternSize = elementMatchers.size();
        int limit = Math.max(0, tokens.length - patternSize + 1);
        ElementMatcher elem = null;
        int minOccurCorrection = this.getMinOccurrenceCorrection();
        for (int i = 0; !(i >= limit + minOccurCorrection || this.rule.sentStart && i > 0); ++i) {
            RuleMatch ruleMatch;
            int skipShiftTotal = 0;
            boolean allElementsMatch = false;
            int firstMatchToken = -1;
            int firstMarkerMatchToken = -1;
            int lastMatchToken = -1;
            int lastMarkerMatchToken = -1;
            int matchingTokens = 0;
            int prevSkipNext = 0;
            if (this.rule.testUnification) {
                this.unifier.reset();
            }
            int minOccurSkip = 0;
            for (int k = 0; k < patternSize; ++k) {
                ElementMatcher prevElement = elem;
                elem = elementMatchers.get(k);
                elem.resolveReference(firstMatchToken, tokens, this.rule.getLanguage());
                int nextPos = i + k + skipShiftTotal - minOccurSkip;
                this.prevMatched = false;
                if (prevSkipNext + nextPos >= tokens.length || prevSkipNext < 0) {
                    prevSkipNext = tokens.length - (nextPos + 1);
                }
                int maxTok = Math.min(nextPos + prevSkipNext, tokens.length - (patternSize - k) + minOccurCorrection);
                for (int m = nextPos; m <= maxTok; ++m) {
                    boolean bl = allElementsMatch = !tokens[m].isImmunized() && this.testAllReadings(tokens, elem, prevElement, m, firstMatchToken, prevSkipNext);
                    if (elem.getElement().getMinOccurrence() == 0) {
                        boolean nextElementMatch;
                        ElementMatcher nextElement = elementMatchers.get(k + 1);
                        boolean bl2 = nextElementMatch = !tokens[m].isImmunized() && this.testAllReadings(tokens, nextElement, elem, m, firstMatchToken, prevSkipNext);
                        if (nextElementMatch) {
                            allElementsMatch = true;
                            ++minOccurSkip;
                            break;
                        }
                    }
                    if (!allElementsMatch) continue;
                    int skipForMax = this.skipMaxTokens(tokens, elem, firstMatchToken, prevSkipNext, prevElement, m, patternSize - k - 1);
                    lastMatchToken = m + skipForMax;
                    int skipShift = lastMatchToken - nextPos;
                    tokenPositions[matchingTokens] = skipShift + 1;
                    prevSkipNext = this.translateElementNo(elem.getElement().getSkipNext());
                    ++matchingTokens;
                    skipShiftTotal += skipShift;
                    if (firstMatchToken == -1) {
                        firstMatchToken = lastMatchToken - skipForMax;
                    }
                    if (firstMarkerMatchToken == -1 && elem.getElement().isInsideMarker()) {
                        firstMarkerMatchToken = lastMatchToken - skipForMax;
                    }
                    if (!elem.getElement().isInsideMarker()) break;
                    lastMarkerMatchToken = lastMatchToken;
                    break;
                }
                if (!allElementsMatch) break;
            }
            if ((!allElementsMatch || matchingTokens != patternSize) && (matchingTokens != patternSize - minOccurSkip || firstMatchToken == -1) || (ruleMatch = this.createRuleMatch(tokenPositions, tokens, firstMatchToken, lastMatchToken, firstMarkerMatchToken, lastMarkerMatchToken)) == null) continue;
            ruleMatches.add(ruleMatch);
        }
        return ruleMatches.toArray(new RuleMatch[ruleMatches.size()]);
    }

    private RuleMatch createRuleMatch(int[] tokenPositions, AnalyzedTokenReadings[] tokens, int firstMatchToken, int lastMatchToken, int firstMarkerMatchToken, int lastMarkerMatchToken) throws IOException {
        AnalyzedTokenReadings token;
        int toPos;
        AnalyzedTokenReadings firstMatchTokenObj;
        boolean startsWithUppercase;
        int idx;
        PatternRule rule = (PatternRule)this.rule;
        String errMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, rule.getMessage(), rule.getSuggestionMatches());
        String shortErrMessage = this.formatMatches(tokens, tokenPositions, firstMatchToken, rule.getShortMessage(), rule.getSuggestionMatches());
        String suggestionsOutMsg = this.formatMatches(tokens, tokenPositions, firstMatchToken, rule.getSuggestionsOutMsg(), rule.getSuggestionMatchesOutMsg());
        int correctedStPos = 0;
        if (rule.startPositionCorrection > 0) {
            for (int l = 0; l <= rule.startPositionCorrection; ++l) {
                correctedStPos += tokenPositions[l];
            }
            --correctedStPos;
        }
        if ((idx = firstMatchToken + correctedStPos) >= tokens.length) {
            idx = tokens.length - 1;
        }
        boolean bl = startsWithUppercase = StringTools.startsWithUppercase((firstMatchTokenObj = tokens[idx]).getToken()) && this.matchPreservesCase(rule.getSuggestionMatches(), rule.getMessage()) && this.matchPreservesCase(rule.getSuggestionMatchesOutMsg(), rule.getSuggestionsOutMsg());
        if (firstMatchTokenObj.isSentenceStart() && tokens.length > firstMatchToken + correctedStPos + 1) {
            firstMatchTokenObj = tokens[firstMatchToken + correctedStPos + 1];
            startsWithUppercase = StringTools.startsWithUppercase(firstMatchTokenObj.getToken());
        }
        if (firstMarkerMatchToken == -1) {
            firstMarkerMatchToken = firstMatchToken;
        }
        int fromPos = tokens[firstMarkerMatchToken].getStartPos();
        if (errMessage.contains("<suggestion>,") && firstMarkerMatchToken >= 1) {
            fromPos = tokens[firstMarkerMatchToken - 1].getStartPos() + tokens[firstMarkerMatchToken - 1].getToken().length();
        }
        if (lastMarkerMatchToken == -1) {
            lastMarkerMatchToken = lastMatchToken;
        }
        if (!(fromPos >= (toPos = (token = tokens[Math.min(lastMarkerMatchToken, tokens.length - 1)]).getStartPos() + token.getToken().length()) || errMessage.contains("<pleasespellme/>") && errMessage.contains(MISTAKE))) {
            String clearMsg = errMessage.replaceAll("<pleasespellme/>", "").replaceAll(MISTAKE, "");
            return new RuleMatch(rule, fromPos, toPos, clearMsg, shortErrMessage, startsWithUppercase, suggestionsOutMsg);
        }
        return null;
    }

    private boolean matchPreservesCase(List<Match> suggestionMatches, String msg) {
        if (suggestionMatches != null && !suggestionMatches.isEmpty()) {
            int sugStart = msg.indexOf(SUGGESTION_START_TAG) + SUGGESTION_START_TAG.length();
            for (Match sMatch : suggestionMatches) {
                if (sMatch.isInMessageOnly() || !sMatch.convertsCase() || msg.charAt(sugStart) != '\\') continue;
                return false;
            }
        }
        return true;
    }

    private int translateElementNo(int i) {
        if (!this.useList || i < 0) {
            return i;
        }
        int j = 0;
        PatternRule rule = (PatternRule)this.rule;
        for (int k = 0; k < i; ++k) {
            j += rule.getElementNo().get(k).intValue();
        }
        return j;
    }

    private String formatMatches(AnalyzedTokenReadings[] tokenReadings, int[] positions, int firstMatchTok, String errorMsg, List<Match> suggestionMatches) throws IOException {
        String errorMessage = errorMsg;
        int matchCounter = 0;
        int[] numbersToMatches = new int[errorMsg.length()];
        boolean newWay = false;
        int errLen = errorMessage.length();
        int errMarker = errorMessage.indexOf(92);
        boolean numberFollows = false;
        if (errMarker >= 0 && errMarker < errLen - 1) {
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        while (errMarker >= 0 && numberFollows) {
            int backslashPos = errorMessage.indexOf(92);
            if (backslashPos >= 0 && StringTools.isPositiveNumber(errorMessage.charAt(backslashPos + 1))) {
                int numLen = 1;
                while (backslashPos + numLen < errorMessage.length() && StringTools.isPositiveNumber(errorMessage.charAt(backslashPos + numLen))) {
                    ++numLen;
                }
                int j = Integer.parseInt(errorMessage.substring(backslashPos + 1, backslashPos + numLen)) - 1;
                int repTokenPos = 0;
                int nextTokenPos = 0;
                for (int l = 0; l <= j; ++l) {
                    repTokenPos += positions[l];
                }
                if (j <= positions.length) {
                    nextTokenPos = firstMatchTok + repTokenPos + positions[j + 1];
                }
                if (suggestionMatches != null) {
                    if (matchCounter < suggestionMatches.size()) {
                        numbersToMatches[j] = matchCounter;
                        if (suggestionMatches.get(matchCounter) != null) {
                            String[] matches = this.concatMatches(matchCounter, j, firstMatchTok + repTokenPos, tokenReadings, nextTokenPos, suggestionMatches);
                            String leftSide = errorMessage.substring(0, backslashPos);
                            String rightSide = errorMessage.substring(backslashPos + numLen);
                            errorMessage = matches.length == 1 ? leftSide + matches[0] + rightSide : PatternRuleMatcher.formatMultipleSynthesis(matches, leftSide, rightSide);
                            ++matchCounter;
                            newWay = true;
                        }
                    } else {
                        suggestionMatches.add(suggestionMatches.get(numbersToMatches[j]));
                    }
                }
                if (!newWay) {
                    errorMessage = errorMessage.replace("\\" + (j + 1), tokenReadings[firstMatchTok + repTokenPos - 1].getToken());
                }
            }
            errMarker = errorMessage.indexOf(92);
            numberFollows = false;
            errLen = errorMessage.length();
            if (errMarker < 0 || errMarker >= errLen - 1) continue;
            numberFollows = StringTools.isPositiveNumber(errorMessage.charAt(errMarker + 1));
        }
        return errorMessage;
    }

    private static String formatMultipleSynthesis(String[] matches, String leftSide, String rightSide) {
        String suggestionLeft = "";
        String suggestionRight = "";
        String rightSideNew = rightSide;
        int sPos = leftSide.lastIndexOf(SUGGESTION_START_TAG);
        if (sPos > 0) {
            suggestionLeft = leftSide.substring(sPos + SUGGESTION_START_TAG.length());
        }
        String errorMessage = StringTools.isEmpty(suggestionLeft) ? leftSide : leftSide.substring(0, leftSide.lastIndexOf(SUGGESTION_START_TAG)) + SUGGESTION_START_TAG;
        int rPos = rightSide.indexOf(SUGGESTION_END_TAG);
        if (rPos > 0) {
            suggestionRight = rightSide.substring(0, rPos);
        }
        if (!StringTools.isEmpty(suggestionRight)) {
            rightSideNew = rightSide.substring(rightSide.indexOf(SUGGESTION_END_TAG));
        }
        int lastLeftSugEnd = leftSide.indexOf(SUGGESTION_END_TAG);
        int lastLeftSugStart = leftSide.lastIndexOf(SUGGESTION_START_TAG);
        StringBuilder sb = new StringBuilder();
        sb.append(errorMessage);
        for (int z = 0; z < matches.length; ++z) {
            sb.append(suggestionLeft);
            sb.append(matches[z]);
            sb.append(suggestionRight);
            if (z >= matches.length - 1 || lastLeftSugEnd >= lastLeftSugStart) continue;
            sb.append(SUGGESTION_END_TAG);
            sb.append(", ");
            sb.append(SUGGESTION_START_TAG);
        }
        sb.append(rightSideNew);
        return sb.toString();
    }

    private String[] concatMatches(int start, int index, int tokenIndex, AnalyzedTokenReadings[] tokens, int nextTokenPos, List<Match> suggestionMatches) throws IOException {
        String[] finalMatch = null;
        if (suggestionMatches.get(start) != null) {
            int len = this.phraseLen(index);
            Language language = this.rule.language;
            if (len == 1) {
                int skippedTokens = nextTokenPos - tokenIndex;
                MatchState matchState = suggestionMatches.get(start).createState(language.getSynthesizer(), tokens, tokenIndex - 1, skippedTokens);
                finalMatch = matchState.toFinalString(language);
                if (suggestionMatches.get(start).checksSpelling() && finalMatch.length == 1 && "".equals(finalMatch[0])) {
                    finalMatch = new String[]{MISTAKE};
                }
            } else {
                ArrayList<String[]> matchList = new ArrayList<String[]>();
                for (int i = 0; i < len; ++i) {
                    int skippedTokens = nextTokenPos - (tokenIndex + i);
                    MatchState matchState = suggestionMatches.get(start).createState(language.getSynthesizer(), tokens, tokenIndex - 1 + i, skippedTokens);
                    matchList.add(matchState.toFinalString(language));
                }
                return PatternRuleMatcher.combineLists((String[][])matchList.toArray((T[])new String[matchList.size()][]), new String[matchList.size()], 0, language);
            }
        }
        return finalMatch;
    }

    private int phraseLen(int i) {
        PatternRule rule = (PatternRule)this.rule;
        List<Integer> elementNo = rule.getElementNo();
        if (!this.useList || i > elementNo.size() - 1) {
            return 1;
        }
        return elementNo.get(i);
    }

    private static String[] combineLists(String[][] input, String[] output, int r, Language lang) {
        ArrayList<String> outputList = new ArrayList<String>();
        if (r == input.length) {
            StringBuilder sb = new StringBuilder();
            for (int k = 0; k < output.length; ++k) {
                sb.append(output[k]);
                if (k >= output.length - 1) continue;
                sb.append(StringTools.addSpace(output[k + 1], lang));
            }
            outputList.add(sb.toString());
        } else {
            for (int c = 0; c < input[r].length; ++c) {
                output[r] = input[r][c];
                String[] sList = PatternRuleMatcher.combineLists(input, output, r + 1, lang);
                outputList.addAll(Arrays.asList(sList));
            }
        }
        return outputList.toArray(new String[outputList.size()]);
    }
}

