/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Scanner;
import java.util.Set;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;
import org.languagetool.tokenizers.WordTokenizer;

public abstract class SpellingCheckRule
extends Rule {
    public static final String LANGUAGETOOL = "LanguageTool";
    public static final String LANGUAGETOOL_FX = "LanguageToolFx";
    protected final Language language;
    private static final String SPELLING_IGNORE_FILE = "/hunspell/ignore.txt";
    private final Set<String> wordsToBeIgnored = new HashSet<String>();
    private boolean wordsWithDotsPresent = false;
    private boolean considerIgnoreWords = true;
    private boolean convertsCase = false;

    public SpellingCheckRule(ResourceBundle messages, Language language) {
        super(messages);
        this.language = language;
        this.setLocQualityIssueType(ITSIssueType.Misspelling);
    }

    @Override
    public abstract String getId();

    @Override
    public abstract String getDescription();

    @Override
    public abstract RuleMatch[] match(AnalyzedSentence var1) throws IOException;

    @Override
    public boolean isSpellingRule() {
        return true;
    }

    @Override
    public boolean isDictionaryBasedSpellingRule() {
        return true;
    }

    @Override
    public void reset() {
    }

    public void addIgnoreTokens(List<String> tokens) {
        this.wordsToBeIgnored.addAll(tokens);
    }

    public void setConsiderIgnoreWords(boolean considerIgnoreWords) {
        this.considerIgnoreWords = considerIgnoreWords;
    }

    public void resetIgnoreTokens() {
        this.wordsToBeIgnored.clear();
        try {
            this.init();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean ignoreToken(AnalyzedTokenReadings[] tokens, int idx) throws IOException {
        return this.ignoreWord(tokens[idx].getToken());
    }

    protected List<String> getAdditionalSuggestions(List<String> suggestions, String word) {
        ArrayList<String> moreSuggestions = new ArrayList<String>();
        if ("Languagetool".equals(word) && !suggestions.contains(LANGUAGETOOL)) {
            moreSuggestions.add(LANGUAGETOOL);
        }
        return moreSuggestions;
    }

    protected boolean ignoreWord(String word) throws IOException {
        if (!this.considerIgnoreWords) {
            return false;
        }
        if (!this.wordsWithDotsPresent) {
            word = word.endsWith(".") ? word.substring(0, word.length() - 1) : word;
        }
        return this.wordsToBeIgnored.contains(word) || this.convertsCase && this.wordsToBeIgnored.contains(word.toLowerCase(this.language.getLocale()));
    }

    public boolean isConvertsCase() {
        return this.convertsCase;
    }

    public void setConvertsCase(boolean convertsCase) {
        this.convertsCase = convertsCase;
    }

    protected boolean isUrl(String token) {
        for (String protocol : WordTokenizer.getProtocols()) {
            if (!token.startsWith(protocol + "://")) continue;
            return true;
        }
        return false;
    }

    protected void init() throws IOException {
        this.loadFileIfExists(this.language.getShortName() + SPELLING_IGNORE_FILE);
    }

    private void loadFileIfExists(String filename) throws IOException {
        boolean ignoreFileExists = JLanguageTool.getDataBroker().resourceExists(filename);
        if (!ignoreFileExists) {
            return;
        }
        this.loadWordsToBeIgnored(filename);
    }

    private void loadWordsToBeIgnored(String ignoreFile) throws IOException {
        try (InputStream inputStream = JLanguageTool.getDataBroker().getFromResourceDirAsStream(ignoreFile);
             Scanner scanner = new Scanner(inputStream, "utf-8");){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                boolean isComment = line.startsWith("#");
                if (isComment) continue;
                if (this.language.getShortNameWithCountryAndVariant().equals("de-CH")) {
                    this.wordsToBeIgnored.add(line.replace("\u00df", "ss"));
                } else {
                    this.wordsToBeIgnored.add(line);
                }
                if (!line.endsWith(".")) continue;
                this.wordsWithDotsPresent = true;
            }
        }
    }
}

