/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.languagetool.Language;
import org.languagetool.rules.Rule;
import org.languagetool.rules.patterns.PatternRule;

public class SuggestionExtractor {
    private static final Pattern SUGGESTION_PATTERN = Pattern.compile("<suggestion.*?>(.*?)</suggestion>");
    private static final Pattern BACK_REFERENCE_PATTERN = Pattern.compile("\\\\\\d+");

    public List<String> getSuggestionTokens(Rule rule, Language language) {
        ArrayList<String> wordsToBeIgnored = new ArrayList<String>();
        if (rule instanceof PatternRule) {
            PatternRule patternRule = (PatternRule)rule;
            String message = patternRule.getMessage();
            List<String> suggestions = this.getSimpleSuggestions(message);
            List<String> tokens = this.getSuggestionTokens(suggestions, language);
            wordsToBeIgnored.addAll(tokens);
        }
        return wordsToBeIgnored;
    }

    List<String> getSimpleSuggestions(String message) {
        Matcher matcher = SUGGESTION_PATTERN.matcher(message);
        int startPos = 0;
        ArrayList<String> suggestions = new ArrayList<String>();
        while (matcher.find(startPos)) {
            String suggestion = matcher.group(1);
            startPos = matcher.end();
            if (!this.isSimpleSuggestion(suggestion)) continue;
            suggestions.add(suggestion);
        }
        return suggestions;
    }

    private boolean isSimpleSuggestion(String suggestion) {
        if (suggestion.contains("<match")) {
            return false;
        }
        Matcher matcher = BACK_REFERENCE_PATTERN.matcher(suggestion);
        return !matcher.find();
    }

    private List<String> getSuggestionTokens(List<String> suggestions, Language language) {
        ArrayList<String> tokens = new ArrayList<String>();
        for (String suggestion : suggestions) {
            List<String> suggestionTokens = language.getWordTokenizer().tokenize(suggestion);
            for (String suggestionToken : suggestionTokens) {
                if (suggestionToken.trim().isEmpty()) continue;
                tokens.add(suggestionToken);
            }
        }
        return tokens;
    }
}

