/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.trigger;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.trigger.ChangedTriggerChangeGenerator;
import com.datical.liquibase.ext.storedlogic.trigger.Trigger;
import com.datical.liquibase.ext.storedlogic.trigger.change.CreateTriggerChange;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.ObjectDifferences;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.license.LicenseServiceUtils;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;

@LiquibaseService
public class ChangedTriggerExternalFileChangeGenerator
extends ChangedTriggerChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class).getInlineSql() && Trigger.class.isAssignableFrom(clazz)) {
            if (!LicenseServiceUtils.checkForValidLicense("Liquibase Pro")) {
                return -1;
            }
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixChanged(DatabaseObject databaseObject, ObjectDifferences changeArray, DiffOutputControl changeArray2, Database database, Database database2, ChangeGeneratorChain object) {
        if ((changeArray = super.fixChanged(databaseObject, (ObjectDifferences)changeArray, (DiffOutputControl)changeArray2, database, database2, (ChangeGeneratorChain)object)) == null || changeArray.length == 0) {
            return null;
        }
        changeArray2 = changeArray;
        int n2 = changeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            object = changeArray2[i2];
            if (!(object instanceof CreateTriggerChange)) continue;
            object = (CreateTriggerChange)object;
            ((CreateProcedureChange)object).setRelativeToChangelogFile(Boolean.TRUE);
            ((CreateProcedureChange)object).setPath(ObjectSqlFileUtil.writeObjectSql((Trigger)databaseObject));
            ((CreateTriggerChange)object).setTriggerBody(null);
        }
        return changeArray;
    }
}

