/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.storedlogic.storedproc;

import com.datical.liquibase.ext.config.LiquibaseProConfiguration;
import com.datical.liquibase.ext.storedlogic.storedproc.MissingStoredProcedureChangeGenerator;
import com.datical.liquibase.ext.util.ObjectSqlFileUtil;
import liquibase.change.Change;
import liquibase.change.core.CreateProcedureChange;
import liquibase.configuration.LiquibaseConfiguration;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.servicelocator.LiquibaseService;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;

@LiquibaseService
public class MissingStoredProcedureExternalFileChangeGenerator
extends MissingStoredProcedureChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> clazz, Database database) {
        if (!LiquibaseConfiguration.getInstance().getConfiguration(LiquibaseProConfiguration.class).getInlineSql() && StoredProcedure.class.isAssignableFrom(clazz)) {
            return super.getPriority(clazz, database) + 100;
        }
        return -1;
    }

    @Override
    public Change[] fixMissing(DatabaseObject databaseObject, DiffOutputControl changeArray, Database object, Database database, ChangeGeneratorChain changeGeneratorChain) {
        changeArray = super.fixMissing(databaseObject, (DiffOutputControl)changeArray, (Database)object, database, changeGeneratorChain);
        object = MissingStoredProcedureExternalFileChangeGenerator.findChange(CreateProcedureChange.class, changeArray);
        ((CreateProcedureChange)object).setRelativeToChangelogFile(Boolean.TRUE);
        ((CreateProcedureChange)object).setPath(ObjectSqlFileUtil.writeObjectSql((StoredProcedure)databaseObject));
        ((CreateProcedureChange)object).setProcedureText(null);
        return changeArray;
    }
}

