/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import liquibase.Scope;
import liquibase.command.LiquibaseCommand;
import liquibase.exception.UnexpectedLiquibaseException;

public class CommandFactory {
    private static CommandFactory instance;
    private List<LiquibaseCommand> commands = new ArrayList<LiquibaseCommand>();

    private CommandFactory() {
        try {
            for (LiquibaseCommand command : Scope.getCurrentScope().getServiceLocator().findInstances(LiquibaseCommand.class)) {
                this.register(command);
            }
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    public static synchronized CommandFactory getInstance() {
        if (instance == null) {
            instance = new CommandFactory();
        }
        return instance;
    }

    public static synchronized void reset() {
        instance = new CommandFactory();
    }

    public LiquibaseCommand getCommand(final String commandName) {
        Comparator<LiquibaseCommand> commandComparator = new Comparator<LiquibaseCommand>(){

            @Override
            public int compare(LiquibaseCommand o1, LiquibaseCommand o2) {
                return Integer.valueOf(o2.getPriority(commandName)).compareTo(o1.getPriority(commandName));
            }
        };
        ArrayList<LiquibaseCommand> sortedCommands = new ArrayList<LiquibaseCommand>(this.commands);
        Collections.sort(sortedCommands, commandComparator);
        if (sortedCommands.isEmpty()) {
            throw new UnexpectedLiquibaseException("Could not find command class for " + commandName);
        }
        try {
            LiquibaseCommand command = (LiquibaseCommand)((LiquibaseCommand)sortedCommands.iterator().next()).getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            if (command.getPriority(commandName) <= 0) {
                throw new UnexpectedLiquibaseException("Could not find command class for " + commandName);
            }
            return command;
        }
        catch (Exception e2) {
            throw new UnexpectedLiquibaseException(e2);
        }
    }

    public void register(LiquibaseCommand command) {
        this.commands.add(command);
    }

    public void unregister(LiquibaseCommand command) {
        this.commands.remove(command);
    }
}

