/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core;

import java.io.PrintStream;
import liquibase.Scope;
import liquibase.command.CommandResult;
import liquibase.command.core.DiffToChangeLogCommand;
import liquibase.command.core.SnapshotCommand;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.util.StringUtil;

public class GenerateChangeLogCommand
extends DiffToChangeLogCommand {
    private static final String INFO_MESSAGE = "When generating formatted SQL changelogs, it is important to decide if batched statements\nshould be split (splitStatements:true is the default behavior) or not (splitStatements:false).\nSee http://liquibase.org for additional documentation.";
    private String author;
    private String context;

    @Override
    public String getName() {
        return "generateChangeLog";
    }

    public String getAuthor() {
        return this.author;
    }

    public GenerateChangeLogCommand setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getContext() {
        return this.context;
    }

    public GenerateChangeLogCommand setContext(String context) {
        this.context = context;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected CommandResult run() throws Exception {
        String changeLogFile = StringUtil.trimToNull(this.getChangeLogFile());
        if (changeLogFile.toLowerCase().endsWith(".sql")) {
            Scope.getCurrentScope().getUI().sendMessage("\nWhen generating formatted SQL changelogs, it is important to decide if batched statements\nshould be split (splitStatements:true is the default behavior) or not (splitStatements:false).\nSee http://liquibase.org for additional documentation.\n");
            Scope.getCurrentScope().getLog(this.getClass()).info("\nWhen generating formatted SQL changelogs, it is important to decide if batched statements\nshould be split (splitStatements:true is the default behavior) or not (splitStatements:false).\nSee http://liquibase.org for additional documentation.\n");
        }
        SnapshotCommand.logUnsupportedDatabase(this.getReferenceDatabase(), this.getClass());
        DiffResult diffResult = this.createDiffResult();
        DiffToChangeLog changeLogWriter = new DiffToChangeLog(diffResult, this.getDiffOutputControl());
        changeLogWriter.setChangeSetAuthor(this.author);
        changeLogWriter.setChangeSetContext(this.context);
        changeLogWriter.setChangeSetPath(this.getChangeLogFile());
        ObjectQuotingStrategy originalStrategy = this.getReferenceDatabase().getObjectQuotingStrategy();
        try {
            this.getReferenceDatabase().setObjectQuotingStrategy(ObjectQuotingStrategy.QUOTE_ALL_OBJECTS);
            if (StringUtil.trimToNull(this.getChangeLogFile()) != null) {
                changeLogWriter.print(this.getChangeLogFile());
            } else {
                PrintStream outputStream = this.getOutputStream();
                if (outputStream == null) {
                    outputStream = System.out;
                }
                changeLogWriter.print(outputStream);
            }
        }
        finally {
            this.getReferenceDatabase().setObjectQuotingStrategy(originalStrategy);
        }
        return new CommandResult("OK");
    }

    @Override
    protected DatabaseSnapshot createTargetSnapshot() throws DatabaseException, InvalidExampleException {
        SnapshotControl snapshotControl = new SnapshotControl(this.getReferenceDatabase(), this.getSnapshotTypes());
        return SnapshotGeneratorFactory.getInstance().createSnapshot(this.getCompareControl().getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl);
    }
}

