/*
 * Decompiled with CFR 0.152.
 */
package org.littleshoot.proxy.impl;

import io.netty.util.concurrent.Future;
import org.littleshoot.proxy.impl.ConnectionFlow;
import org.littleshoot.proxy.impl.ConnectionState;
import org.littleshoot.proxy.impl.ProxyConnection;
import org.littleshoot.proxy.impl.ProxyConnectionLogger;

abstract class ConnectionFlowStep {
    private final ProxyConnectionLogger LOG;
    private final ProxyConnection connection;
    private final ConnectionState state;

    ConnectionFlowStep(ProxyConnection connection, ConnectionState state) {
        this.connection = connection;
        this.state = state;
        this.LOG = connection.getLOG();
    }

    ProxyConnection getConnection() {
        return this.connection;
    }

    ConnectionState getState() {
        return this.state;
    }

    boolean shouldSuppressInitialRequest() {
        return false;
    }

    boolean shouldExecuteOnEventLoop() {
        return true;
    }

    protected abstract Future execute();

    void onSuccess(ConnectionFlow flow) {
        flow.advance();
    }

    void read(ConnectionFlow flow, Object msg) {
        this.LOG.debug("Received message while in the middle of connecting: {}", msg);
    }

    public String toString() {
        return this.state.toString();
    }
}

