/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.util.reflection;

import java.lang.reflect.Field;
import org.mockito.internal.util.reflection.AccessibilityChanger;

public class FieldSetter {
    private FieldSetter() {
    }

    public static void setField(Object target, Field field, Object value) {
        AccessibilityChanger changer = new AccessibilityChanger();
        changer.enableAccess(field);
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Access not authorized on field '" + field + "' of object '" + target + "' with value: '" + value + "'", e);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Wrong argument on field '" + field + "' of object '" + target + "' with value: '" + value + "', \nreason : " + e.getMessage(), e);
        }
        changer.safelyDisableAccess(field);
    }
}

