/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.logic.completion;

import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.NonNull;
import org.nd4j.parameterserver.distributed.logic.completion.RequestDescriptor;
import org.nd4j.parameterserver.distributed.messages.VoidAggregation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class Clipboard {
    private static final Logger log = LoggerFactory.getLogger(Clipboard.class);
    protected Map<RequestDescriptor, VoidAggregation> clipboard = new ConcurrentHashMap<RequestDescriptor, VoidAggregation>();
    protected Queue<VoidAggregation> completedQueue = new ConcurrentLinkedQueue<VoidAggregation>();
    protected AtomicInteger trackingCounter = new AtomicInteger(0);
    protected AtomicInteger completedCounter = new AtomicInteger(0);

    public boolean pin(@NonNull VoidAggregation aggregation) {
        if (aggregation == null) {
            throw new NullPointerException("aggregation is marked @NonNull but is null");
        }
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(aggregation.getOriginatorId(), aggregation.getTaskId());
        VoidAggregation existing = this.clipboard.get(descriptor);
        if (existing == null) {
            existing = aggregation;
            this.trackingCounter.incrementAndGet();
            this.clipboard.put(descriptor, aggregation);
        }
        existing.accumulateAggregation(aggregation);
        int missing = existing.getMissingChunks();
        if (missing == 0) {
            this.completedCounter.incrementAndGet();
            return true;
        }
        return false;
    }

    public VoidAggregation unpin(@NonNull VoidAggregation aggregation) {
        if (aggregation == null) {
            throw new NullPointerException("aggregation is marked @NonNull but is null");
        }
        return this.unpin(aggregation.getOriginatorId(), aggregation.getTaskId());
    }

    public VoidAggregation unpin(long originatorId, long taskId) {
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(originatorId, taskId);
        VoidAggregation aggregation = this.clipboard.get(descriptor);
        if (aggregation != null) {
            this.clipboard.remove(descriptor);
            this.trackingCounter.decrementAndGet();
            return aggregation;
        }
        return null;
    }

    public boolean hasCandidates() {
        return this.completedCounter.get() > 0;
    }

    public VoidAggregation nextCandidate() {
        VoidAggregation result = this.completedQueue.poll();
        if (result != null) {
            this.completedCounter.decrementAndGet();
            this.unpin(result.getOriginatorId(), result.getTaskId());
        }
        return result;
    }

    public boolean isReady(VoidAggregation aggregation) {
        return this.isReady(aggregation.getOriginatorId(), aggregation.getTaskId());
    }

    public boolean isReady(long originatorId, long taskId) {
        RequestDescriptor descriptor = RequestDescriptor.createDescriptor(originatorId, taskId);
        VoidAggregation aggregation = this.clipboard.get(descriptor);
        if (aggregation == null) {
            return false;
        }
        return aggregation.getMissingChunks() == 0;
    }

    public boolean isTracking(long originatorId, long taskId) {
        return this.clipboard.containsKey(RequestDescriptor.createDescriptor(originatorId, taskId));
    }

    public int getNumberOfPinnedStacks() {
        return this.trackingCounter.get();
    }

    public int getNumberOfCompleteStacks() {
        return this.completedCounter.get();
    }

    public VoidAggregation getStackFromClipboard(long originatorId, long taskId) {
        return this.clipboard.get(RequestDescriptor.createDescriptor(originatorId, taskId));
    }
}

