/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.transport;

import io.aeron.Aeron;
import io.aeron.FragmentAssembler;
import io.aeron.driver.MediaDriver;
import lombok.NonNull;
import org.agrona.DirectBuffer;
import org.nd4j.linalg.exception.ND4JIllegalStateException;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.enums.NodeRole;
import org.nd4j.parameterserver.distributed.logic.completion.Clipboard;
import org.nd4j.parameterserver.distributed.messages.MeaningfulMessage;
import org.nd4j.parameterserver.distributed.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.transport.BaseTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MulticastTransport
extends BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(MulticastTransport.class);
    protected String multicastChannelUri;

    public MulticastTransport() {
        log.info("Initializing MulticastTransport");
    }

    @Override
    public void init(@NonNull VoidConfiguration voidConfiguration, @NonNull Clipboard clipboard, @NonNull NodeRole role, @NonNull String localIp, int localPort, short shardIndex) {
        if (voidConfiguration == null) {
            throw new NullPointerException("voidConfiguration is marked @NonNull but is null");
        }
        if (clipboard == null) {
            throw new NullPointerException("clipboard is marked @NonNull but is null");
        }
        if (role == null) {
            throw new NullPointerException("role is marked @NonNull but is null");
        }
        if (localIp == null) {
            throw new NullPointerException("localIp is marked @NonNull but is null");
        }
        if (voidConfiguration.getTtl() < 1) {
            throw new ND4JIllegalStateException("For MulticastTransport you should have TTL >= 1, it won't work otherwise");
        }
        if (voidConfiguration.getMulticastNetwork() == null || voidConfiguration.getMulticastNetwork().isEmpty()) {
            throw new ND4JIllegalStateException("For MulticastTransport you should provide IP from multicast network available/allowed in your environment, i.e.: 224.0.1.1");
        }
        super.init(voidConfiguration, clipboard, role, localIp, localPort, shardIndex);
        this.voidConfiguration = voidConfiguration;
        this.nodeRole = role;
        this.clipboard = clipboard;
        this.context = new Aeron.Context();
        this.driver = MediaDriver.launchEmbedded();
        this.context.aeronDirectoryName(this.driver.aeronDirectoryName());
        this.aeron = Aeron.connect((Aeron.Context)this.context);
        this.shardIndex = shardIndex;
        this.multicastChannelUri = "aeron:udp?endpoint=" + voidConfiguration.getMulticastNetwork() + ":" + voidConfiguration.getMulticastPort();
        if (voidConfiguration.getMulticastInterface() != null && !voidConfiguration.getMulticastInterface().isEmpty()) {
            this.multicastChannelUri = this.multicastChannelUri + "|interface=" + voidConfiguration.getMulticastInterface();
        }
        this.multicastChannelUri = this.multicastChannelUri + "|ttl=" + voidConfiguration.getTtl();
        if (voidConfiguration.getNumberOfShards() < 0) {
            voidConfiguration.setNumberOfShards(voidConfiguration.getShardAddresses().size());
        }
        switch (this.nodeRole) {
            case BACKUP: 
            case SHARD: {
                if (this.ip == null) {
                    this.ip = localIp;
                    this.port = voidConfiguration.getUnicastControllerPort();
                }
                this.unicastChannelUri = "aeron:udp?endpoint=" + this.ip + ":" + this.port;
                log.info("Shard unicast URI: {}/{}", (Object)this.unicastChannelUri, (Object)voidConfiguration.getStreamId());
                this.subscriptionForShards = this.aeron.addSubscription(this.unicastChannelUri, voidConfiguration.getStreamId());
                this.publicationForClients = this.aeron.addPublication(this.multicastChannelUri, voidConfiguration.getStreamId() + 1);
                this.publicationForShards = this.aeron.addPublication(this.multicastChannelUri, voidConfiguration.getStreamId() + 2);
                this.subscriptionForClients = this.aeron.addSubscription(this.multicastChannelUri, voidConfiguration.getStreamId() + 2);
                this.messageHandlerForShards = new FragmentAssembler((buffer, offset, length, header) -> this.shardMessageHandler(buffer, offset, length, header));
                this.messageHandlerForClients = new FragmentAssembler((buffer, offset, length, header) -> this.internalMessageHandler(buffer, offset, length, header));
                break;
            }
            case CLIENT: {
                this.ip = localIp;
                String rts = voidConfiguration.getShardAddresses().get(0);
                String[] split = rts.split(":");
                if (split.length == 1) {
                    this.ip = rts;
                    this.port = voidConfiguration.getUnicastControllerPort();
                } else {
                    this.ip = split[0];
                    this.port = Integer.valueOf(split[1]);
                }
                this.unicastChannelUri = "aeron:udp?endpoint=" + this.ip + ":" + this.port;
                log.info("Client unicast URI: {}/{}", (Object)this.unicastChannelUri, (Object)voidConfiguration.getStreamId());
                this.publicationForShards = this.aeron.addPublication(this.unicastChannelUri, voidConfiguration.getStreamId());
                this.subscriptionForClients = this.aeron.addSubscription(this.multicastChannelUri, voidConfiguration.getStreamId() + 1);
                this.messageHandlerForClients = new FragmentAssembler((buffer, offset, length, header) -> this.clientMessageHandler(buffer, offset, length, header));
                break;
            }
            default: {
                log.warn("Unknown role passed: {}", (Object)this.nodeRole);
                throw new RuntimeException();
            }
        }
        if (voidConfiguration.getNumberOfShards() == 1 && this.nodeRole == NodeRole.SHARD) {
            this.shutdownSilent();
        }
    }

    @Override
    protected synchronized void sendCoordinationCommand(VoidMessage message) {
        if (this.nodeRole == NodeRole.SHARD && this.voidConfiguration.getNumberOfShards() == 1) {
            message.setTargetId((short)-1);
            this.messages.add(message);
            return;
        }
        message.setTargetId((short)-1);
        this.publicationForShards.offer((DirectBuffer)message.asUnsafeBuffer());
    }

    @Override
    protected synchronized void sendFeedbackToClient(VoidMessage message) {
        if (this.nodeRole == NodeRole.SHARD && this.voidConfiguration.getNumberOfShards() == 1 && message instanceof MeaningfulMessage) {
            message.setTargetId((short)-1);
            this.completed.put(message.getTaskId(), (MeaningfulMessage)message);
            return;
        }
        message.setTargetId((short)-1);
        this.publicationForClients.offer((DirectBuffer)message.asUnsafeBuffer());
    }
}

