/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.parameterserver.distributed.v2.transport.impl;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.concurrent.locks.LockSupport;
import lombok.NonNull;
import org.apache.commons.lang3.RandomUtils;
import org.nd4j.linalg.util.SerializationUtils;
import org.nd4j.parameterserver.distributed.conf.VoidConfiguration;
import org.nd4j.parameterserver.distributed.v2.messages.VoidMessage;
import org.nd4j.parameterserver.distributed.v2.transport.impl.DummyTransport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DelayedDummyTransport
extends DummyTransport {
    private static final Logger log = LoggerFactory.getLogger(DelayedDummyTransport.class);

    public DelayedDummyTransport(@NonNull String id, @NonNull DummyTransport.Connector connector) {
        super(id, connector);
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (connector == null) {
            throw new NullPointerException("connector is marked @NonNull but is null");
        }
    }

    public DelayedDummyTransport(@NonNull String id, @NonNull DummyTransport.Connector connector, @NonNull String rootId) {
        super(id, connector, rootId);
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (connector == null) {
            throw new NullPointerException("connector is marked @NonNull but is null");
        }
        if (rootId == null) {
            throw new NullPointerException("rootId is marked @NonNull but is null");
        }
    }

    public DelayedDummyTransport(@NonNull String id, @NonNull DummyTransport.Connector connector, @NonNull String rootId, @NonNull VoidConfiguration configuration) {
        super(id, connector, rootId, configuration);
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        if (connector == null) {
            throw new NullPointerException("connector is marked @NonNull but is null");
        }
        if (rootId == null) {
            throw new NullPointerException("rootId is marked @NonNull but is null");
        }
        if (configuration == null) {
            throw new NullPointerException("configuration is marked @NonNull but is null");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendMessage(@NonNull VoidMessage message, final @NonNull String id) {
        if (message == null) {
            throw new NullPointerException("message is marked @NonNull but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked @NonNull but is null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DelayedDummyTransport delayedDummyTransport = this;
        synchronized (delayedDummyTransport) {
            SerializationUtils.serialize((Serializable)message, (OutputStream)bos);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        final VoidMessage msg = (VoidMessage)SerializationUtils.deserialize((InputStream)bis);
        if (msg.getOriginatorId() == null) {
            msg.setOriginatorId(this.id());
        }
        this.connector.executorService().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    int sleepTime = RandomUtils.nextInt((int)50, (int)200) * 1000;
                    LockSupport.parkNanos(sleepTime);
                    DelayedDummyTransport.super.sendMessage(msg, id);
                }
                catch (Exception e) {
                    log.error("Got exception: ", (Throwable)e);
                }
            }
        });
    }
}

