/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.net.pooling;

import java.util.Map;
import org.neo4j.driver.internal.SessionResourcesHandler;
import org.neo4j.driver.internal.net.BoltServerAddress;
import org.neo4j.driver.internal.spi.Collector;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.PooledConnection;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.internal.util.Consumer;
import org.neo4j.driver.v1.Value;
import org.neo4j.driver.v1.exceptions.Neo4jException;
import org.neo4j.driver.v1.summary.ServerInfo;

public class PooledSocketConnection
implements PooledConnection {
    private final Connection delegate;
    private final Consumer<PooledConnection> release;
    private boolean unrecoverableErrorsOccurred = false;
    private SessionResourcesHandler resourcesHandler;
    private final Clock clock;
    private long lastUsedTimestamp;

    public PooledSocketConnection(Connection delegate, Consumer<PooledConnection> release, Clock clock) {
        this.delegate = delegate;
        this.release = release;
        this.clock = clock;
        this.updateLastUsedTimestamp();
    }

    @Override
    public void init(String clientName, Map<String, Value> authToken) {
        try {
            this.delegate.init(clientName, authToken);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void run(String statement, Map<String, Value> parameters, Collector collector) {
        try {
            this.delegate.run(statement, parameters, collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void discardAll(Collector collector) {
        try {
            this.delegate.discardAll(collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void pullAll(Collector collector) {
        try {
            this.delegate.pullAll(collector);
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void reset() {
        try {
            this.delegate.reset();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void ackFailure() {
        try {
            this.delegate.ackFailure();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void sync() {
        try {
            this.delegate.sync();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void flush() {
        try {
            this.delegate.flush();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void receiveOne() {
        try {
            this.delegate.receiveOne();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public void close() {
        this.updateLastUsedTimestamp();
        this.resourcesHandler = null;
        this.release.accept(this);
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean hasUnrecoverableErrors() {
        return this.unrecoverableErrorsOccurred;
    }

    @Override
    public void resetAsync() {
        try {
            this.delegate.resetAsync();
        }
        catch (RuntimeException e) {
            this.onDelegateException(e);
        }
    }

    @Override
    public boolean isAckFailureMuted() {
        return this.delegate.isAckFailureMuted();
    }

    @Override
    public ServerInfo server() {
        return this.delegate.server();
    }

    @Override
    public BoltServerAddress boltServerAddress() {
        return this.delegate.boltServerAddress();
    }

    @Override
    public void dispose() {
        this.delegate.close();
    }

    private void onDelegateException(RuntimeException e) {
        if (!this.isClientOrTransientError(e) || this.isProtocolViolationError(e)) {
            this.unrecoverableErrorsOccurred = true;
        } else if (!this.isAckFailureMuted()) {
            this.ackFailure();
        }
        if (this.resourcesHandler != null) {
            this.resourcesHandler.onConnectionError(!this.unrecoverableErrorsOccurred);
        }
        throw e;
    }

    @Override
    public void setResourcesHandler(SessionResourcesHandler resourcesHandler) {
        this.resourcesHandler = resourcesHandler;
    }

    @Override
    public long lastUsedTimestamp() {
        return this.lastUsedTimestamp;
    }

    private boolean isProtocolViolationError(RuntimeException e) {
        String errorCode;
        if (e instanceof Neo4jException && (errorCode = ((Neo4jException)e).code()) != null) {
            return errorCode.startsWith("Neo.ClientError.Request");
        }
        return false;
    }

    private boolean isClientOrTransientError(RuntimeException e) {
        String errorCode;
        if (e instanceof Neo4jException && (errorCode = ((Neo4jException)e).code()) != null) {
            return errorCode.contains("ClientError") || errorCode.contains("TransientError");
        }
        return false;
    }

    private void updateLastUsedTimestamp() {
        this.lastUsedTimestamp = this.clock.millis();
    }
}

