/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.core.convert;

import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.noear.solon.core.convert.Converter;
import org.noear.solon.core.convert.ConverterFactory;
import org.noear.solon.core.util.GenericUtil;

public class ConverterManager {
    private Map<Type, Map<Type, Converter>> cLib = new HashMap<Type, Map<Type, Converter>>();
    private Map<Type, Map<Class<?>, ConverterFactory>> cfLib = new HashMap();

    public <S, T> void register(Converter<S, T> converter) {
        Map<String, Type> giMap = GenericUtil.getGenericInfo(converter.getClass());
        Type sType = null;
        Type tType = null;
        if (giMap != null) {
            sType = giMap.get("S");
            tType = giMap.get("T");
        }
        if (sType == null || sType == Object.class) {
            throw new IllegalArgumentException("Invalid converter source type: " + converter.getClass().getName());
        }
        if (tType == null || tType == Object.class) {
            throw new IllegalArgumentException("Invalid converter source type: " + converter.getClass().getName());
        }
        Map<Type, Converter> tmp = this.cLib.get(sType);
        if (tmp == null) {
            tmp = new HashMap<Type, Converter>();
            this.cLib.put(sType, tmp);
        }
        tmp.put(tType, converter);
    }

    public <S, R> void register(ConverterFactory<S, R> converterFactory) {
        Map<String, Type> giMap = GenericUtil.getGenericInfo(converterFactory.getClass());
        Type sType = null;
        Type rType = null;
        if (giMap != null) {
            sType = giMap.get("S");
            rType = giMap.get("R");
        }
        if (sType == null || sType == Object.class) {
            throw new IllegalArgumentException("Invalid converterFactory source type: " + converterFactory.getClass().getName());
        }
        if (rType == null || rType == Object.class || !(rType instanceof Class)) {
            throw new IllegalArgumentException("Invalid converterFactory result type: " + converterFactory.getClass().getName());
        }
        Map<Class<?>, ConverterFactory> tmp = this.cfLib.get(sType);
        if (tmp == null) {
            tmp = new HashMap();
            this.cfLib.put(sType, tmp);
        }
        tmp.put((Class)rType, converterFactory);
    }

    public <S, T> Converter<S, T> find(Class<S> sourceType, Class<T> tagertType) {
        Map<Type, Converter> cMap = this.cLib.get(sourceType);
        if (cMap == null) {
            return this.findInFactory(sourceType, tagertType);
        }
        Converter c = cMap.get(tagertType);
        if (c == null) {
            return this.findInFactory(sourceType, tagertType);
        }
        return c;
    }

    public <S, T> Converter<S, T> findInFactory(Class<S> sourceType, Class<T> tagertType) {
        Map<Class<?>, ConverterFactory> cfMap = this.cfLib.get(sourceType);
        if (cfMap == null) {
            return null;
        }
        for (Map.Entry<Class<?>, ConverterFactory> kv : cfMap.entrySet()) {
            if (!kv.getKey().isAssignableFrom(tagertType)) continue;
            return kv.getValue().getConverter(tagertType);
        }
        return null;
    }
}

