/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.xml;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantLock;
import org.noear.wood.WoodException;
import org.noear.wood.utils.IOUtils;
import org.noear.wood.utils.ThrowableUtils;
import org.noear.wood.xml.CompilerUtil;
import org.noear.wood.xml.XmlFileScaner;
import org.noear.wood.xml.XmlSqlCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlSqlLoader {
    static final Logger log = LoggerFactory.getLogger(XmlSqlLoader.class);
    public static XmlSqlLoader _g = new XmlSqlLoader();
    private static final ReentrantLock SYNC_LOCK = new ReentrantLock();
    private boolean is_loaed = false;
    private List<URL> xmlFiles = new ArrayList<URL>();

    public static void load() throws Exception {
        if (!XmlSqlLoader._g.is_loaed) {
            SYNC_LOCK.lock();
            try {
                if (!XmlSqlLoader._g.is_loaed) {
                    XmlSqlLoader._g.is_loaed = true;
                    _g.load0();
                }
            }
            finally {
                SYNC_LOCK.unlock();
            }
        }
    }

    public static void tryLoad() {
        try {
            XmlSqlLoader.load();
        }
        catch (Throwable ex) {
            ex = ThrowableUtils.throwableUnwrap((Throwable)ex);
            if (ex instanceof RuntimeException) {
                throw (RuntimeException)ex;
            }
            throw new RuntimeException(ex);
        }
    }

    private void load0() throws Exception {
        XmlFileScaner.scan("wood/", ".xml").stream().map(k -> IOUtils.getResource((String)k)).filter(url -> url != null).forEach(url -> XmlSqlLoader._g.xmlFiles.add((URL)url));
        if (XmlSqlLoader._g.xmlFiles.size() == 0) {
            return;
        }
        ArrayList<String> codes = new ArrayList<String>();
        for (URL file : XmlSqlLoader._g.xmlFiles) {
            log.debug("[Wood] Xml Compiler: " + file);
            String code = XmlSqlCompiler.parse(file);
            if (code == null) continue;
            codes.add(code);
        }
        if (codes.size() == 0) {
            return;
        }
        boolean is_ok = CompilerUtil.instance().compiler(codes);
        if (!is_ok) {
            String error = CompilerUtil.instance().getCompilerMessage();
            throw new WoodException("Xml sql compiler error: \r\n" + error);
        }
        CompilerUtil.instance().loadClassAll(true);
    }

    private XmlSqlLoader() {
    }
}

