/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.sql.Statement;
import java.util.LinkedHashSet;
import java.util.Set;
import org.noear.wood.Command;
import org.noear.wood.VarHolder;
import org.noear.wood.ext.Act1;
import org.noear.wood.ext.Act2;
import org.noear.wood.ext.Fun1;

public class DbEventBus {
    private Set<Act2<Command, Throwable>> onException_listener = new LinkedHashSet<Act2<Command, Throwable>>();
    private Set<Act1<Command>> onLog_listener = new LinkedHashSet<Act1<Command>>();
    private Set<Act1<Command>> onCommandBuilt_listener = new LinkedHashSet<Act1<Command>>();
    private Set<Fun1<Boolean, Command>> onExecuteBef_listener = new LinkedHashSet<Fun1<Boolean, Command>>();
    private Set<Act2<Command, Statement>> onExecuteStm_listener = new LinkedHashSet<Act2<Command, Statement>>();
    private Set<Act1<Command>> onExecuteAft_listener = new LinkedHashSet<Act1<Command>>();

    protected static boolean isEmpty(CharSequence s) {
        if (s == null) {
            return true;
        }
        return s.length() == 0;
    }

    protected void runExceptionEvent(Command cmd, Throwable ex) {
        if (this.onException_listener.size() > 0) {
            if (cmd != null && cmd.timestop == 0L) {
                cmd.timestop = System.currentTimeMillis();
            }
            this.onException_listener.forEach(fun -> fun.run(cmd, ex));
        }
    }

    protected void runCommandBuiltEvent(Command cmd) {
        if (this.onCommandBuilt_listener.size() > 0) {
            this.onCommandBuilt_listener.forEach(fun -> fun.run(cmd));
        }
    }

    protected boolean runExecuteBefEvent(Command cmd) {
        cmd.timestart = System.currentTimeMillis();
        VarHolder rst = new VarHolder();
        rst.value = true;
        if (this.onExecuteBef_listener.size() > 0) {
            this.onExecuteBef_listener.forEach(fun -> {
                rst.value = (Boolean)rst.value != false && (Boolean)fun.run(cmd) != false;
            });
        }
        return (Boolean)rst.value;
    }

    protected void runExecuteStmEvent(Command cmd, Statement stm) {
        if (this.onExecuteStm_listener.size() > 0) {
            this.onExecuteStm_listener.forEach(fun -> fun.run(cmd, stm));
        }
    }

    protected void runExecuteAftEvent(Command cmd) {
        try {
            if (cmd.onExecuteAft != null) {
                cmd.onExecuteAft.run(cmd);
                cmd.onExecuteAft = null;
            }
            cmd.timestop = System.currentTimeMillis();
            if (this.onExecuteAft_listener.size() > 0) {
                this.onExecuteAft_listener.forEach(fun -> fun.run(cmd));
            }
            if (cmd.isLog > 0 && this.onLog_listener.size() > 0) {
                this.onLog_listener.forEach(fun -> fun.run(cmd));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void onException(Act2<Command, Throwable> listener) {
        this.onException_listener.add(listener);
    }

    public void onLog(Act1<Command> listener) {
        this.onLog_listener.add(listener);
    }

    public void onCommandBuilt(Act1<Command> listener) {
        this.onCommandBuilt_listener.add(listener);
    }

    public void onExecuteBef(Fun1<Boolean, Command> listener) {
        this.onExecuteBef_listener.add(listener);
    }

    public void onExecuteStm(Act2<Command, Statement> listener) {
        this.onExecuteStm_listener.add(listener);
    }

    public void onExecuteAft(Act1<Command> listener) {
        this.onExecuteAft_listener.add(listener);
    }
}

