/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.wrap;

import java.util.HashMap;
import java.util.Map;
import org.noear.wood.wrap.ColumnWrap;
import org.noear.wood.wrap.SqlTypeDesc;

public class SqlTypeUtil {
    public static Map<Integer, SqlTypeDesc> mapping = new HashMap<Integer, SqlTypeDesc>();
    public static final String NUMERIC = "NUMERIC";

    private static void put(Integer sqlType, String javaType, String javaType2) {
        mapping.put(sqlType, new SqlTypeDesc(sqlType, javaType, javaType2));
    }

    public static SqlTypeDesc getTypeDesc(ColumnWrap cw) {
        return SqlTypeUtil.getTypeDo(cw.getSqlType(), cw.getSize(), cw.getDigit());
    }

    public static String getJavaType(ColumnWrap cw, boolean style2) {
        SqlTypeDesc type = SqlTypeUtil.getTypeDesc(cw);
        if (type == null) {
            return "Unknown";
        }
        if (style2) {
            return type.javaType2;
        }
        return type.javaType;
    }

    private static SqlTypeDesc getTypeDo(Integer sqlType, Integer size, Integer digit) {
        SqlTypeDesc type = mapping.get(sqlType);
        if (type != null && type.javaType.equals(NUMERIC)) {
            type = digit != null && digit != 0 ? mapping.get(8) : (size >= 9 ? mapping.get(-5) : mapping.get(4));
        }
        return type;
    }

    static {
        SqlTypeUtil.put(-5, "Long", "long");
        SqlTypeUtil.put(-2, "byte[]", "byte[]");
        SqlTypeUtil.put(-7, "Boolean", "boolean");
        SqlTypeUtil.put(2004, "byte[]", "byte[]");
        SqlTypeUtil.put(16, "Boolean", "boolean");
        SqlTypeUtil.put(1, "String", "String");
        SqlTypeUtil.put(2005, "String", "String");
        SqlTypeUtil.put(91, "Date", "Date");
        SqlTypeUtil.put(3, "BigDecimal", "BigDecimal");
        SqlTypeUtil.put(8, "Double", "double");
        SqlTypeUtil.put(6, "Float", "float");
        SqlTypeUtil.put(4, "Integer", "int");
        SqlTypeUtil.put(2000, "Object", "Object");
        SqlTypeUtil.put(-16, "String", "String");
        SqlTypeUtil.put(-4, "byte[]", "byte[]");
        SqlTypeUtil.put(-1, "String", "String");
        SqlTypeUtil.put(-15, "String", "String");
        SqlTypeUtil.put(-9, "String", "String");
        SqlTypeUtil.put(2011, "String", "String");
        SqlTypeUtil.put(2, NUMERIC, NUMERIC);
        SqlTypeUtil.put(1111, "Object", "Object");
        SqlTypeUtil.put(7, "Float", "float");
        SqlTypeUtil.put(5, "Integer", "int");
        SqlTypeUtil.put(2009, "SQLXML", "SQLXML");
        SqlTypeUtil.put(92, "Date", "Date");
        SqlTypeUtil.put(93, "Date", "Date");
        SqlTypeUtil.put(-6, "Integer", "int");
        SqlTypeUtil.put(-3, "byte[]", "byte[]");
        SqlTypeUtil.put(12, "String", "String");
        SqlTypeUtil.put(2014, "Date", "Date");
        SqlTypeUtil.put(2013, "Date", "Date");
    }
}

