/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood.wrap;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.wood.DbContextMetaData;
import org.noear.wood.wrap.ColumnWrap;

public class TableWrap {
    private final DbContextMetaData meta;
    private final String name;
    private final String remarks;
    private String pk1;
    private List<String> pks = null;
    private Map<String, ColumnWrap> columns = null;
    private ColumnWrap columnFirst = null;

    public TableWrap(DbContextMetaData meta, String name, String remarks) {
        this.meta = meta;
        this.name = name;
        this.remarks = remarks;
    }

    public TableWrap refresh() {
        this.tryInit(true);
        return this;
    }

    private void tryInit(boolean refresh) {
        if (this.columns != null && !refresh) {
            return;
        }
        this.meta.SYNC_LOCK.lock();
        try {
            if (this.columns != null && !refresh) {
                return;
            }
            this.columns = new LinkedHashMap<String, ColumnWrap>();
            this.pks = new ArrayList<String>();
            try (ResultSet rs = this.meta.getReal().getColumns(this.meta.getCatalog(), this.meta.getSchema(), this.getName(), "%");){
                while (rs.next()) {
                    int digit = 0;
                    Object o = rs.getObject("DECIMAL_DIGITS");
                    if (o != null) {
                        digit = ((Number)o).intValue();
                    }
                    ColumnWrap cw = new ColumnWrap(rs.getString("TABLE_NAME"), rs.getString("COLUMN_NAME"), rs.getInt("DATA_TYPE"), rs.getInt("COLUMN_SIZE"), digit, rs.getString("IS_NULLABLE"), rs.getString("REMARKS"));
                    this.addColumn(cw);
                }
            }
            rs = this.meta.getReal().getPrimaryKeys(this.meta.getCatalog(), this.meta.getSchema(), this.getName());
            var3_4 = null;
            try {
                while (rs.next()) {
                    String idName = rs.getString("COLUMN_NAME");
                    this.addPk(idName);
                }
            }
            catch (Throwable throwable) {
                var3_4 = throwable;
                throw throwable;
            }
            finally {
                if (rs != null) {
                    if (var3_4 != null) {
                        try {
                            rs.close();
                        }
                        catch (Throwable throwable) {
                            var3_4.addSuppressed(throwable);
                        }
                    } else {
                        rs.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            throw new IllegalStateException(ex);
        }
        finally {
            this.meta.SYNC_LOCK.unlock();
        }
    }

    private void addPk(String name) {
        if (this.pk1 == null) {
            this.pk1 = name;
        }
        this.pks.add(name);
    }

    private void addColumn(ColumnWrap col) {
        if (this.columnFirst == null) {
            this.columnFirst = col;
        }
        this.columns.put(col.getName(), col);
    }

    public String getName() {
        return this.name;
    }

    public String getRemarks() {
        return this.remarks;
    }

    public List<String> getPks() {
        this.tryInit(false);
        return this.pks;
    }

    public String getPk1() {
        this.tryInit(false);
        if (this.pk1 != null) {
            return this.pk1;
        }
        if (this.columns.size() > 0) {
            return this.columnFirst.getName();
        }
        return null;
    }

    public Collection<ColumnWrap> getColumns() {
        this.tryInit(false);
        return this.columns.values();
    }

    public ColumnWrap getColumn(String name) {
        this.tryInit(false);
        return this.columns.get(name);
    }

    public boolean hasColumn(String name) {
        this.tryInit(false);
        return this.columns.containsKey(name);
    }
}

