/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.noear.wood.DbContext;
import org.noear.wood.DbTran;
import org.noear.wood.DbTranUtil;
import org.noear.wood.cache.ICacheServiceEx;
import org.noear.wood.ext.Act1;

public class Command {
    public String tag;
    public int isLog;
    public String key;
    public String text;
    public List<Object> paramS;
    public DbContext context;
    public ICacheServiceEx cache;
    public Map<String, Object> attachment;
    public DbTran tran;
    public boolean isBatch = false;
    public long timestart = 0L;
    public long timestop = 0L;
    public long[] affectRow;
    private Map<String, Object> _paramMap;
    public Act1<Command> onExecuteAft = null;

    public Command(DbContext context) {
        this.context = context;
        this.context.lastCommand = this;
        this.tran = DbTranUtil.current();
    }

    public Map<String, Object> paramMap() {
        if (this._paramMap == null) {
            this._paramMap = new LinkedHashMap<String, Object>();
            int idx = 0;
            for (Object v : this.paramS) {
                this._paramMap.put("v" + idx, v);
                ++idx;
            }
        }
        return this._paramMap;
    }

    public String toSqlString() {
        StringBuilder sb = new StringBuilder();
        if (this.isBatch) {
            sb.append(this.text);
            sb.append(" --:batch");
        } else {
            String[] ss = this.text.split("\\?");
            int len = ss.length;
            int len2 = this.paramS.size();
            for (int i = 0; i < len; ++i) {
                sb.append(ss[i]);
                if (i >= len2) continue;
                Object val = this.paramS.get(i);
                if (val == null) {
                    sb.append("NULL");
                    continue;
                }
                if (val instanceof String) {
                    sb.append("'").append(val).append("'");
                    continue;
                }
                if (val instanceof Boolean) {
                    sb.append(val);
                    continue;
                }
                if (val instanceof Date) {
                    sb.append("'").append(val).append("'");
                    continue;
                }
                sb.append(val);
            }
        }
        return sb.toString();
    }

    public long timespan() {
        return this.timestop - this.timestart;
    }

    public String fullText() {
        if (this.context.codeHint() == null) {
            return this.context.getDialect().preReview(this.text);
        }
        return this.context.codeHint() + this.context.getDialect().preReview(this.text);
    }
}

