/*
 * Decompiled with CFR 0.152.
 */
package org.noear.wood;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.noear.wood.BaseMapper;
import org.noear.wood.Command;
import org.noear.wood.DbContextMetaData;
import org.noear.wood.DbDataSource;
import org.noear.wood.DbEventBus;
import org.noear.wood.DbProcedure;
import org.noear.wood.DbQuery;
import org.noear.wood.DbQueryProcedure;
import org.noear.wood.DbStoredProcedure;
import org.noear.wood.DbTableQuery;
import org.noear.wood.SQLBuilder;
import org.noear.wood.WoodConfig;
import org.noear.wood.dialect.DbDialect;
import org.noear.wood.ext.Act1;
import org.noear.wood.utils.StringUtils;
import org.noear.wood.wrap.DbFormater;
import org.noear.wood.wrap.DbType;

public class DbContext
extends DbEventBus
implements Closeable {
    @Deprecated
    public Command lastCommand;
    private boolean allowMultiQueries;
    private boolean compilationMode = false;
    private final DbContextMetaData metaData = new DbContextMetaData();
    protected DbFormater _formater = new DbFormater(this);
    protected Map<String, String> _attrMap = new HashMap<String, String>();
    protected String _codeHint = null;
    protected String _name;
    private Map<Class<?>, Object> _mapperMap = new HashMap();

    public boolean isAllowMultiQueries() {
        return this.allowMultiQueries;
    }

    public void setAllowMultiQueries(boolean allowMultiQueries) {
        this.allowMultiQueries = allowMultiQueries;
    }

    public boolean isCompilationMode() {
        return this.compilationMode;
    }

    public void setCompilationMode(boolean compilationMode) {
        this.compilationMode = compilationMode;
    }

    public DbContextMetaData getMetaData() {
        return this.metaData;
    }

    public void initMetaData() {
        this.getMetaData().init();
    }

    public boolean initMetaData2() {
        return this.getMetaData().init();
    }

    public DbType getType() {
        return this.getMetaData().getType();
    }

    public DbDialect getDialect() {
        return this.getMetaData().getDialect();
    }

    public void setDialect(DbType dbType, DbDialect dbDialect) {
        this.getMetaData().setDialect(dbDialect);
        this.getMetaData().setType(dbType);
    }

    public Connection getConnection() throws SQLException {
        return this.getMetaData().getConnection();
    }

    public String name() {
        return this._name;
    }

    public DbContext nameSet(String name) {
        this._name = name;
        WoodConfig.libOfDb.put(name, this);
        return this;
    }

    public static DbContext use(String name) {
        return WoodConfig.libOfDb.get(name);
    }

    public DbContext attrSet(String name, String value) {
        this._attrMap.put(name, value);
        return this;
    }

    public String attr(String name) {
        return this._attrMap.get(name);
    }

    public DbContext driverSet(String driverClassName) {
        try {
            Class.forName(driverClassName);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this;
    }

    public DbContext schemaSet(String schema) {
        if (StringUtils.isNotEmpty(schema)) {
            this.getMetaData().setSchema(schema);
            if (this._name == null) {
                this._name = schema;
            }
        }
        return this;
    }

    public DbContext codeHintSet(String hint) {
        this._codeHint = hint;
        return this;
    }

    public String codeHint() {
        return this._codeHint;
    }

    public String schema() {
        return this.getMetaData().getSchema();
    }

    public DbContext formaterSet(DbFormater formater) {
        this._formater = formater;
        return this;
    }

    public DbFormater formater() {
        return this._formater;
    }

    public DbContext(DataSource dataSource) {
        this(dataSource, null);
    }

    public DbContext(DataSource dataSource, String schema) {
        this.schemaSet(schema);
        this.getMetaData().setDataSource(dataSource);
    }

    public DbContext(Properties prop) {
        String schema = prop.getProperty("schema");
        String url = prop.getProperty("url");
        String username = prop.getProperty("username");
        String password = prop.getProperty("password");
        String driverClassName = prop.getProperty("driverClassName");
        if (StringUtils.isEmpty(url) || !url.startsWith("jdbc:")) {
            throw new IllegalArgumentException("DataSource url configuration error");
        }
        if (StringUtils.isNotEmpty(driverClassName)) {
            this.driverSet(driverClassName);
        }
        if (StringUtils.isNotEmpty(schema)) {
            this.getMetaData().setSchema(schema);
        }
        if (StringUtils.isEmpty(this.getMetaData().getSchema()) && url.indexOf("://") > 0) {
            this.getMetaData().setSchema(URI.create(url.substring(5)).getPath().substring(1));
        }
        if (StringUtils.isEmpty(username)) {
            this.getMetaData().setDataSource(new DbDataSource(url));
        } else {
            this.getMetaData().setDataSource(new DbDataSource(url, username, password));
        }
    }

    public DbContext(String schema, String url) {
        this.schemaSet(schema);
        this.getMetaData().setDataSource(new DbDataSource(url));
    }

    public DbContext(String schema, String url, String username, String password) {
        this.schemaSet(schema);
        this.getMetaData().setDataSource(new DbDataSource(url, username, password));
    }

    public DbContext(String schema, DataSource dataSource) {
        this.schemaSet(schema);
        this.getMetaData().setDataSource(dataSource);
    }

    public <T> BaseMapper<T> mapperBase(Class<T> clz) {
        return WoodConfig.mapperAdaptor.createMapperBase(this, clz, null);
    }

    public <T> BaseMapper<T> mapperBase(Class<T> clz, String tableName) {
        return WoodConfig.mapperAdaptor.createMapperBase(this, clz, tableName);
    }

    public <T> T mapper(Class<T> clz) {
        Object tmp = this._mapperMap.get(clz);
        if (tmp == null) {
            this.metaData.SYNC_LOCK.tryLock();
            try {
                tmp = this._mapperMap.get(clz);
                if (tmp == null) {
                    tmp = WoodConfig.mapperAdaptor.createMapper(this, clz);
                    this._mapperMap.put(clz, tmp);
                }
            }
            finally {
                this.metaData.SYNC_LOCK.unlock();
            }
        }
        return (T)tmp;
    }

    public <T> T mapper(String xsqlid, Map<String, Object> args) throws Exception {
        return WoodConfig.mapperAdaptor.createMapper(this, xsqlid, args);
    }

    public <T> BaseMapper<T> table(Class<T> clz) {
        return WoodConfig.mapperAdaptor.createMapperBase(this, clz, null);
    }

    public <T> BaseMapper<T> table(Class<T> clz, String tableName) {
        return WoodConfig.mapperAdaptor.createMapperBase(this, clz, tableName);
    }

    public DbTableQuery table(String table) {
        return (DbTableQuery)new DbTableQuery(this).table(table);
    }

    public DbProcedure call(String process) {
        if (process.startsWith("@")) {
            return WoodConfig.mapperAdaptor.createXmlProcedure(this, process, null);
        }
        if (process.lastIndexOf(" ") > 0) {
            return new DbQueryProcedure(this).sql(process);
        }
        return new DbStoredProcedure(this).call(process);
    }

    public DbProcedure call(String process, Map<String, Object> args) {
        if (process.startsWith("@")) {
            return WoodConfig.mapperAdaptor.createXmlProcedure(this, process, args);
        }
        if (process.lastIndexOf(" ") > 0) {
            return new DbQueryProcedure(this).sql(process).setMap(args);
        }
        return new DbStoredProcedure(this).call(process).setMap(args);
    }

    public DbQuery sql(String code, Object ... args) {
        return this.sql(new SQLBuilder().append(code, args));
    }

    public DbQuery sql(Act1<SQLBuilder> buildRuner) {
        SQLBuilder sql = new SQLBuilder();
        buildRuner.run(sql);
        return this.sql(sql);
    }

    public DbQuery sql(SQLBuilder sqlBuilder) {
        return new DbQuery(this).sql(sqlBuilder);
    }

    public Object exe(String code, Object ... args) throws Exception {
        String codeUp;
        String cmd = "val";
        String[] ss = code.split("::");
        if (ss.length > 1) {
            cmd = ss[0];
            code = ss[1];
        }
        if ((codeUp = code.trim().substring(0, 10).toUpperCase()).startsWith("SELECT ")) {
            switch (cmd) {
                case "obj": 
                case "map": {
                    return this.sql(code, args).getMap();
                }
                case "ary": 
                case "list": {
                    return this.sql(code, args).getMapList();
                }
            }
            return this.sql(code, args).getValue();
        }
        return this.sql(code, args).execute();
    }

    public int[] exeBatch(String code, List<Object[]> args) throws Exception {
        SQLBuilder sql = new SQLBuilder();
        sql.append(code, args.toArray());
        return this.sql(sql).executeBatch();
    }

    @Override
    public void close() throws IOException {
        if (this.metaData != null) {
            this.metaData.close();
            this._mapperMap.clear();
        }
    }

    @Override
    protected void runExceptionEvent(Command cmd, Throwable ex) {
        super.runExceptionEvent(cmd, ex);
        WoodConfig.runExceptionEvent(cmd, ex);
    }

    @Override
    protected void runCommandBuiltEvent(Command cmd) {
        super.runCommandBuiltEvent(cmd);
        WoodConfig.runCommandBuiltEvent(cmd);
    }

    @Override
    protected boolean runExecuteBefEvent(Command cmd) {
        boolean isOk = super.runExecuteBefEvent(cmd);
        return isOk && WoodConfig.runExecuteBefEvent(cmd);
    }

    @Override
    protected void runExecuteStmEvent(Command cmd, Statement stm) {
        super.runExecuteStmEvent(cmd, stm);
        WoodConfig.runExecuteStmEvent(cmd, stm);
    }

    @Override
    protected void runExecuteAftEvent(Command cmd) {
        super.runExecuteAftEvent(cmd);
        WoodConfig.runExecuteAftEvent(cmd);
    }
}

