/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.jedis;

import org.nutz.integration.jedis.JedisClusterWrapper;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.impl.PropertiesProxy;
import org.nutz.mvc.Mvcs;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.util.Pool;

public class JedisAgent {
    protected Ioc ioc;
    protected PropertiesProxy conf;
    protected Pool<Jedis> jedisPool;
    protected JedisClusterWrapper jedisClusterWrapper;

    public JedisAgent() {
    }

    public JedisAgent(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
        this.conf = new PropertiesProxy();
    }

    public JedisAgent(JedisCluster jedisCluster) {
        this.jedisClusterWrapper = new JedisClusterWrapper(jedisCluster);
        this.conf = new PropertiesProxy().set("redis.mode", "cluster");
    }

    public Jedis jedis() {
        if (this.jedisPool == null && this.jedisClusterWrapper == null && this.ioc == null && this.conf == null) {
            this.ioc();
        }
        if (!"cluster".equals(this.conf.get("redis.mode"))) {
            return (Jedis)this.getJedisPool().getResource();
        }
        return this.getJedisClusterWrapper();
    }

    public Jedis getResource() {
        return this.jedis();
    }

    public Pool<Jedis> getJedisPool() {
        if (this.jedisPool == null) {
            this.jedisPool = (Pool)this.ioc().get(Pool.class, "jedisPool");
        }
        return this.jedisPool;
    }

    public JedisClusterWrapper getJedisClusterWrapper() {
        if (this.jedisClusterWrapper == null) {
            this.jedisClusterWrapper = (JedisClusterWrapper)((Object)this.ioc().get(JedisClusterWrapper.class));
        }
        return this.jedisClusterWrapper;
    }

    public void setJedisPool(Pool<Jedis> jedisPool) {
        this.jedisPool = jedisPool;
    }

    public void setJedisClusterWrapper(JedisClusterWrapper jedisClusterWrapper) {
        this.jedisClusterWrapper = jedisClusterWrapper;
    }

    public void setConf(PropertiesProxy conf) {
        this.conf = conf;
    }

    public void setIoc(Ioc ioc) {
        this.ioc = ioc;
    }

    public synchronized Ioc ioc() {
        if (this.ioc == null) {
            this.ioc = Mvcs.ctx().getDefaultIoc();
        }
        if (this.ioc != null && this.conf == null) {
            this.conf = (PropertiesProxy)this.ioc.get(PropertiesProxy.class, "conf");
        }
        return this.ioc;
    }

    public boolean isReady() {
        try {
            if (this.jedisPool != null || this.jedisClusterWrapper != null) {
                return true;
            }
            if (this.ioc() != null) {
                return true;
            }
            return Mvcs.ctx().getDefaultIoc() != null;
        }
        catch (Throwable e) {
            return false;
        }
    }
}

