/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.integration.jedis;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nutz.lang.Lang;
import redis.clients.jedis.BinaryClient;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.BitOP;
import redis.clients.jedis.BitPosParams;
import redis.clients.jedis.Client;
import redis.clients.jedis.DebugParams;
import redis.clients.jedis.GeoCoordinate;
import redis.clients.jedis.GeoRadiusResponse;
import redis.clients.jedis.GeoUnit;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisMonitor;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPubSub;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBlock;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;
import redis.clients.jedis.SortingParams;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.TransactionBlock;
import redis.clients.jedis.Tuple;
import redis.clients.jedis.ZParams;
import redis.clients.jedis.params.geo.GeoRadiusParam;
import redis.clients.jedis.params.sortedset.ZAddParams;
import redis.clients.jedis.params.sortedset.ZIncrByParams;
import redis.clients.util.Pool;
import redis.clients.util.Slowlog;

public class JedisClusterWrapper
extends Jedis {
    protected JedisCluster jedisCluster;

    public JedisClusterWrapper() {
    }

    public JedisClusterWrapper(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public void setJedisCluster(JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
    }

    public JedisCluster getJedisCluster() {
        return this.jedisCluster;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Set<String> keys(String pattern) {
        HashSet<String> keys = new HashSet<String>();
        for (JedisPool pool : this.jedisCluster.getClusterNodes().values()) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                keys.addAll(jedis.keys(pattern));
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public Set<byte[]> keys(byte[] pattern) {
        HashSet<byte[]> keys = new HashSet<byte[]>();
        for (JedisPool pool : this.jedisCluster.getClusterNodes().values()) {
            Jedis jedis = null;
            try {
                jedis = pool.getResource();
                keys.addAll(jedis.keys(pattern));
            }
            finally {
                if (jedis == null) continue;
                jedis.close();
            }
        }
        return keys;
    }

    public String set(String key, String value) {
        return this.jedisCluster.set(key, value);
    }

    public String set(String key, String value, String nxxx, String expx, long time) {
        return this.jedisCluster.set(key, value, nxxx, expx, time);
    }

    public String get(String key) {
        return this.jedisCluster.get(key);
    }

    public Long exists(String ... keys) {
        return this.jedisCluster.exists(keys);
    }

    public String set(byte[] key, byte[] value) {
        return this.jedisCluster.set(key, value);
    }

    public boolean equals(Object obj) {
        return this.jedisCluster.equals(obj);
    }

    public Boolean exists(String key) {
        return this.jedisCluster.exists(key);
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, long time) {
        return this.jedisCluster.set(key, value, nxxx, expx, time);
    }

    public Long del(String ... keys) {
        return this.jedisCluster.del(keys);
    }

    public Long del(String key) {
        return this.jedisCluster.del(key);
    }

    public byte[] get(byte[] key) {
        return this.jedisCluster.get(key);
    }

    public String type(String key) {
        return this.jedisCluster.type(key);
    }

    public String quit() {
        return this.jedisCluster.quit();
    }

    public Long exists(byte[] ... keys) {
        return this.jedisCluster.exists(keys);
    }

    public Boolean exists(byte[] key) {
        return this.jedisCluster.exists(key);
    }

    public Long del(byte[] ... keys) {
        return this.jedisCluster.del(keys);
    }

    public Long del(byte[] key) {
        return this.jedisCluster.del(key);
    }

    public String type(byte[] key) {
        return this.jedisCluster.type(key);
    }

    public String rename(String oldkey, String newkey) {
        return this.jedisCluster.rename(oldkey, newkey);
    }

    public String flushDB() {
        return this.jedisCluster.flushDB();
    }

    public Long renamenx(String oldkey, String newkey) {
        return this.jedisCluster.renamenx(oldkey, newkey);
    }

    public Long expire(String key, int seconds) {
        return this.jedisCluster.expire(key, seconds);
    }

    public String rename(byte[] oldkey, byte[] newkey) {
        return this.jedisCluster.rename(oldkey, newkey);
    }

    public Long expireAt(String key, long unixTime) {
        return this.jedisCluster.expireAt(key, unixTime);
    }

    public Long renamenx(byte[] oldkey, byte[] newkey) {
        return this.jedisCluster.renamenx(oldkey, newkey);
    }

    public Long dbSize() {
        return this.jedisCluster.dbSize();
    }

    public Long expire(byte[] key, int seconds) {
        return this.jedisCluster.expire(key, seconds);
    }

    public Long ttl(String key) {
        return this.jedisCluster.ttl(key);
    }

    public Long move(String key, int dbIndex) {
        return this.jedisCluster.move(key, dbIndex);
    }

    public String getSet(String key, String value) {
        return this.jedisCluster.getSet(key, value);
    }

    public List<String> mget(String ... keys) {
        return this.jedisCluster.mget(keys);
    }

    public Long setnx(String key, String value) {
        return this.jedisCluster.setnx(key, value);
    }

    public Long expireAt(byte[] key, long unixTime) {
        return this.jedisCluster.expireAt(key, unixTime);
    }

    public String setex(String key, int seconds, String value) {
        return this.jedisCluster.setex(key, seconds, value);
    }

    public String mset(String ... keysvalues) {
        return this.jedisCluster.mset(keysvalues);
    }

    public Long ttl(byte[] key) {
        return this.jedisCluster.ttl(key);
    }

    public Long msetnx(String ... keysvalues) {
        return this.jedisCluster.msetnx(keysvalues);
    }

    public Long decrBy(String key, long integer) {
        return this.jedisCluster.decrBy(key, integer);
    }

    public String flushAll() {
        return this.jedisCluster.flushAll();
    }

    public byte[] getSet(byte[] key, byte[] value) {
        return this.jedisCluster.getSet(key, value);
    }

    public Long decr(String key) {
        return this.jedisCluster.decr(key);
    }

    public List<byte[]> mget(byte[] ... keys) {
        return this.jedisCluster.mget(keys);
    }

    public Long incrBy(String key, long integer) {
        return this.jedisCluster.incrBy(key, integer);
    }

    public Long setnx(byte[] key, byte[] value) {
        return this.jedisCluster.setnx(key, value);
    }

    public String setex(byte[] key, int seconds, byte[] value) {
        return this.jedisCluster.setex(key, seconds, value);
    }

    public Double incrByFloat(String key, double value) {
        return this.jedisCluster.incrByFloat(key, value);
    }

    public String mset(byte[] ... keysvalues) {
        return this.jedisCluster.mset(keysvalues);
    }

    public Long incr(String key) {
        return this.jedisCluster.incr(key);
    }

    public Long msetnx(byte[] ... keysvalues) {
        return this.jedisCluster.msetnx(keysvalues);
    }

    public Long append(String key, String value) {
        return this.jedisCluster.append(key, value);
    }

    public Long decrBy(byte[] key, long integer) {
        return this.jedisCluster.decrBy(key, integer);
    }

    public String substr(String key, int start, int end) {
        return this.jedisCluster.substr(key, start, end);
    }

    public Long decr(byte[] key) {
        return this.jedisCluster.decr(key);
    }

    public Long hset(String key, String field, String value) {
        return this.jedisCluster.hset(key, field, value);
    }

    public Long incrBy(byte[] key, long integer) {
        return this.jedisCluster.incrBy(key, integer);
    }

    public String hget(String key, String field) {
        return this.jedisCluster.hget(key, field);
    }

    public Long hsetnx(String key, String field, String value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    public Double incrByFloat(byte[] key, double integer) {
        return this.jedisCluster.incrByFloat(key, integer);
    }

    public String hmset(String key, Map<String, String> hash) {
        return this.jedisCluster.hmset(key, hash);
    }

    public List<String> hmget(String key, String ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    public Long incr(byte[] key) {
        return this.jedisCluster.incr(key);
    }

    public Long hincrBy(String key, String field, long value) {
        return this.jedisCluster.hincrBy(key, field, value);
    }

    public Long append(byte[] key, byte[] value) {
        return this.jedisCluster.append(key, value);
    }

    public Double hincrByFloat(String key, String field, double value) {
        return this.jedisCluster.hincrByFloat(key, field, value);
    }

    public byte[] substr(byte[] key, int start, int end) {
        return this.jedisCluster.substr(key, start, end);
    }

    public Boolean hexists(String key, String field) {
        return this.jedisCluster.hexists(key, field);
    }

    public Long hdel(String key, String ... fields) {
        return this.jedisCluster.hdel(key, fields);
    }

    public Long hset(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hset(key, field, value);
    }

    public Long hlen(String key) {
        return this.jedisCluster.hlen(key);
    }

    public byte[] hget(byte[] key, byte[] field) {
        return this.jedisCluster.hget(key, field);
    }

    public Set<String> hkeys(String key) {
        return this.jedisCluster.hkeys(key);
    }

    public Long hsetnx(byte[] key, byte[] field, byte[] value) {
        return this.jedisCluster.hsetnx(key, field, value);
    }

    public List<String> hvals(String key) {
        return this.jedisCluster.hvals(key);
    }

    public String hmset(byte[] key, Map<byte[], byte[]> hash) {
        return this.jedisCluster.hmset(key, hash);
    }

    public Map<String, String> hgetAll(String key) {
        return this.jedisCluster.hgetAll(key);
    }

    public Long rpush(String key, String ... strings) {
        return this.jedisCluster.rpush(key, strings);
    }

    public List<byte[]> hmget(byte[] key, byte[] ... fields) {
        return this.jedisCluster.hmget(key, fields);
    }

    public Long lpush(String key, String ... strings) {
        return this.jedisCluster.lpush(key, strings);
    }

    public Long hincrBy(byte[] key, byte[] field, long value) {
        return this.jedisCluster.hincrBy(key, field, value);
    }

    public Long llen(String key) {
        return this.jedisCluster.llen(key);
    }

    public Double hincrByFloat(byte[] key, byte[] field, double value) {
        return this.jedisCluster.hincrByFloat(key, field, value);
    }

    public List<String> lrange(String key, long start, long end) {
        return this.jedisCluster.lrange(key, start, end);
    }

    public Boolean hexists(byte[] key, byte[] field) {
        return this.jedisCluster.hexists(key, field);
    }

    public Long hdel(byte[] key, byte[] ... fields) {
        return this.jedisCluster.hdel(key, fields);
    }

    public String ltrim(String key, long start, long end) {
        return this.jedisCluster.ltrim(key, start, end);
    }

    public Long hlen(byte[] key) {
        return this.jedisCluster.hlen(key);
    }

    public Set<byte[]> hkeys(byte[] key) {
        return this.jedisCluster.hkeys(key);
    }

    public List<byte[]> hvals(byte[] key) {
        return new ArrayList<byte[]>(this.jedisCluster.hvals(key));
    }

    public Map<byte[], byte[]> hgetAll(byte[] key) {
        return this.jedisCluster.hgetAll(key);
    }

    public String lindex(String key, long index) {
        return this.jedisCluster.lindex(key, index);
    }

    public Long rpush(byte[] key, byte[] ... strings) {
        return this.jedisCluster.rpush(key, strings);
    }

    public Long lpush(byte[] key, byte[] ... strings) {
        return this.jedisCluster.lpush(key, strings);
    }

    public String lset(String key, long index, String value) {
        return this.jedisCluster.lset(key, index, value);
    }

    public Long llen(byte[] key) {
        return this.jedisCluster.llen(key);
    }

    public Long lrem(String key, long count, String value) {
        return this.jedisCluster.lrem(key, count, value);
    }

    public List<byte[]> lrange(byte[] key, long start, long end) {
        return this.jedisCluster.lrange(key, start, end);
    }

    public String lpop(String key) {
        return this.jedisCluster.lpop(key);
    }

    public String rpop(String key) {
        return this.jedisCluster.rpop(key);
    }

    public String ltrim(byte[] key, long start, long end) {
        return this.jedisCluster.ltrim(key, start, end);
    }

    public String rpoplpush(String srckey, String dstkey) {
        return this.jedisCluster.rpoplpush(srckey, dstkey);
    }

    public Long sadd(String key, String ... members) {
        return this.jedisCluster.sadd(key, members);
    }

    public byte[] lindex(byte[] key, long index) {
        return this.jedisCluster.lindex(key, index);
    }

    public Set<String> smembers(String key) {
        return this.jedisCluster.smembers(key);
    }

    public Long srem(String key, String ... members) {
        return this.jedisCluster.srem(key, members);
    }

    public String lset(byte[] key, long index, byte[] value) {
        return this.jedisCluster.lset(key, index, value);
    }

    public String spop(String key) {
        return this.jedisCluster.spop(key);
    }

    public Set<String> spop(String key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    public Long lrem(byte[] key, long count, byte[] value) {
        return this.jedisCluster.lrem(key, count, value);
    }

    public Long smove(String srckey, String dstkey, String member) {
        return this.jedisCluster.smove(srckey, dstkey, member);
    }

    public byte[] lpop(byte[] key) {
        return this.jedisCluster.lpop(key);
    }

    public Long scard(String key) {
        return this.jedisCluster.scard(key);
    }

    public byte[] rpop(byte[] key) {
        return this.jedisCluster.rpop(key);
    }

    public Boolean sismember(String key, String member) {
        return this.jedisCluster.sismember(key, member);
    }

    public byte[] rpoplpush(byte[] srckey, byte[] dstkey) {
        return this.jedisCluster.rpoplpush(srckey, dstkey);
    }

    public Set<String> sinter(String ... keys) {
        return this.jedisCluster.sinter(keys);
    }

    public Long sadd(byte[] key, byte[] ... members) {
        return this.jedisCluster.sadd(key, members);
    }

    public Long sinterstore(String dstkey, String ... keys) {
        return this.jedisCluster.sinterstore(dstkey, keys);
    }

    public Set<byte[]> smembers(byte[] key) {
        return this.jedisCluster.smembers(key);
    }

    public Set<String> sunion(String ... keys) {
        return this.jedisCluster.sunion(keys);
    }

    public Long srem(byte[] key, byte[] ... member) {
        return this.jedisCluster.srem(key, member);
    }

    public byte[] spop(byte[] key) {
        return this.jedisCluster.spop(key);
    }

    public Long sunionstore(String dstkey, String ... keys) {
        return this.jedisCluster.sunionstore(dstkey, keys);
    }

    public Set<byte[]> spop(byte[] key, long count) {
        return this.jedisCluster.spop(key, count);
    }

    public Set<String> sdiff(String ... keys) {
        return this.jedisCluster.sdiff(keys);
    }

    public Long smove(byte[] srckey, byte[] dstkey, byte[] member) {
        return this.jedisCluster.smove(srckey, dstkey, member);
    }

    public Long sdiffstore(String dstkey, String ... keys) {
        return this.jedisCluster.sdiffstore(dstkey, keys);
    }

    public String srandmember(String key) {
        return this.jedisCluster.srandmember(key);
    }

    public Long scard(byte[] key) {
        return this.jedisCluster.scard(key);
    }

    public Boolean sismember(byte[] key, byte[] member) {
        return this.jedisCluster.sismember(key, member);
    }

    public List<String> srandmember(String key, int count) {
        return this.jedisCluster.srandmember(key, count);
    }

    public Long zadd(String key, double score, String member) {
        return this.jedisCluster.zadd(key, score, member);
    }

    public Set<byte[]> sinter(byte[] ... keys) {
        return this.jedisCluster.sinter(keys);
    }

    public Long zadd(String key, double score, String member, ZAddParams params) {
        return this.jedisCluster.zadd(key, score, member, params);
    }

    public Long zadd(String key, Map<String, Double> scoreMembers) {
        return this.jedisCluster.zadd(key, scoreMembers);
    }

    public Long sinterstore(byte[] dstkey, byte[] ... keys) {
        return this.jedisCluster.sinterstore(dstkey, keys);
    }

    public Long zadd(String key, Map<String, Double> scoreMembers, ZAddParams params) {
        return this.jedisCluster.zadd(key, scoreMembers, params);
    }

    public Set<String> zrange(String key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    public Set<byte[]> sunion(byte[] ... keys) {
        return this.jedisCluster.sunion(keys);
    }

    public Long zrem(String key, String ... members) {
        return this.jedisCluster.zrem(key, members);
    }

    public Double zincrby(String key, double score, String member) {
        return this.jedisCluster.zincrby(key, score, member);
    }

    public Long sunionstore(byte[] dstkey, byte[] ... keys) {
        return this.jedisCluster.sunionstore(dstkey, keys);
    }

    public Set<byte[]> sdiff(byte[] ... keys) {
        return this.jedisCluster.sdiff(keys);
    }

    public Double zincrby(String key, double score, String member, ZIncrByParams params) {
        return this.jedisCluster.zincrby(key, score, member, params);
    }

    public Long sdiffstore(byte[] dstkey, byte[] ... keys) {
        return this.jedisCluster.sdiffstore(dstkey, keys);
    }

    public Long zrank(String key, String member) {
        return this.jedisCluster.zrank(key, member);
    }

    public byte[] srandmember(byte[] key) {
        return this.jedisCluster.srandmember(key);
    }

    public List<byte[]> srandmember(byte[] key, int count) {
        return this.jedisCluster.srandmember(key, count);
    }

    public Long zrevrank(String key, String member) {
        return this.jedisCluster.zrevrank(key, member);
    }

    public Long zadd(byte[] key, double score, byte[] member) {
        return this.jedisCluster.zadd(key, score, member);
    }

    public Set<String> zrevrange(String key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    public Set<Tuple> zrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrangeWithScores(key, start, end);
    }

    public Long zadd(byte[] key, double score, byte[] member, ZAddParams params) {
        return this.jedisCluster.zadd(key, score, member, params);
    }

    public Set<Tuple> zrevrangeWithScores(String key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers) {
        return this.jedisCluster.zadd(key, scoreMembers);
    }

    public Long zcard(String key) {
        return this.jedisCluster.zcard(key);
    }

    public Long zadd(byte[] key, Map<byte[], Double> scoreMembers, ZAddParams params) {
        return this.jedisCluster.zadd(key, scoreMembers, params);
    }

    public Set<byte[]> zrange(byte[] key, long start, long end) {
        return this.jedisCluster.zrange(key, start, end);
    }

    public Double zscore(String key, String member) {
        return this.jedisCluster.zscore(key, member);
    }

    public Long zrem(byte[] key, byte[] ... members) {
        return this.jedisCluster.zrem(key, members);
    }

    public List<String> sort(String key) {
        return this.jedisCluster.sort(key);
    }

    public Double zincrby(byte[] key, double score, byte[] member) {
        return this.jedisCluster.zincrby(key, score, member);
    }

    public List<String> sort(String key, SortingParams sortingParameters) {
        return this.jedisCluster.sort(key, sortingParameters);
    }

    public Double zincrby(byte[] key, double score, byte[] member, ZIncrByParams params) {
        return this.jedisCluster.zincrby(key, score, member, params);
    }

    public Long zrank(byte[] key, byte[] member) {
        return this.jedisCluster.zrank(key, member);
    }

    public List<String> blpop(int timeout, String ... keys) {
        return this.jedisCluster.blpop(timeout, keys);
    }

    public Long zrevrank(byte[] key, byte[] member) {
        return this.jedisCluster.zrevrank(key, member);
    }

    public Set<byte[]> zrevrange(byte[] key, long start, long end) {
        return this.jedisCluster.zrevrange(key, start, end);
    }

    public Set<Tuple> zrangeWithScores(byte[] key, long start, long end) {
        return this.jedisCluster.zrangeWithScores(key, start, end);
    }

    public Set<Tuple> zrevrangeWithScores(byte[] key, long start, long end) {
        return this.jedisCluster.zrevrangeWithScores(key, start, end);
    }

    public Long zcard(byte[] key) {
        return this.jedisCluster.zcard(key);
    }

    public Double zscore(byte[] key, byte[] member) {
        return this.jedisCluster.zscore(key, member);
    }

    public List<byte[]> sort(byte[] key) {
        return this.jedisCluster.sort(key);
    }

    public Long sort(String key, SortingParams sortingParameters, String dstkey) {
        return this.jedisCluster.sort(key, sortingParameters, dstkey);
    }

    public List<byte[]> sort(byte[] key, SortingParams sortingParameters) {
        return this.jedisCluster.sort(key, sortingParameters);
    }

    public Long sort(String key, String dstkey) {
        return this.jedisCluster.sort(key, dstkey);
    }

    public List<String> brpop(int timeout, String ... keys) {
        return this.jedisCluster.brpop(timeout, keys);
    }

    public List<byte[]> blpop(int timeout, byte[] ... keys) {
        return this.jedisCluster.blpop(timeout, keys);
    }

    public Long zcount(String key, double min, double max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    public Long zcount(String key, String min, String max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    public Set<String> zrangeByScore(String key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    public Long sort(byte[] key, SortingParams sortingParameters, byte[] dstkey) {
        return this.jedisCluster.sort(key, sortingParameters, dstkey);
    }

    public Long sort(byte[] key, byte[] dstkey) {
        return this.jedisCluster.sort(key, dstkey);
    }

    public List<byte[]> brpop(int timeout, byte[] ... keys) {
        return this.jedisCluster.brpop(timeout, keys);
    }

    public Set<String> zrangeByScore(String key, String min, String max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    public Set<String> zrangeByScore(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    public Set<String> zrangeByScore(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    public String auth(String password) {
        return this.jedisCluster.auth(password);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    public Long zcount(byte[] key, double min, double max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    public Long zcount(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zcount(key, min, max);
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zrangeByScore(key, min, max);
    }

    public Set<byte[]> zrangeByScore(byte[] key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, double max, double min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    public Set<String> zrevrangeByScore(String key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<byte[]> zrangeByScore(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.jedisCluster.zrangeByScore(key, min, max, offset, count);
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Set<String> zrevrangeByScore(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    public Long zremrangeByRank(String key, long start, long end) {
        return this.jedisCluster.zremrangeByRank(key, start, end);
    }

    public Long zremrangeByScore(String key, double start, double end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max);
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, double min, double max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Long zremrangeByScore(String key, String start, String end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    public Long zunionstore(String dstkey, String ... sets) {
        return this.jedisCluster.zunionstore(dstkey, sets);
    }

    public Long zunionstore(String dstkey, ZParams params, String ... sets) {
        return this.jedisCluster.zunionstore(dstkey, params, sets);
    }

    public Set<Tuple> zrangeByScoreWithScores(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.jedisCluster.zrangeByScoreWithScores(key, min, max, offset, count);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min) {
        return this.jedisCluster.zrevrangeByScore(key, max, min);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    public Set<byte[]> zrevrangeByScore(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScore(key, max, min, offset, count);
    }

    public Long zinterstore(String dstkey, String ... sets) {
        return this.jedisCluster.zinterstore(dstkey, sets);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, double max, double min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min);
    }

    public Set<Tuple> zrevrangeByScoreWithScores(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.jedisCluster.zrevrangeByScoreWithScores(key, max, min, offset, count);
    }

    public Long zremrangeByRank(byte[] key, long start, long end) {
        return this.jedisCluster.zremrangeByRank(key, start, end);
    }

    public Long zremrangeByScore(byte[] key, double start, double end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    public Long zinterstore(String dstkey, ZParams params, String ... sets) {
        return this.jedisCluster.zinterstore(dstkey, params, sets);
    }

    public Long zremrangeByScore(byte[] key, byte[] start, byte[] end) {
        return this.jedisCluster.zremrangeByScore(key, start, end);
    }

    public Long zunionstore(byte[] dstkey, byte[] ... sets) {
        return this.jedisCluster.zunionstore(dstkey, sets);
    }

    public Long zlexcount(String key, String min, String max) {
        return this.jedisCluster.zlexcount(key, min, max);
    }

    public Set<String> zrangeByLex(String key, String min, String max) {
        return this.jedisCluster.zrangeByLex(key, min, max);
    }

    public Set<String> zrangeByLex(String key, String min, String max, int offset, int count) {
        return this.jedisCluster.zrangeByLex(key, min, max, offset, count);
    }

    public Long zunionstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return this.jedisCluster.zunionstore(dstkey, params, sets);
    }

    public Set<String> zrevrangeByLex(String key, String max, String min) {
        return this.jedisCluster.zrevrangeByLex(key, max, min);
    }

    public Set<String> zrevrangeByLex(String key, String max, String min, int offset, int count) {
        return this.jedisCluster.zrevrangeByLex(key, max, min, offset, count);
    }

    public Long zremrangeByLex(String key, String min, String max) {
        return this.jedisCluster.zremrangeByLex(key, min, max);
    }

    public Long strlen(String key) {
        return this.jedisCluster.strlen(key);
    }

    public Long lpushx(String key, String ... string) {
        return this.jedisCluster.lpushx(key, string);
    }

    public Long persist(String key) {
        return this.jedisCluster.persist(key);
    }

    public Long rpushx(String key, String ... string) {
        return this.jedisCluster.rpushx(key, string);
    }

    public String echo(String string) {
        return this.jedisCluster.echo(string);
    }

    public Long zinterstore(byte[] dstkey, byte[] ... sets) {
        return this.jedisCluster.zinterstore(dstkey, sets);
    }

    public Long linsert(String key, BinaryClient.LIST_POSITION where, String pivot, String value) {
        return this.jedisCluster.linsert(key, where, pivot, value);
    }

    public String brpoplpush(String source, String destination, int timeout) {
        return this.jedisCluster.brpoplpush(source, destination, timeout);
    }

    public Boolean setbit(String key, long offset, boolean value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    public Boolean setbit(String key, long offset, String value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    public Boolean getbit(String key, long offset) {
        return this.jedisCluster.getbit(key, offset);
    }

    public Long setrange(String key, long offset, String value) {
        return this.jedisCluster.setrange(key, offset, value);
    }

    public String getrange(String key, long startOffset, long endOffset) {
        return this.jedisCluster.getrange(key, startOffset, endOffset);
    }

    public Long bitpos(String key, boolean value) {
        return this.jedisCluster.bitpos(key, value);
    }

    public Long bitpos(String key, boolean value, BitPosParams params) {
        return this.jedisCluster.bitpos(key, value, params);
    }

    public Long zinterstore(byte[] dstkey, ZParams params, byte[] ... sets) {
        return this.jedisCluster.zinterstore(dstkey, params, sets);
    }

    public Long zlexcount(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zlexcount(key, min, max);
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zrangeByLex(key, min, max);
    }

    public Set<byte[]> zrangeByLex(byte[] key, byte[] min, byte[] max, int offset, int count) {
        return this.jedisCluster.zrangeByLex(key, min, max, offset, count);
    }

    public Object eval(String script, int keyCount, String ... params) {
        return this.jedisCluster.eval(script, keyCount, params);
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min) {
        return this.jedisCluster.zrevrangeByLex(key, max, min);
    }

    public void subscribe(JedisPubSub jedisPubSub, String ... channels) {
        this.jedisCluster.subscribe(jedisPubSub, channels);
    }

    public Set<byte[]> zrevrangeByLex(byte[] key, byte[] max, byte[] min, int offset, int count) {
        return this.jedisCluster.zrevrangeByLex(key, max, min, offset, count);
    }

    public Long publish(String channel, String message) {
        return this.jedisCluster.publish(channel, message);
    }

    public Long zremrangeByLex(byte[] key, byte[] min, byte[] max) {
        return this.jedisCluster.zremrangeByLex(key, min, max);
    }

    public void psubscribe(JedisPubSub jedisPubSub, String ... patterns) {
        this.jedisCluster.psubscribe(jedisPubSub, patterns);
    }

    public Object eval(String script, List<String> keys, List<String> args) {
        return this.jedisCluster.eval(script, keys, args);
    }

    public Object evalsha(String sha1, List<String> keys, List<String> args) {
        return this.jedisCluster.evalsha(sha1, keys, args);
    }

    public Object evalsha(String sha1, int keyCount, String ... params) {
        return this.jedisCluster.evalsha(sha1, keyCount, params);
    }

    public Long bitcount(String key) {
        return this.jedisCluster.bitcount(key);
    }

    public Long bitcount(String key, long start, long end) {
        return this.jedisCluster.bitcount(key, start, end);
    }

    public Long bitop(BitOP op, String destKey, String ... srcKeys) {
        return this.jedisCluster.bitop(op, destKey, srcKeys);
    }

    public Long pexpire(String key, int milliseconds) {
        return this.jedisCluster.pexpire(key, (long)milliseconds);
    }

    public Long pexpire(String key, long milliseconds) {
        return this.jedisCluster.pexpire(key, milliseconds);
    }

    public Long pexpireAt(String key, long millisecondsTimestamp) {
        return this.jedisCluster.pexpireAt(key, millisecondsTimestamp);
    }

    public Long pttl(String key) {
        return this.jedisCluster.pttl(key);
    }

    public String psetex(String key, int milliseconds, String value) {
        return this.jedisCluster.psetex(key, (long)milliseconds, value);
    }

    public String psetex(String key, long milliseconds, String value) {
        return this.jedisCluster.psetex(key, milliseconds, value);
    }

    public String set(String key, String value, String nxxx) {
        return this.jedisCluster.set(key, value, nxxx);
    }

    public String set(String key, String value, String nxxx, String expx, int time) {
        return this.jedisCluster.set(key, value, nxxx, expx, (long)time);
    }

    public Long strlen(byte[] key) {
        return this.jedisCluster.strlen(key);
    }

    public Long lpushx(byte[] key, byte[] ... string) {
        return this.jedisCluster.lpushx(key, string);
    }

    public Long persist(byte[] key) {
        return this.jedisCluster.persist(key);
    }

    public Long rpushx(byte[] key, byte[] ... string) {
        return this.jedisCluster.rpushx(key, string);
    }

    public byte[] echo(byte[] string) {
        return this.jedisCluster.echo(string);
    }

    public Long linsert(byte[] key, BinaryClient.LIST_POSITION where, byte[] pivot, byte[] value) {
        return this.jedisCluster.linsert(key, where, pivot, value);
    }

    public byte[] brpoplpush(byte[] source, byte[] destination, int timeout) {
        return this.jedisCluster.brpoplpush(source, destination, timeout);
    }

    public Boolean setbit(byte[] key, long offset, boolean value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    public Boolean setbit(byte[] key, long offset, byte[] value) {
        return this.jedisCluster.setbit(key, offset, value);
    }

    public Boolean getbit(byte[] key, long offset) {
        return this.jedisCluster.getbit(key, offset);
    }

    public Long setrange(byte[] key, long offset, byte[] value) {
        return this.jedisCluster.setrange(key, offset, value);
    }

    public byte[] getrange(byte[] key, long startOffset, long endOffset) {
        return this.jedisCluster.getrange(key, startOffset, endOffset);
    }

    public ScanResult<String> sscan(String key, int cursor) {
        return this.jedisCluster.sscan(key, cursor);
    }

    public Long publish(byte[] channel, byte[] message) {
        return this.jedisCluster.publish(channel, message);
    }

    public void subscribe(BinaryJedisPubSub jedisPubSub, byte[] ... channels) {
        this.jedisCluster.subscribe(jedisPubSub, channels);
    }

    @Deprecated
    public ScanResult<String> sscan(String key, int cursor, ScanParams params) {
        return this.jedisCluster.sscan(key, "" + cursor, params);
    }

    public void psubscribe(BinaryJedisPubSub jedisPubSub, byte[] ... patterns) {
        this.jedisCluster.psubscribe(jedisPubSub, patterns);
    }

    public Long getDB() {
        return this.jedisCluster.getDB();
    }

    public Object eval(byte[] script, List<byte[]> keys, List<byte[]> args) {
        return this.jedisCluster.eval(script, keys, args);
    }

    public Object eval(byte[] script, byte[] keyCount, byte[] ... params) {
        return this.jedisCluster.eval(script, keyCount, params);
    }

    public Object eval(byte[] script, int keyCount, byte[] ... params) {
        return this.jedisCluster.eval(script, keyCount, params);
    }

    public Object evalsha(byte[] sha1, List<byte[]> keys, List<byte[]> args) {
        return this.jedisCluster.evalsha(sha1, keys, args);
    }

    public Object evalsha(byte[] sha1, int keyCount, byte[] ... params) {
        return this.jedisCluster.evalsha(sha1, keyCount, params);
    }

    public ScanResult<String> scan(String cursor, ScanParams params) {
        return this.jedisCluster.scan(cursor, params);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor) {
        return this.jedisCluster.hscan(key, cursor);
    }

    public ScanResult<Map.Entry<String, String>> hscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.hscan(key, cursor, params);
    }

    public Long bitcount(byte[] key) {
        return this.jedisCluster.bitcount(key);
    }

    public ScanResult<String> sscan(String key, String cursor) {
        return this.jedisCluster.sscan(key, cursor);
    }

    public Long bitcount(byte[] key, long start, long end) {
        return this.jedisCluster.bitcount(key, start, end);
    }

    public ScanResult<String> sscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.sscan(key, cursor, params);
    }

    public Long bitop(BitOP op, byte[] destKey, byte[] ... srcKeys) {
        return this.jedisCluster.bitop(op, destKey, srcKeys);
    }

    public ScanResult<Tuple> zscan(String key, String cursor) {
        return this.jedisCluster.zscan(key, cursor);
    }

    public Long pexpire(byte[] key, int milliseconds) {
        return this.jedisCluster.pexpire(key, (long)milliseconds);
    }

    public ScanResult<Tuple> zscan(String key, String cursor, ScanParams params) {
        return this.jedisCluster.zscan(key, cursor, params);
    }

    public Long pexpire(byte[] key, long milliseconds) {
        return this.jedisCluster.pexpire(key, milliseconds);
    }

    public Long pexpireAt(byte[] key, long millisecondsTimestamp) {
        return this.jedisCluster.pexpireAt(key, millisecondsTimestamp);
    }

    public String set(byte[] key, byte[] value, byte[] nxxx, byte[] expx, int time) {
        return this.jedisCluster.set(key, value, nxxx, expx, (long)time);
    }

    public Long pfadd(byte[] key, byte[] ... elements) {
        return this.jedisCluster.pfadd(key, elements);
    }

    public long pfcount(byte[] key) {
        return this.jedisCluster.pfcount(key);
    }

    public String pfmerge(byte[] destkey, byte[] ... sourcekeys) {
        return this.jedisCluster.pfmerge(destkey, sourcekeys);
    }

    public Long pfcount(byte[] ... keys) {
        return this.jedisCluster.pfcount(keys);
    }

    public ScanResult<byte[]> scan(byte[] cursor, ScanParams params) {
        return this.jedisCluster.scan(cursor, params);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor) {
        return this.jedisCluster.hscan(key, cursor);
    }

    public ScanResult<Map.Entry<byte[], byte[]>> hscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.jedisCluster.hscan(key, cursor, params);
    }

    public void close() {
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor) {
        return this.jedisCluster.sscan(key, cursor);
    }

    public Long pfadd(String key, String ... elements) {
        return this.jedisCluster.pfadd(key, elements);
    }

    public ScanResult<byte[]> sscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.jedisCluster.sscan(key, cursor, params);
    }

    public long pfcount(String key) {
        return this.jedisCluster.pfcount(key);
    }

    public long pfcount(String ... keys) {
        return this.jedisCluster.pfcount(keys);
    }

    public String pfmerge(String destkey, String ... sourcekeys) {
        return this.jedisCluster.pfmerge(destkey, sourcekeys);
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor) {
        return this.jedisCluster.zscan(key, cursor);
    }

    public ScanResult<Tuple> zscan(byte[] key, byte[] cursor, ScanParams params) {
        return this.jedisCluster.zscan(key, cursor, params);
    }

    public List<String> blpop(int timeout, String key) {
        return this.jedisCluster.blpop(timeout, key);
    }

    public List<String> brpop(int timeout, String key) {
        return this.jedisCluster.brpop(timeout, key);
    }

    public Long geoadd(String key, double longitude, double latitude, String member) {
        return this.jedisCluster.geoadd(key, longitude, latitude, member);
    }

    public Long geoadd(String key, Map<String, GeoCoordinate> memberCoordinateMap) {
        return this.jedisCluster.geoadd(key, memberCoordinateMap);
    }

    public Long geoadd(byte[] key, double longitude, double latitude, byte[] member) {
        return this.jedisCluster.geoadd(key, longitude, latitude, member);
    }

    public Double geodist(String key, String member1, String member2) {
        return this.jedisCluster.geodist(key, member1, member2);
    }

    public Long geoadd(byte[] key, Map<byte[], GeoCoordinate> memberCoordinateMap) {
        return this.jedisCluster.geoadd(key, memberCoordinateMap);
    }

    public Double geodist(String key, String member1, String member2, GeoUnit unit) {
        return this.jedisCluster.geodist(key, member1, member2, unit);
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2) {
        return this.jedisCluster.geodist(key, member1, member2);
    }

    public List<String> geohash(String key, String ... members) {
        return this.jedisCluster.geohash(key, members);
    }

    public Double geodist(byte[] key, byte[] member1, byte[] member2, GeoUnit unit) {
        return this.jedisCluster.geodist(key, member1, member2, unit);
    }

    public List<GeoCoordinate> geopos(String key, String ... members) {
        return this.jedisCluster.geopos(key, members);
    }

    public List<byte[]> geohash(byte[] key, byte[] ... members) {
        return this.jedisCluster.geohash(key, members);
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit);
    }

    public List<GeoCoordinate> geopos(byte[] key, byte[] ... members) {
        return this.jedisCluster.geopos(key, members);
    }

    public List<GeoRadiusResponse> georadius(String key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit);
    }

    public List<GeoRadiusResponse> georadius(byte[] key, double longitude, double latitude, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadius(key, longitude, latitude, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusByMember(String key, String member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit, param);
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit);
    }

    public List<GeoRadiusResponse> georadiusByMember(byte[] key, byte[] member, double radius, GeoUnit unit, GeoRadiusParam param) {
        return this.jedisCluster.georadiusByMember(key, member, radius, unit, param);
    }

    public String ping() {
        return this.jedisCluster.ping();
    }

    @Deprecated
    public String bgsave() {
        return this.jedisCluster.bgsave();
    }

    @Deprecated
    public String bgrewriteaof() {
        return this.jedisCluster.bgrewriteaof();
    }

    @Deprecated
    public String slaveofNoOne() {
        return this.jedisCluster.slaveofNoOne();
    }

    @Deprecated
    public Long waitReplicas(int replicas, long timeout) {
        return this.jedisCluster.waitReplicas(replicas, timeout);
    }

    @Deprecated
    public String select(int index) {
        return this.jedisCluster.select(index);
    }

    @Deprecated
    public List<String> blpop(String arg) {
        return this.jedisCluster.blpop(arg);
    }

    @Deprecated
    public List<String> brpop(String arg) {
        return this.jedisCluster.brpop(arg);
    }

    public String save() {
        return this.jedisCluster.save();
    }

    public String info() {
        return this.jedisCluster.info();
    }

    public String info(String section) {
        return this.jedisCluster.info(section);
    }

    public String slaveof(String host, int port) {
        return this.jedisCluster.slaveof(host, port);
    }

    @Deprecated
    public String configResetStat() {
        return this.jedisCluster.configResetStat();
    }

    @Deprecated
    public String debug(DebugParams params) {
        return this.jedisCluster.debug(params);
    }

    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor) {
        return this.jedisCluster.hscan(key, cursor);
    }

    @Deprecated
    public ScanResult<Map.Entry<String, String>> hscan(String key, int cursor, ScanParams params) {
        return this.jedisCluster.hscan(key, "" + cursor, params);
    }

    @Deprecated
    public Long bitpos(byte[] key, boolean value) {
        return this.jedisCluster.bitpos(new String(key), value);
    }

    @Deprecated
    public Long bitpos(byte[] key, boolean value, BitPosParams params) {
        return this.jedisCluster.bitpos(new String(key), value, params);
    }

    @Deprecated
    public ScanResult<Tuple> zscan(String key, int cursor) {
        return this.jedisCluster.zscan(key, cursor);
    }

    @Deprecated
    public String randomKey() {
        throw Lang.noImplement();
    }

    @Deprecated
    public byte[] randomBinaryKey() {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long move(byte[] key, int dbIndex) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Transaction multi() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Object> multi(TransactionBlock jedisTransaction) {
        throw Lang.noImplement();
    }

    @Deprecated
    public void connect() {
    }

    @Deprecated
    public void disconnect() {
    }

    @Deprecated
    public void resetState() {
    }

    @Deprecated
    public List<String> blpop(String ... args) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> brpop(String ... args) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String watch(byte[] ... keys) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String unwatch() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> blpop(byte[] arg) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> brpop(byte[] arg) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> blpop(byte[] ... args) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> brpop(byte[] ... args) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Object> pipelined(PipelineBlock jedisPipeline) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Pipeline pipelined() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> configGet(String pattern) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String configSet(String parameter, String value) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Object eval(String script) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Object evalsha(String script) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Boolean scriptExists(String sha1) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Boolean> scriptExists(String ... sha1) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String scriptLoad(String script) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Slowlog> slowlogGet() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Slowlog> slowlogGet(long entries) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long objectRefcount(String string) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String objectEncoding(String string) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long lastsave() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String shutdown() {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long objectIdletime(String string) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Map<String, String>> sentinelMasters() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> sentinelGetMasterAddrByName(String masterName) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long sentinelReset(String pattern) {
        throw Lang.noImplement();
    }

    @Deprecated
    public void monitor(JedisMonitor jedisMonitor) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Map<String, String>> sentinelSlaves(String masterName) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String sentinelFailover(String masterName) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String sentinelMonitor(String masterName, String ip, int port, int quorum) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> configGet(byte[] pattern) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String sentinelRemove(String masterName) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String sentinelSet(String masterName, Map<String, String> parameterMap) {
        throw Lang.noImplement();
    }

    @Deprecated
    public byte[] dump(String key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String restore(String key, int ttl, byte[] serializedValue) {
        throw Lang.noImplement();
    }

    @Deprecated
    public byte[] configSet(byte[] parameter, byte[] value) {
        throw Lang.noImplement();
    }

    @Deprecated
    public boolean isConnected() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clientKill(String client) {
        throw Lang.noImplement();
    }

    @Deprecated
    public void sync() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clientSetname(String name) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String migrate(String host, int port, String key, int destinationDb, int timeout) {
        throw Lang.noImplement();
    }

    @Deprecated
    public ScanResult<String> scan(int cursor) {
        throw Lang.noImplement();
    }

    @Deprecated
    public ScanResult<String> scan(int cursor, ScanParams params) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Client getClient() {
        throw Lang.noImplement();
    }

    @Deprecated
    public ScanResult<Tuple> zscan(String key, int cursor, ScanParams params) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Object eval(byte[] script) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Object evalsha(byte[] sha1) {
        throw Lang.noImplement();
    }

    @Deprecated
    public ScanResult<String> scan(String cursor) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String scriptFlush() {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long scriptExists(byte[] sha1) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Long> scriptExists(byte[] ... sha1) {
        throw Lang.noImplement();
    }

    @Deprecated
    public byte[] scriptLoad(byte[] script) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String scriptKill() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String slowlogReset() {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long slowlogLen() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> slowlogGetBinary() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<byte[]> slowlogGetBinary(long entries) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long objectRefcount(byte[] key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public byte[] objectEncoding(byte[] key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long objectIdletime(byte[] key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public byte[] dump(byte[] key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String restore(byte[] key, int ttl, byte[] serializedValue) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long pttl(byte[] key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String psetex(byte[] key, int milliseconds, byte[] value) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterNodes() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String psetex(byte[] key, long milliseconds, byte[] value) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String readonly() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterMeet(String ip, int port) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterReset(JedisCluster.Reset resetType) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String set(byte[] key, byte[] value, byte[] nxxx) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterAddSlots(int ... slots) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterDelSlots(int ... slots) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterInfo() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clientKill(byte[] client) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> clusterGetKeysInSlot(int slot, int count) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clientGetname() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clientList() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterSetSlotNode(int slot, String nodeId) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clientSetname(byte[] name) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterSetSlotMigrating(int slot, String nodeId) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> time() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterSetSlotImporting(int slot, String nodeId) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String migrate(byte[] host, int port, byte[] key, int destinationDb, int timeout) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterSetSlotStable(int slot) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterForget(String nodeId) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterFlushSlots() {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long clusterKeySlot(String key) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long clusterCountKeysInSlot(int slot) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterSaveConfig() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterReplicate(String nodeId) {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> clusterSlaves(String nodeId) {
        throw Lang.noImplement();
    }

    @Deprecated
    public ScanResult<byte[]> scan(byte[] cursor) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String clusterFailover() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<Object> clusterSlots() {
        throw Lang.noImplement();
    }

    @Deprecated
    public String asking() {
        throw Lang.noImplement();
    }

    @Deprecated
    public List<String> pubsubChannels(String pattern) {
        throw Lang.noImplement();
    }

    @Deprecated
    public Long pubsubNumPat() {
        throw Lang.noImplement();
    }

    @Deprecated
    public Map<String, String> pubsubNumSub(String ... channels) {
        throw Lang.noImplement();
    }

    @Deprecated
    public void setDataSource(Pool<Jedis> jedisPool) {
        throw Lang.noImplement();
    }

    @Deprecated
    public String watch(String ... keys) {
        throw Lang.noImplement();
    }
}

