/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock;

import java.lang.reflect.Field;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.impl.NutIoc;
import org.nutz.ioc.loader.annotation.Inject;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.log.Log;
import org.nutz.log.Logs;
import org.nutz.mvc.annotation.IocBy;

public abstract class NutIocTestBase
extends Assert {
    private static final Log log = Logs.get();
    protected Ioc ioc;

    protected Class<?> getMainModule() throws Exception {
        throw new IllegalArgumentException("Must override one of getMainModule/getIocArgs/getIocLoader");
    }

    protected String[] getIocArgs() throws Exception {
        return this.getMainModule().getAnnotation(IocBy.class).args();
    }

    protected IocLoader getIocLoader() throws Exception {
        return new ComboIocLoader(this.getIocArgs());
    }

    protected void _before() throws Exception {
    }

    protected void _after() throws Exception {
    }

    @Before
    public void before() throws Exception {
        this.ioc = new NutIoc(this.getIocLoader());
        this.injectSelfFields();
        this._before();
    }

    @After
    public void after() throws Exception {
        this._after();
        if (this.ioc != null) {
            this.ioc.depose();
        }
    }

    protected void injectSelfFields() throws Exception {
        for (Field field : ((Object)((Object)this)).getClass().getDeclaredFields()) {
            Inject inject = field.getAnnotation(Inject.class);
            if (inject == null) continue;
            log.debug((Object)("inject field name=" + field.getName()));
            field.setAccessible(true);
            Object obj = this.ioc.get(field.getType(), field.getName());
            field.set((Object)this, obj);
        }
    }
}

