/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock;

import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.nutz.ioc.Ioc;
import org.nutz.ioc.IocLoader;
import org.nutz.ioc.impl.NutIoc;
import org.nutz.ioc.loader.annotation.IocBean;
import org.nutz.ioc.loader.combo.ComboIocLoader;
import org.nutz.mvc.annotation.IocBy;

public class NutTestRunner
extends BlockJUnit4ClassRunner {
    ThreadLocal<Ioc> iocHolder = new ThreadLocal();

    public NutTestRunner(Class<?> klass) throws InitializationError {
        super(klass);
        if (klass.getAnnotation(IocBean.class) == null) {
            throw new InitializationError("Must mark as @IocBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        if (this.isIgnored(method)) {
            super.runChild(method, notifier);
            return;
        }
        Ioc ioc = this.createIoc();
        try {
            this.iocHolder.set(ioc);
            super.runChild(method, notifier);
        }
        finally {
            this.iocHolder.remove();
            ioc.depose();
        }
    }

    protected Class<?> getMainModule() {
        throw new IllegalArgumentException("Must override one of getMainModule/getIocArgs/createIocLoader/createIoc");
    }

    protected String[] getIocArgs() {
        return this.getMainModule().getAnnotation(IocBy.class).args();
    }

    protected IocLoader createIocLoader() {
        try {
            return new ComboIocLoader(this.getIocArgs());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Ioc createIoc() {
        return new NutIoc(this.createIocLoader());
    }

    protected Object createTest() throws Exception {
        return this.iocHolder.get().get(this.getTestClass().getJavaClass());
    }
}

