/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock.servlet;

import java.io.IOException;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.nutz.castor.Castors;
import org.nutz.lang.Lang;
import org.nutz.mock.Mock;
import org.nutz.mock.servlet.MockRequestDispatcher;
import org.nutz.mock.servlet.multipart.MultipartInputStream;
import org.nutz.mvc.Mvcs;

public class MockHttpServletRequest
extends HttpServletRequestWrapper {
    protected HttpSession session;
    protected String contextPath;
    protected String[] dispatcherTarget;
    protected String remoteAddr = "127.0.0.1";
    protected String remoteHost = "localhost";
    protected int remotePort = 12345;
    protected Map<String, String> headers;
    protected String method;
    protected String pathInfo;
    protected String pathTranslated;
    public String remoteUser;
    protected String requestURI;
    protected StringBuffer requestURL;
    protected String servletPath;
    protected Principal userPrincipal;
    protected Map<String, Object> attributeMap = new HashMap<String, Object>();
    protected String characterEncoding;
    protected ServletInputStream inputStream;
    protected Map<String, String[]> params = new HashMap<String, String[]>();
    protected String protocol;

    public MockHttpServletRequest() {
        super(Mock.EmtryHttpServletRequest);
        this.headers = new HashMap<String, String>();
        this.dispatcherTarget = new String[1];
        Mvcs.set((String)"", (HttpServletRequest)this, null);
    }

    public String getDispatcherTarget() {
        return this.dispatcherTarget[0];
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public void setHeader(String name, Object value) {
        this.headers.put(name, value.toString());
    }

    public Enumeration<String> getHeaderNames() {
        return Lang.enumeration(this.headers.keySet());
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    public String getPathTranslated() {
        return this.pathTranslated;
    }

    public void setPathTranslated(String pathTranslated) {
        this.pathTranslated = pathTranslated;
    }

    public String getQueryString() {
        if (this.params.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String[]> entry : this.params.entrySet()) {
            if (entry.getValue() == null) {
                sb.append(entry.getKey()).append("=&");
                continue;
            }
            for (String str : entry.getValue()) {
                sb.append(entry.getKey()).append("=").append(str).append("&");
            }
        }
        return sb.toString();
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String remoteUser) {
        this.remoteUser = remoteUser;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }

    public void setRequestURL(StringBuffer requestURL) {
        this.requestURL = requestURL;
    }

    public String getRequestedSessionId() {
        if (this.session != null) {
            return this.session.getId();
        }
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean flag) {
        return this.session;
    }

    public MockHttpServletRequest setSession(HttpSession session) {
        this.session = session;
        return this;
    }

    public Principal getUserPrincipal() {
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal) {
        this.userPrincipal = userPrincipal;
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        return new Vector<String>(this.attributeMap.keySet()).elements();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public int getContentLength() {
        String cl = this.getHeader("content-length");
        try {
            return Integer.parseInt(cl);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public String getContentType() {
        return this.getHeader("content-type");
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.inputStream;
    }

    public MockHttpServletRequest setInputStream(ServletInputStream ins) {
        this.inputStream = ins;
        return this;
    }

    public MockHttpServletRequest init() {
        if (null != this.inputStream && this.inputStream instanceof MultipartInputStream) {
            ((MultipartInputStream)this.inputStream).init();
            this.setCharacterEncoding(((MultipartInputStream)this.inputStream).getCharset());
            try {
                this.setHeader("content-length", this.inputStream.available());
                this.setHeader("content-type", ((MultipartInputStream)this.inputStream).getContentType());
            }
            catch (IOException e) {
                throw Lang.wrapThrow((Throwable)e);
            }
        }
        Mvcs.set((String)"", (HttpServletRequest)this, null);
        return this;
    }

    public String getParameter(String key) {
        if (this.params.containsKey(key)) {
            return this.params.get(key)[0];
        }
        return null;
    }

    public void setParameter(String key, String value) {
        this.params.put(key, new String[]{value});
    }

    public void setParameter(String key, Number num) {
        this.setParameter(key, num.toString());
    }

    public void setParameterValues(String key, String[] values) {
        this.params.put(key, values);
    }

    public void addParameter(String key, String value) {
        this.params.put(key, new String[]{value});
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public Enumeration<String> getParameterNames() {
        return new Vector<String>(this.params.keySet()).elements();
    }

    public String[] getParameterValues(String name) {
        String[] param = this.params.get(name);
        return (String[])Castors.me().castTo((Object)param, String[].class);
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public RequestDispatcher getRequestDispatcher(String dest) {
        return new MockRequestDispatcher(this.dispatcherTarget, dest);
    }

    public void removeAttribute(String key) {
        this.attributeMap.remove(key);
    }

    public void setAttribute(String key, Object value) {
        this.attributeMap.put(key, value);
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public ServletContext getServletContext() {
        return this.session.getServletContext();
    }

    public String getRemoteAddr() {
        return this.remoteAddr;
    }

    public void setRemoteAddr(String remoteAddr) {
        this.remoteAddr = remoteAddr;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String remoteHost) {
        this.remoteHost = remoteHost;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }
}

