/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock.servlet;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponseWrapper;
import org.nutz.castor.Castors;
import org.nutz.lang.Encoding;
import org.nutz.lang.Lang;
import org.nutz.mock.Mock;

public class MockHttpServletResponse
extends HttpServletResponseWrapper {
    protected ByteArrayOutputStream stream = new ByteArrayOutputStream();
    protected PrintWriter writer;
    protected Map<String, String> headers;
    protected Set<Cookie> cookies;
    protected int status = 200;
    protected String statusMessage = "OK";
    protected Locale locale;
    protected String contentType;
    protected String characterEncoding = Encoding.defaultEncoding();

    public MockHttpServletResponse() {
        super(Mock.EmtryHttpServletResponse);
        this.headers = new HashMap<String, String>();
        this.cookies = new HashSet<Cookie>();
    }

    public void addCookie(Cookie cookie) {
        this.cookies.add(cookie);
    }

    public void addDateHeader(String key, long value) {
        this.headers.put(key, "" + value);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addIntHeader(String key, int value) {
        this.headers.put(key, "" + value);
    }

    public boolean containsHeader(String key) {
        return this.headers.containsKey(key);
    }

    public void sendError(int error) throws IOException {
        this.setStatus(error);
    }

    public void sendError(int arg0, String arg1) throws IOException {
        this.setStatus(arg0, arg1);
    }

    public void sendRedirect(String value) throws IOException {
        this.headers.put("Location", "" + value);
    }

    public void setDateHeader(String key, long value) {
        this.headers.put(key, "" + value);
    }

    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void setIntHeader(String key, int value) {
        this.headers.put(key, "" + value);
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(int status, String statusMessage) {
        this.status = status;
        this.statusMessage = statusMessage;
    }

    public void flushBuffer() throws IOException {
        this.getWriter().flush();
    }

    public int getBufferSize() {
        return this.stream.size();
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){

            public void write(int arg0) throws IOException {
                MockHttpServletResponse.this.stream.write(arg0);
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        if (this.writer == null) {
            this.writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.stream, this.characterEncoding));
        }
        return this.writer;
    }

    public void reset() {
        this.stream.reset();
    }

    public void resetBuffer() {
        this.stream.reset();
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public int getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getAsString() {
        try {
            this.getWriter().flush();
            return this.stream.toString(this.characterEncoding);
        }
        catch (UnsupportedEncodingException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        catch (IOException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }

    public int getAsInt() {
        return Integer.parseInt(this.getAsString());
    }

    public long getAsLong() {
        return Long.parseLong(this.getAsString());
    }

    public <T> T getAs(Class<T> type) {
        return (T)Castors.me().castTo((Object)this.getAsString(), type);
    }

    public String getHeader(String key) {
        return this.headers.get(key);
    }

    public boolean isCommitted() {
        return false;
    }
}

