/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock.servlet.multipart;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.nutz.lang.Files;
import org.nutz.lang.Lang;
import org.nutz.mock.servlet.MockInputStream;
import org.nutz.mock.servlet.multipart.MultipartItem;
import org.nutz.mock.servlet.multipart.inputing.InputingHelper;
import org.nutz.mock.servlet.multipart.item.EndlMultipartItem;
import org.nutz.mock.servlet.multipart.item.FileMultipartItem;
import org.nutz.mock.servlet.multipart.item.ParamMultipartItem;

public class MultipartInputStream
extends MockInputStream {
    private Map<String, String> mimes;
    private LinkedList<MultipartItem> items;
    private Iterator<MultipartItem> it;
    private MultipartItem current;
    private String boundary;
    private InputingHelper helper;

    public MultipartInputStream(String charset, String boundary) {
        this.boundary = boundary;
        this.helper = new InputingHelper(charset);
        this.mimes = new HashMap<String, String>();
        this.addMime("png", "image/png");
        this.addMime("jpg", "image/jpg");
        this.addMime("gif", "image/gif");
        this.addMime("txt", "text/plain");
        this.items = new LinkedList();
        this.items.add(new EndlMultipartItem(this.helper, boundary));
    }

    public String getCharset() {
        return this.helper.getCharset();
    }

    private String getContentType(String suffixName) {
        String ct = this.mimes.get(suffixName);
        if (null == ct) {
            return "application/octet-stream";
        }
        return ct;
    }

    public String getContentType() {
        return "multipart/form-data; boundary=" + this.boundary;
    }

    public int available() throws IOException {
        int re = 0;
        Iterator it = this.items.iterator();
        while (it.hasNext()) {
            re = (int)((long)re + ((MultipartItem)it.next()).size());
        }
        return re;
    }

    public MultipartInputStream addMime(String suffix, String contentType) {
        this.mimes.put(suffix, contentType);
        return this;
    }

    public void append(String name, File f) {
        String contentType = this.getContentType(Files.getSuffixName((File)f));
        FileMultipartItem fmi = new FileMultipartItem(this.helper, this.boundary, name, f, contentType);
        this.append(fmi);
    }

    @Override
    public void append(String name, String value) {
        this.append(new ParamMultipartItem(this.helper, this.boundary, name, value));
    }

    private void append(MultipartItem item) {
        this.items.add(this.items.size() - 1, item);
    }

    public int read() throws IOException {
        int d = this.current.read();
        while (-1 == d) {
            if (!this.it.hasNext()) {
                return -1;
            }
            this.current = this.it.next();
            d = this.current.read();
        }
        return d;
    }

    @Override
    public void init() {
        try {
            for (MultipartItem item : this.items) {
                item.init();
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
        this.it = this.items.iterator();
        this.current = this.it.next();
    }

    public void close() throws IOException {
        try {
            for (MultipartItem item : this.items) {
                item.close();
            }
        }
        catch (IOException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }
}

