/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock.servlet.multipart;

import java.io.IOException;
import org.nutz.mock.servlet.multipart.inputing.Inputing;
import org.nutz.mock.servlet.multipart.inputing.InputingHelper;
import org.nutz.mock.servlet.multipart.inputing.VoidInputing;

public abstract class MultipartItem {
    private Inputing[] inputs = new Inputing[7];
    private int last = 0;
    private int index = 0;
    private Inputing current;

    public MultipartItem(InputingHelper helper, String boundary) {
        this.addInputing(helper.boundary(boundary));
    }

    protected void addInputing(Inputing in) {
        this.inputs[this.last++] = in;
    }

    public long size() {
        long re = 0L;
        for (int i = 0; i < this.last; ++i) {
            re += this.inputs[i].size();
        }
        return re;
    }

    public int read() throws IOException {
        int d = this.current.read();
        while (d == -1) {
            if (this.index >= this.last - 1) {
                return d;
            }
            this.current = this.inputs[++this.index];
            d = this.current.read();
        }
        return d;
    }

    public void init() throws IOException {
        for (int i = 0; i < this.last; ++i) {
            this.inputs[i].init();
        }
        this.current = this.inputs.length > 0 ? this.inputs[0] : new VoidInputing();
    }

    public void close() throws IOException {
        for (int i = 0; i < this.last; ++i) {
            this.inputs[i].close();
        }
        this.current = null;
    }
}

