/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.mock.servlet.multipart.inputing;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.charset.Charset;
import org.nutz.lang.Lang;
import org.nutz.mock.servlet.multipart.inputing.FileInputing;
import org.nutz.mock.servlet.multipart.inputing.Inputing;
import org.nutz.mock.servlet.multipart.inputing.StringInputing;

public class InputingHelper {
    private String charset;

    public InputingHelper(String charset) {
        this.charset = charset;
    }

    public String getCharset() {
        return this.charset;
    }

    public Inputing wrap(String fmt, Object ... args) {
        return new StringInputing(String.format(fmt, args) + "\r\n", Charset.forName(this.charset));
    }

    public Inputing name(String name) {
        return this.wrap("Content-Disposition: form-data; name=\"%s\"", name);
    }

    public Inputing fileName(String name, String fileName) {
        return this.wrap("Content-Disposition: form-data; name=\"%s\"; filename=\"%s\"", name, fileName);
    }

    public Inputing contentType(String contentType) {
        return this.wrap("Content-Type: %s", contentType);
    }

    public Inputing blankLine() {
        return new StringInputing("\r\n");
    }

    public Inputing boundary(String boundary) {
        return new StringInputing("--" + boundary);
    }

    public Inputing data(String str) {
        return new StringInputing(str, Charset.forName(this.charset));
    }

    public Inputing file(File f) {
        try {
            return new FileInputing(f);
        }
        catch (FileNotFoundException e) {
            throw Lang.wrapThrow((Throwable)e);
        }
    }
}

