/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover.internal.lifecycle;

import com.atlassian.clover.api.CloverException;
import com.atlassian.clover.util.ReflectionUtils;
import com.atlassian.maven.plugin.clover.internal.lifecycle.MavenLifecycleAnalyzer;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.Lifecycle;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;

public class Maven2LifecycleAnalyzer
extends MavenLifecycleAnalyzer {
    public Maven2LifecycleAnalyzer(@NotNull LifecycleExecutor lifecycleExecutor, @NotNull MavenProject mavenProject, @NotNull MavenSession mavenSession) {
        super(lifecycleExecutor, mavenProject, mavenSession);
    }

    @Override
    public boolean isCompatibleVersion() {
        return this.isMaven2();
    }

    @Override
    public Set<String> getPhasesToBeExecuted() throws CloverException {
        try {
            return this.findPhasesToBeExecutedInMaven2();
        }
        catch (NoSuchMethodException ex) {
            throw new CloverException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new CloverException((Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            throw new CloverException((Throwable)ex);
        }
    }

    protected boolean isMaven2() {
        try {
            this.lifecycleExecutor.getClass().getMethod("getPhaseToLifecycleMap", new Class[0]);
            this.lifecycleExecutor.getClass().getDeclaredMethod("getLifecycleForPhase", String.class);
            this.lifecycleExecutor.getClass().getDeclaredMethod("constructLifecycleMappings", MavenSession.class, String.class, MavenProject.class, Lifecycle.class);
            this.lifecycleExecutor.getClass().getDeclaredMethod("processGoalChain", String.class, Map.class, Lifecycle.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    @NotNull
    protected Set<String> findPhasesToBeExecutedInMaven2() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        HashSet allPhasesForAllTasks = Sets.newHashSet();
        for (Object taskObj : this.mavenSession.getGoals()) {
            Set<Object> allPhasesForTask;
            String task = taskObj.toString();
            if (this.lifecycleExecutor_getPhaseToLifecycleMap(this.lifecycleExecutor).containsKey(task)) {
                Lifecycle lifecycle = this.lifecycleExecutor_getLifecycleForPhase(this.lifecycleExecutor, task);
                Map<String, List<MojoExecution>> lifecycleMappings = this.lifecycleExecutor_constructLifecycleMappings(this.lifecycleExecutor, this.mavenSession, task, this.mavenProject, lifecycle);
                allPhasesForTask = this.getPhasesFromProcessGoalChain(task, lifecycleMappings, lifecycle);
            } else {
                allPhasesForTask = Sets.newHashSet();
            }
            allPhasesForAllTasks.addAll(allPhasesForTask);
        }
        return allPhasesForAllTasks;
    }

    private Set<String> getPhasesFromProcessGoalChain(String task, Map<String, List<MojoExecution>> lifecycleMappings, Lifecycle lifecycle) {
        List<MojoExecution> mojoGoals = this.lifecycleExecutor_processGoalChain(this.lifecycleExecutor, task, lifecycleMappings, lifecycle);
        HashSet phases = Sets.newHashSet();
        if (mojoGoals != null) {
            for (MojoExecution mojoExecution : mojoGoals) {
                phases.addAll(this.getPhasesFromMojoExecution(mojoExecution));
            }
        }
        return phases;
    }

    private Map<String, Lifecycle> lifecycleExecutor_getPhaseToLifecycleMap(@NotNull LifecycleExecutor lifecycleExecutor) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Map)ReflectionUtils.invokeVirtualImplicit((String)"getPhaseToLifecycleMap", (Object)lifecycleExecutor);
    }

    private Map<String, List<MojoExecution>> lifecycleExecutor_constructLifecycleMappings(@NotNull LifecycleExecutor lifecycleExecutor, MavenSession mavenSession, String task, MavenProject mavenProject, Lifecycle lifecycle) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Map)ReflectionUtils.invokeVirtualImplicit((String)"constructLifecycleMappings", (Object)lifecycleExecutor, (Object[])new Object[]{mavenSession, task, mavenProject, lifecycle});
    }

    private Lifecycle lifecycleExecutor_getLifecycleForPhase(@NotNull LifecycleExecutor lifecycleExecutor, String task) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        return (Lifecycle)ReflectionUtils.invokeVirtualImplicit((String)"getLifecycleForPhase", (Object)lifecycleExecutor, (Object[])new Object[]{task});
    }

    private List<MojoExecution> lifecycleExecutor_processGoalChain(@NotNull LifecycleExecutor lifecycleExecutor, String task, Map<String, List<MojoExecution>> lifecycleMappings, Lifecycle lifecycle) {
        try {
            return (List)ReflectionUtils.invokeVirtualImplicit((String)"processGoalChain", (Object)lifecycleExecutor, (Object[])new Object[]{task, lifecycleMappings, lifecycle});
        }
        catch (Exception e) {
            return null;
        }
    }
}

