/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.log4j.maven;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.util.PluginRegistry;
import org.apache.logging.log4j.core.config.plugins.util.ResolverUtil;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.resolver.ArtifactResolutionRequest;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.repository.RepositorySystem;

@Mojo(name="generate-log4j-plugin-descriptor", defaultPhase=LifecyclePhase.VERIFY, threadSafe=true, aggregator=true)
public class Generate
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Inject
    private RepositorySystem system;
    @Parameter
    private String[] plugins;

    public void execute() {
        LinkedHashSet<String> locations = new LinkedHashSet<String>();
        locations.add(this.project.getBuild().getOutputDirectory());
        ArtifactHandler artifactHandler = this.project.getArtifact().getArtifactHandler();
        for (Object d : this.project.getDependencies()) {
            ArtifactResolutionRequest req = new ArtifactResolutionRequest();
            DefaultArtifact artifact = new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getScope(), d.getType(), d.getClassifier(), artifactHandler);
            req.setArtifact((Artifact)artifact);
            ArtifactResolutionResult result = this.system.resolve(req);
            if (result.hasExceptions()) continue;
            for (Artifact a : result.getArtifacts()) {
                locations.add(a.getFile().getAbsolutePath());
            }
        }
        ArrayList<URL> cp = new ArrayList<URL>();
        for (String loc : locations) {
            try {
                cp.add(new File(loc).toURI().toURL());
            }
            catch (MalformedURLException artifact) {}
        }
        LinkedHashSet classes = new LinkedHashSet();
        LinkedList<Plugin> foundAnnotations = new LinkedList<Plugin>();
        IdentityHashMap a2c = new IdentityHashMap();
        try {
            URLClassLoader cl = new URLClassLoader(cp.toArray(new URL[0]), Plugin.class.getClassLoader());
            Object object = null;
            try {
                for (Artifact plugin : this.plugins) {
                    try {
                        Class<?> pluginClass = cl.loadClass((String)plugin);
                        this.getLog().info((CharSequence)("Analyzing package " + pluginClass.getPackage().getName()));
                        this.collectPlugins(cl, pluginClass.getPackage(), foundAnnotations, a2c);
                    }
                    catch (ClassNotFoundException e) {
                        this.getLog().warn((CharSequence)("Can't load " + (String)plugin + ":" + e.getMessage()));
                    }
                }
            }
            catch (Throwable a) {
                object = a;
                throw a;
            }
            finally {
                if (cl != null) {
                    if (object != null) {
                        try {
                            cl.close();
                        }
                        catch (Throwable a) {
                            ((Throwable)object).addSuppressed(a);
                        }
                    } else {
                        cl.close();
                    }
                }
            }
        }
        catch (IOException cl) {
            // empty catch block
        }
        LinkedHashMap pluginMap = new LinkedHashMap();
        foundAnnotations.forEach(p -> pluginMap.computeIfAbsent(p.category(), k -> new ArrayList()).add(p));
        File log4jPluginDataJar = new File(this.project.getBuild().getOutputDirectory(), "META-INF/pax-logging-log4j-plugins/META-INF/org/apache/logging/log4j/core/config/plugins/Log4j2Plugins.dat");
        log4jPluginDataJar.getParentFile().mkdirs();
        try (DataOutputStream out = new DataOutputStream(new BufferedOutputStream(Files.newOutputStream(log4jPluginDataJar.toPath(), new OpenOption[0])));){
            out.writeInt(pluginMap.size());
            for (Map.Entry entry : pluginMap.entrySet()) {
                String category = (String)entry.getKey();
                List pluginsInCategory = (List)entry.getValue();
                out.writeUTF(category.toLowerCase(Locale.ROOT));
                out.writeInt(pluginsInCategory.size());
                for (Plugin plugin : pluginsInCategory) {
                    out.writeUTF(plugin.name().toLowerCase(Locale.ROOT));
                    out.writeUTF(((Class)a2c.get(plugin)).getName());
                    out.writeUTF("".equals(plugin.elementType()) ? plugin.name() : plugin.elementType());
                    out.writeBoolean(plugin.printObject());
                    out.writeBoolean(plugin.deferChildren());
                }
            }
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Can't write jar file with Pax Logging Lo4j2 annotation data", (Throwable)e);
        }
    }

    private void collectPlugins(ClassLoader loader, Package pkg, List<Plugin> foundAnnotations, Map<Plugin, Class<?>> a2c) {
        ResolverUtil resolver = new ResolverUtil();
        resolver.setClassLoader(loader);
        resolver.findInPackage((ResolverUtil.Test)new PluginRegistry.PluginTest(), pkg.getName());
        for (Class cls : resolver.getClasses()) {
            Plugin annotation = cls.getAnnotation(Plugin.class);
            if (annotation == null) continue;
            this.getLog().info((CharSequence)("   Found plugin " + cls.getName()));
            foundAnnotations.add(annotation);
            a2c.put(annotation, cls);
        }
    }
}

