/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.utils.IOUtils;
import org.owasp.dependencycheck.Engine;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.analyzer.exception.ArchiveExtractionException;
import org.owasp.dependencycheck.utils.ExtractionException;
import org.owasp.dependencycheck.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExtractionUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtractionUtil.class);

    private ExtractionUtil() {
    }

    public static void extractFiles(File archive, File extractTo) throws ExtractionException {
        ExtractionUtil.extractFiles(archive, extractTo, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractFiles(File archive, File extractTo, Engine engine) throws ExtractionException {
        if (archive == null || extractTo == null) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(archive);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ZipInputStream zis = new ZipInputStream(bis);
            Throwable throwable = null;
            block41: while (true) {
                try {
                    ZipEntry entry;
                    while ((entry = zis.getNextEntry()) != null) {
                        String msg;
                        if (entry.isDirectory()) {
                            File d = new File(extractTo, entry.getName());
                            if (d.exists() || d.mkdirs()) continue;
                            String msg2 = String.format("Unable to create '%s'.", d.getAbsolutePath());
                            throw new ExtractionException(msg2);
                        }
                        File file = new File(extractTo, entry.getName());
                        if (engine != null && !engine.accept(file)) continue;
                        try {
                            FileOutputStream fos = new FileOutputStream(file);
                            Throwable throwable2 = null;
                            try {
                                IOUtils.copy((InputStream)zis, (OutputStream)fos);
                                continue block41;
                            }
                            catch (Throwable throwable3) {
                                throwable2 = throwable3;
                                throw throwable3;
                            }
                            finally {
                                if (fos == null) continue block41;
                                if (throwable2 != null) {
                                    try {
                                        fos.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable2.addSuppressed(throwable4);
                                    }
                                    continue block41;
                                }
                                fos.close();
                                continue block41;
                            }
                        }
                        catch (FileNotFoundException ex) {
                            LOGGER.debug("", (Throwable)ex);
                            msg = String.format("Unable to find file '%s'.", file.getName());
                            throw new ExtractionException(msg, (Throwable)ex);
                        }
                        catch (IOException ex) {
                            LOGGER.debug("", (Throwable)ex);
                            msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                            throw new ExtractionException(msg, (Throwable)ex);
                            return;
                        }
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
            }
            finally {
                if (zis != null) {
                    if (throwable != null) {
                        try {
                            zis.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                    } else {
                        zis.close();
                    }
                }
            }
        }
        catch (IOException ex) {
            String msg = String.format("Exception reading archive '%s'.", archive.getName());
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException(msg, (Throwable)ex);
        }
    }

    public static void extractFilesUsingFilter(File archive, File destination, FilenameFilter filter) throws ExtractionException {
        if (archive == null || destination == null) {
            return;
        }
        try (FileInputStream fis = new FileInputStream(archive);){
            ExtractionUtil.extractArchive((ArchiveInputStream)new ZipArchiveInputStream((InputStream)new BufferedInputStream(fis)), destination, filter);
        }
        catch (FileNotFoundException ex) {
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Archive file was not found.", (Throwable)ex);
        }
        catch (IOException | ArchiveExtractionException ex) {
            LOGGER.warn("Exception extracting archive '{}'.", (Object)archive.getName());
            LOGGER.debug("", (Throwable)ex);
            throw new ExtractionException("Unable to extract from archive", (Throwable)ex);
        }
    }

    private static void extractArchive(ArchiveInputStream input, File destination, FilenameFilter filter) throws ArchiveExtractionException {
        try {
            ArchiveEntry entry;
            while ((entry = input.getNextEntry()) != null) {
                if (entry.isDirectory()) {
                    File dir = new File(destination, entry.getName());
                    if (dir.exists() || dir.mkdirs()) continue;
                    String msg = String.format("Unable to create directory '%s'.", dir.getAbsolutePath());
                    throw new AnalysisException(msg);
                }
                ExtractionUtil.extractFile(input, destination, filter, entry);
            }
        }
        catch (IOException | AnalysisException ex) {
            throw new ArchiveExtractionException(ex);
        }
        finally {
            FileUtils.close((Closeable)input);
        }
    }

    private static void extractFile(ArchiveInputStream input, File destination, FilenameFilter filter, ArchiveEntry entry) throws ExtractionException {
        File file = new File(destination, entry.getName());
        if (filter.accept(file.getParentFile(), file.getName())) {
            LOGGER.debug("Extracting '{}'", (Object)file.getPath());
            ExtractionUtil.createParentFile(file);
            try (FileOutputStream fos = new FileOutputStream(file);){
                IOUtils.copy((InputStream)input, (OutputStream)fos);
            }
            catch (FileNotFoundException ex) {
                LOGGER.debug("", (Throwable)ex);
                String msg = String.format("Unable to find file '%s'.", file.getName());
                throw new ExtractionException(msg, (Throwable)ex);
            }
            catch (IOException ex) {
                LOGGER.debug("", (Throwable)ex);
                String msg = String.format("IO Exception while parsing file '%s'.", file.getName());
                throw new ExtractionException(msg, (Throwable)ex);
            }
        }
    }

    private static void createParentFile(File file) throws ExtractionException {
        File parent = file.getParentFile();
        if (!parent.isDirectory() && !parent.mkdirs()) {
            String msg = String.format("Unable to build directory '%s'.", parent.getAbsolutePath());
            throw new ExtractionException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractGzip(File file) throws FileNotFoundException, IOException {
        String originalPath = file.getPath();
        File gzip = new File(originalPath + ".gz");
        if (gzip.isFile() && !gzip.delete()) {
            LOGGER.debug("Failed to delete initial temporary file when extracting 'gz' {}", (Object)gzip.toString());
            gzip.deleteOnExit();
        }
        if (!file.renameTo(gzip)) {
            throw new IOException("Unable to rename '" + file.getPath() + "'");
        }
        File newFile = new File(originalPath);
        try (GZIPInputStream cin = new GZIPInputStream(new FileInputStream(gzip));
             FileOutputStream out = new FileOutputStream(newFile);){
            IOUtils.copy((InputStream)cin, (OutputStream)out);
        }
        finally {
            if (gzip.isFile() && !org.apache.commons.io.FileUtils.deleteQuietly((File)gzip)) {
                LOGGER.debug("Failed to delete temporary file when extracting 'gz' {}", (Object)gzip.toString());
                gzip.deleteOnExit();
            }
        }
    }
}

