/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.api.mockito.repackaged;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.List;
import org.mockito.cglib.core.CodeGenerationException;
import org.mockito.cglib.core.NamingPolicy;
import org.mockito.cglib.core.Predicate;
import org.mockito.cglib.proxy.Callback;
import org.mockito.cglib.proxy.CallbackFilter;
import org.mockito.cglib.proxy.Enhancer;
import org.mockito.cglib.proxy.Factory;
import org.mockito.cglib.proxy.MethodInterceptor;
import org.mockito.cglib.proxy.NoOp;
import org.mockito.exceptions.base.MockitoException;
import org.mockito.internal.creation.instance.InstantationException;
import org.mockito.internal.creation.instance.Instantiator;
import org.mockito.internal.creation.util.SearchingClassLoader;
import org.mockito.internal.util.StringJoiner;
import org.powermock.api.mockito.repackaged.MockitoNamingPolicy;
import org.powermock.api.mockito.repackaged.SerializableNoOp;

public class ClassImposterizer {
    private final Instantiator instantiator;
    private static final NamingPolicy NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES = new MockitoNamingPolicy(){

        public String getClassName(String prefix, String source, Object key, Predicate names) {
            return "codegen." + super.getClassName(prefix, source, key, names);
        }
    };
    private static final CallbackFilter IGNORE_BRIDGE_METHODS = new CallbackFilter(){

        public int accept(Method method) {
            return method.isBridge() ? 1 : 0;
        }
    };

    public ClassImposterizer(Instantiator instantiator) {
        this.instantiator = instantiator;
    }

    public <T> T imposterise(MethodInterceptor interceptor, Class<T> mockedType, Collection<Class> ancillaryTypes) {
        return this.imposterise(interceptor, mockedType, ancillaryTypes.toArray(new Class[ancillaryTypes.size()]));
    }

    public <T> T imposterise(MethodInterceptor interceptor, Class<T> mockedType, Class<?> ... ancillaryTypes) {
        Class<Factory> proxyClass = null;
        Object proxyInstance = null;
        try {
            this.setConstructorsAccessible(mockedType, true);
            proxyClass = this.createProxyClass(mockedType, ancillaryTypes);
            proxyInstance = this.createProxy(proxyClass, interceptor);
            T t = mockedType.cast(proxyInstance);
            return t;
        }
        catch (ClassCastException cce) {
            throw new MockitoException(StringJoiner.join((Object[])new Object[]{"ClassCastException occurred while creating the mockito proxy :", "  class to mock : " + ClassImposterizer.describeClass(mockedType), "  created class : " + ClassImposterizer.describeClass(proxyClass), "  proxy instance class : " + ClassImposterizer.describeClass(proxyInstance), "  instance creation by : " + this.instantiator.getClass().getSimpleName(), "", "You might experience classloading issues, disabling the Objenesis cache *might* help (see MockitoConfiguration)"}), (Throwable)cce);
        }
        finally {
            this.setConstructorsAccessible(mockedType, false);
        }
    }

    private static String describeClass(Class type) {
        return type == null ? "null" : "'" + type.getCanonicalName() + "', loaded by classloader : '" + type.getClassLoader() + "'";
    }

    private static String describeClass(Object instance) {
        return instance == null ? "null" : ClassImposterizer.describeClass(instance.getClass());
    }

    public void setConstructorsAccessible(Class<?> mockedType, boolean accessible) {
        for (Constructor<?> constructor : mockedType.getDeclaredConstructors()) {
            constructor.setAccessible(accessible);
        }
    }

    public Class<Factory> createProxyClass(Class<?> mockedType, Class<?> ... interfaces) {
        if (mockedType == Object.class) {
            mockedType = ClassWithSuperclassToWorkAroundCglibBug.class;
        }
        Enhancer enhancer = new Enhancer(){

            protected void filterConstructors(Class sc, List constructors) {
            }
        };
        Class[] allMockedTypes = this.prepend(mockedType, interfaces);
        enhancer.setClassLoader(SearchingClassLoader.combineLoadersOf((Class[])allMockedTypes));
        enhancer.setUseFactory(true);
        if (mockedType.isInterface()) {
            enhancer.setSuperclass(Object.class);
            enhancer.setInterfaces(allMockedTypes);
        } else {
            enhancer.setSuperclass(mockedType);
            enhancer.setInterfaces((Class[])interfaces);
        }
        enhancer.setCallbackTypes(new Class[]{MethodInterceptor.class, NoOp.class});
        enhancer.setCallbackFilter(IGNORE_BRIDGE_METHODS);
        if (mockedType.getSigners() != null) {
            enhancer.setNamingPolicy(NAMING_POLICY_THAT_ALLOWS_IMPOSTERISATION_OF_CLASSES_IN_SIGNED_PACKAGES);
        } else {
            enhancer.setNamingPolicy((NamingPolicy)MockitoNamingPolicy.INSTANCE);
        }
        enhancer.setSerialVersionUID(Long.valueOf(42L));
        try {
            return enhancer.createClass();
        }
        catch (CodeGenerationException e) {
            if (Modifier.isPrivate(mockedType.getModifiers())) {
                throw new MockitoException("\nMockito cannot mock this class: " + mockedType + ".\n" + "Most likely it is a private class that is not visible by Mockito");
            }
            throw new MockitoException("\nMockito cannot mock this class: " + mockedType + "\n" + "Mockito can only mock visible & non-final classes." + "\n" + "If you're not sure why you're getting this error, please report to the mailing list.", (Throwable)e);
        }
    }

    private Object createProxy(Class<Factory> proxyClass, MethodInterceptor interceptor) {
        Factory proxy;
        try {
            proxy = (Factory)this.instantiator.newInstance(proxyClass);
        }
        catch (InstantationException e) {
            throw new MockitoException("Unable to create mock instance of type '" + proxyClass.getSuperclass().getSimpleName() + "'", (Throwable)e);
        }
        proxy.setCallbacks(new Callback[]{interceptor, SerializableNoOp.SERIALIZABLE_INSTANCE});
        return proxy;
    }

    private Class<?>[] prepend(Class<?> first, Class<?> ... rest) {
        Class[] all = new Class[rest.length + 1];
        all[0] = first;
        System.arraycopy(rest, 0, all, 1, rest.length);
        return all;
    }

    public static class ClassWithSuperclassToWorkAroundCglibBug {
    }
}

