/*
 * Decompiled with CFR 0.152.
 */
package org.powermock.reflect.internal;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import org.powermock.reflect.internal.comparator.ComparatorFactory;

class CandidateConstructorSearcher<T> {
    private final Class<T> classThatContainsTheConstructorToTest;
    private final Class<?>[] argumentTypes;

    public CandidateConstructorSearcher(Class<T> classThatContainsTheConstructorToTest, Class<?>[] argumentTypes) {
        this.classThatContainsTheConstructorToTest = classThatContainsTheConstructorToTest;
        this.argumentTypes = argumentTypes;
    }

    public Constructor<T> findConstructor() {
        Constructor<T>[] constructors = this.getConstructors();
        if (constructors.length == 0) {
            return null;
        }
        if (constructors.length == 1) {
            return constructors[0];
        }
        return this.findBestCandidate(constructors);
    }

    private Constructor<T> findBestCandidate(Constructor<T>[] constructors) {
        Arrays.sort(constructors, ComparatorFactory.createConstructorComparator());
        return constructors[0];
    }

    private Constructor<T>[] getConstructors() {
        try {
            Constructor<?>[] declaredConstructors = this.classThatContainsTheConstructorToTest.getDeclaredConstructors();
            ArrayList constructors = new ArrayList();
            for (Constructor<?> constructor : declaredConstructors) {
                if (!this.argumentsApplied(constructor)) continue;
                constructors.add(constructor);
            }
            return constructors.toArray(new Constructor[constructors.size()]);
        }
        catch (Exception e) {
            return new Constructor[0];
        }
    }

    private boolean argumentsApplied(Constructor<?> constructor) {
        Class<?>[] constructorArgumentTypes = constructor.getParameterTypes();
        if (constructorArgumentTypes.length != this.argumentTypes.length) {
            return false;
        }
        for (int index = 0; index < this.argumentTypes.length; ++index) {
            if (constructorArgumentTypes[index].isAssignableFrom(this.argumentTypes[index])) continue;
            return false;
        }
        return true;
    }
}

