/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBus;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableBlockWriter;
import io.questdb.mp.MCSequence;
import io.questdb.mp.MPSequence;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.tasks.ColumnIndexerTask;
import io.questdb.tasks.O3CallbackTask;
import io.questdb.tasks.O3CopyTask;
import io.questdb.tasks.O3OpenColumnTask;
import io.questdb.tasks.O3PartitionTask;
import io.questdb.tasks.O3PurgeDiscoveryTask;
import io.questdb.tasks.O3PurgeTask;
import io.questdb.tasks.VectorAggregateTask;
import org.jetbrains.annotations.NotNull;

public class MessageBusImpl
implements MessageBus {
    private final RingQueue<ColumnIndexerTask> indexerQueue;
    private final MPSequence indexerPubSeq;
    private final MCSequence indexerSubSeq;
    private final RingQueue<VectorAggregateTask> vectorAggregateQueue;
    private final MPSequence vectorAggregatePubSeq;
    private final MCSequence vectorAggregateSubSeq;
    private final RingQueue<TableBlockWriter.TableBlockWriterTaskHolder> tableBlockWriterQueue;
    private final MPSequence tableBlockWriterPubSeq;
    private final MCSequence tableBlockWriterSubSeq;
    private final RingQueue<O3CallbackTask> o3CallbackQueue;
    private final MPSequence o3CallbackPubSeq;
    private final MCSequence o3CallbackSubSeq;
    private final RingQueue<O3PurgeDiscoveryTask> o3PurgeDiscoveryQueue;
    private final MPSequence o3PurgeDiscoveryPubSeq;
    private final MCSequence o3PurgeDiscoverySubSeq;
    private final RingQueue<O3PurgeTask> o3PurgeQueue;
    private final MPSequence o3PurgePubSeq;
    private final MCSequence o3PurgeSubSeq;
    private final RingQueue<O3PartitionTask> o3PartitionQueue;
    private final MPSequence o3PartitionPubSeq;
    private final MCSequence o3PartitionSubSeq;
    private final RingQueue<O3OpenColumnTask> o3OpenColumnQueue;
    private final MPSequence o3OpenColumnPubSeq;
    private final MCSequence o3OpenColumnSubSeq;
    private final RingQueue<O3CopyTask> o3CopyQueue;
    private final MPSequence o3CopyPubSeq;
    private final MCSequence o3CopySubSeq;
    private final CairoConfiguration configuration;

    public MessageBusImpl(@NotNull CairoConfiguration configuration) {
        this.configuration = configuration;
        this.indexerQueue = new RingQueue<ColumnIndexerTask>(ColumnIndexerTask::new, configuration.getColumnIndexerQueueCapacity());
        this.indexerPubSeq = new MPSequence(this.indexerQueue.getCapacity());
        this.indexerSubSeq = new MCSequence(this.indexerQueue.getCapacity());
        this.indexerPubSeq.then(this.indexerSubSeq).then(this.indexerPubSeq);
        this.vectorAggregateQueue = new RingQueue<VectorAggregateTask>(VectorAggregateTask::new, configuration.getVectorAggregateQueueCapacity());
        this.vectorAggregatePubSeq = new MPSequence(this.vectorAggregateQueue.getCapacity());
        this.vectorAggregateSubSeq = new MCSequence(this.vectorAggregateQueue.getCapacity());
        this.vectorAggregatePubSeq.then(this.vectorAggregateSubSeq).then(this.vectorAggregatePubSeq);
        this.tableBlockWriterQueue = new RingQueue<TableBlockWriter.TableBlockWriterTaskHolder>(TableBlockWriter.TableBlockWriterTaskHolder::new, configuration.getTableBlockWriterQueueCapacity());
        this.tableBlockWriterPubSeq = new MPSequence(this.tableBlockWriterQueue.getCapacity());
        this.tableBlockWriterSubSeq = new MCSequence(this.tableBlockWriterQueue.getCapacity());
        this.tableBlockWriterPubSeq.then(this.tableBlockWriterSubSeq).then(this.tableBlockWriterPubSeq);
        this.o3CallbackQueue = new RingQueue<O3CallbackTask>(O3CallbackTask::new, configuration.getO3CallbackQueueCapacity());
        this.o3CallbackPubSeq = new MPSequence(this.o3CallbackQueue.getCapacity());
        this.o3CallbackSubSeq = new MCSequence(this.o3CallbackQueue.getCapacity());
        this.o3CallbackPubSeq.then(this.o3CallbackSubSeq).then(this.o3CallbackPubSeq);
        this.o3PartitionQueue = new RingQueue<O3PartitionTask>(O3PartitionTask::new, configuration.getO3PartitionQueueCapacity());
        this.o3PartitionPubSeq = new MPSequence(this.o3PartitionQueue.getCapacity());
        this.o3PartitionSubSeq = new MCSequence(this.o3PartitionQueue.getCapacity());
        this.o3PartitionPubSeq.then(this.o3PartitionSubSeq).then(this.o3PartitionPubSeq);
        this.o3OpenColumnQueue = new RingQueue<O3OpenColumnTask>(O3OpenColumnTask::new, configuration.getO3OpenColumnQueueCapacity());
        this.o3OpenColumnPubSeq = new MPSequence(this.o3OpenColumnQueue.getCapacity());
        this.o3OpenColumnSubSeq = new MCSequence(this.o3OpenColumnQueue.getCapacity());
        this.o3OpenColumnPubSeq.then(this.o3OpenColumnSubSeq).then(this.o3OpenColumnPubSeq);
        this.o3CopyQueue = new RingQueue<O3CopyTask>(O3CopyTask::new, configuration.getO3CopyQueueCapacity());
        this.o3CopyPubSeq = new MPSequence(this.o3CopyQueue.getCapacity());
        this.o3CopySubSeq = new MCSequence(this.o3CopyQueue.getCapacity());
        this.o3CopyPubSeq.then(this.o3CopySubSeq).then(this.o3CopyPubSeq);
        this.o3PurgeDiscoveryQueue = new RingQueue<O3PurgeDiscoveryTask>(O3PurgeDiscoveryTask::new, configuration.getO3PurgeDiscoveryQueueCapacity());
        this.o3PurgeDiscoveryPubSeq = new MPSequence(this.o3PurgeDiscoveryQueue.getCapacity());
        this.o3PurgeDiscoverySubSeq = new MCSequence(this.o3PurgeDiscoveryQueue.getCapacity());
        this.o3PurgeDiscoveryPubSeq.then(this.o3PurgeDiscoverySubSeq).then(this.o3PurgeDiscoveryPubSeq);
        this.o3PurgeQueue = new RingQueue<O3PurgeTask>(O3PurgeTask::new, configuration.getO3PurgeQueueCapacity());
        this.o3PurgePubSeq = new MPSequence(this.o3PurgeQueue.getCapacity());
        this.o3PurgeSubSeq = new MCSequence(this.o3PurgeQueue.getCapacity());
        this.o3PurgePubSeq.then(this.o3PurgeSubSeq).then(this.o3PurgePubSeq);
    }

    @Override
    public MPSequence getO3CallbackPubSeq() {
        return this.o3CallbackPubSeq;
    }

    @Override
    public RingQueue<O3CallbackTask> getO3CallbackQueue() {
        return this.o3CallbackQueue;
    }

    @Override
    public MCSequence getO3CallbackSubSeq() {
        return this.o3CallbackSubSeq;
    }

    @Override
    public CairoConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public Sequence getIndexerPubSequence() {
        return this.indexerPubSeq;
    }

    @Override
    public RingQueue<ColumnIndexerTask> getIndexerQueue() {
        return this.indexerQueue;
    }

    @Override
    public Sequence getIndexerSubSequence() {
        return this.indexerSubSeq;
    }

    @Override
    public RingQueue<VectorAggregateTask> getVectorAggregateQueue() {
        return this.vectorAggregateQueue;
    }

    @Override
    public Sequence getVectorAggregatePubSeq() {
        return this.vectorAggregatePubSeq;
    }

    @Override
    public Sequence getVectorAggregateSubSeq() {
        return this.vectorAggregateSubSeq;
    }

    @Override
    public RingQueue<TableBlockWriter.TableBlockWriterTaskHolder> getTableBlockWriterQueue() {
        return this.tableBlockWriterQueue;
    }

    @Override
    public Sequence getTableBlockWriterPubSeq() {
        return this.tableBlockWriterPubSeq;
    }

    @Override
    public Sequence getTableBlockWriterSubSeq() {
        return this.tableBlockWriterSubSeq;
    }

    @Override
    public MPSequence getO3PartitionPubSeq() {
        return this.o3PartitionPubSeq;
    }

    @Override
    public RingQueue<O3PartitionTask> getO3PartitionQueue() {
        return this.o3PartitionQueue;
    }

    @Override
    public MCSequence getO3PartitionSubSeq() {
        return this.o3PartitionSubSeq;
    }

    @Override
    public MPSequence getO3CopyPubSeq() {
        return this.o3CopyPubSeq;
    }

    @Override
    public RingQueue<O3CopyTask> getO3CopyQueue() {
        return this.o3CopyQueue;
    }

    @Override
    public MCSequence getO3CopySubSeq() {
        return this.o3CopySubSeq;
    }

    @Override
    public MPSequence getO3OpenColumnPubSeq() {
        return this.o3OpenColumnPubSeq;
    }

    @Override
    public RingQueue<O3OpenColumnTask> getO3OpenColumnQueue() {
        return this.o3OpenColumnQueue;
    }

    @Override
    public MCSequence getO3OpenColumnSubSeq() {
        return this.o3OpenColumnSubSeq;
    }

    @Override
    public RingQueue<O3PurgeDiscoveryTask> getO3PurgeDiscoveryQueue() {
        return this.o3PurgeDiscoveryQueue;
    }

    @Override
    public MPSequence getO3PurgeDiscoveryPubSeq() {
        return this.o3PurgeDiscoveryPubSeq;
    }

    @Override
    public MCSequence getO3PurgeDiscoverySubSeq() {
        return this.o3PurgeDiscoverySubSeq;
    }

    @Override
    public MPSequence getO3PurgePubSeq() {
        return this.o3PurgePubSeq;
    }

    @Override
    public RingQueue<O3PurgeTask> getO3PurgeQueue() {
        return this.o3PurgeQueue;
    }

    @Override
    public MCSequence getO3PurgeSubSeq() {
        return this.o3PurgeSubSeq;
    }
}

