/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.ServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.TelemetryConfiguration;
import io.questdb.WorkerPoolAwareConfiguration;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.CairoSecurityContext;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cutlass.http.HttpContextConfiguration;
import io.questdb.cutlass.http.HttpMinServerConfiguration;
import io.questdb.cutlass.http.HttpServerConfiguration;
import io.questdb.cutlass.http.MimeTypesCache;
import io.questdb.cutlass.http.WaitProcessorConfiguration;
import io.questdb.cutlass.http.processors.JsonQueryProcessorConfiguration;
import io.questdb.cutlass.http.processors.StaticContentProcessorConfiguration;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.json.JsonLexer;
import io.questdb.cutlass.line.LineProtoHourTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMicroTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMilliTimestampAdapter;
import io.questdb.cutlass.line.LineProtoMinuteTimestampAdapter;
import io.questdb.cutlass.line.LineProtoNanoTimestampAdapter;
import io.questdb.cutlass.line.LineProtoSecondTimestampAdapter;
import io.questdb.cutlass.line.LineProtoTimestampAdapter;
import io.questdb.cutlass.line.tcp.LineTcpReceiverConfiguration;
import io.questdb.cutlass.line.udp.LineUdpReceiverConfiguration;
import io.questdb.cutlass.pgwire.PGWireConfiguration;
import io.questdb.cutlass.text.TextConfiguration;
import io.questdb.cutlass.text.types.InputFormatConfiguration;
import io.questdb.griffin.SqlInterruptorConfiguration;
import io.questdb.log.Log;
import io.questdb.mp.WorkerPoolConfiguration;
import io.questdb.network.EpollFacade;
import io.questdb.network.EpollFacadeImpl;
import io.questdb.network.IODispatcherConfiguration;
import io.questdb.network.Net;
import io.questdb.network.NetworkError;
import io.questdb.network.NetworkFacade;
import io.questdb.network.NetworkFacadeImpl;
import io.questdb.network.SelectFacade;
import io.questdb.network.SelectFacadeImpl;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.NanosecondClock;
import io.questdb.std.NanosecondClockImpl;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Os;
import io.questdb.std.Rnd;
import io.questdb.std.StationaryMillisClock;
import io.questdb.std.Unsafe;
import io.questdb.std.datetime.DateFormat;
import io.questdb.std.datetime.DateLocale;
import io.questdb.std.datetime.DateLocaleFactory;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClockImpl;
import io.questdb.std.datetime.microtime.TimestampFormatCompiler;
import io.questdb.std.datetime.microtime.TimestampFormatFactory;
import io.questdb.std.datetime.millitime.DateFormatFactory;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.datetime.millitime.MillisecondClockImpl;
import io.questdb.std.str.Path;
import java.io.File;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class PropServerConfiguration
implements ServerConfiguration {
    public static final String CONFIG_DIRECTORY = "conf";
    private final IODispatcherConfiguration httpIODispatcherConfiguration = new PropHttpIODispatcherConfiguration();
    private final WaitProcessorConfiguration httpWaitProcessorConfiguration = new PropWaitProcessorConfiguration();
    private final StaticContentProcessorConfiguration staticContentProcessorConfiguration = new PropStaticContentProcessorConfiguration();
    private final HttpServerConfiguration httpServerConfiguration = new PropHttpServerConfiguration();
    private final TextConfiguration textConfiguration = new PropTextConfiguration();
    private final CairoConfiguration cairoConfiguration = new PropCairoConfiguration();
    private final LineUdpReceiverConfiguration lineUdpReceiverConfiguration = new PropLineUdpReceiverConfiguration();
    private final JsonQueryProcessorConfiguration jsonQueryProcessorConfiguration = new PropJsonQueryProcessorConfiguration();
    private final TelemetryConfiguration telemetryConfiguration = new PropTelemetryConfiguration();
    private final int commitMode;
    private final boolean httpServerEnabled;
    private final int createAsSelectRetryCount;
    private final CharSequence defaultMapType;
    private final boolean defaultSymbolCacheFlag;
    private final int defaultSymbolCapacity;
    private final int fileOperationRetryCount;
    private final long idleCheckInterval;
    private final long inactiveReaderTTL;
    private final long inactiveWriterTTL;
    private final int indexValueBlockSize;
    private final int maxSwapFileCount;
    private final int mkdirMode;
    private final int parallelIndexThreshold;
    private final int readerPoolMaxSegments;
    private final long spinLockTimeoutUs;
    private final int sqlCacheRows;
    private final int sqlCacheBlocks;
    private final int sqlCharacterStoreCapacity;
    private final int sqlCharacterStoreSequencePoolCapacity;
    private final int sqlColumnPoolCapacity;
    private final int sqlCopyModelPoolCapacity;
    private final double sqlCompactMapLoadFactor;
    private final int sqlExpressionPoolCapacity;
    private final double sqlFastMapLoadFactor;
    private final int sqlJoinContextPoolCapacity;
    private final int sqlLexerPoolCapacity;
    private final int sqlMapKeyCapacity;
    private final int sqlMapPageSize;
    private final int sqlMapMaxPages;
    private final int sqlMapMaxResizes;
    private final int sqlModelPoolCapacity;
    private final long sqlSortKeyPageSize;
    private final int sqlSortKeyMaxPages;
    private final long sqlSortLightValuePageSize;
    private final int sqlSortLightValueMaxPages;
    private final int sqlHashJoinValuePageSize;
    private final int sqlHashJoinValueMaxPages;
    private final long sqlLatestByRowCount;
    private final int sqlHashJoinLightValuePageSize;
    private final int sqlHashJoinLightValueMaxPages;
    private final int sqlSortValuePageSize;
    private final int sqlSortValueMaxPages;
    private final long workStealTimeoutNanos;
    private final boolean parallelIndexingEnabled;
    private final int sqlJoinMetadataPageSize;
    private final int sqlJoinMetadataMaxResizes;
    private final int lineUdpCommitRate;
    private final int lineUdpGroupIPv4Address;
    private final int lineUdpMsgBufferSize;
    private final int lineUdpMsgCount;
    private final int lineUdpReceiveBufferSize;
    private final int lineUdpCommitMode;
    private final int[] sharedWorkerAffinity;
    private final int sharedWorkerCount;
    private final boolean sharedWorkerHaltOnError;
    private final long sharedWorkerYieldThreshold;
    private final long sharedWorkerSleepThreshold;
    private final WorkerPoolConfiguration workerPoolConfiguration = new PropWorkerPoolConfiguration();
    private final PGWireConfiguration pgWireConfiguration = new PropPGWireConfiguration();
    private final InputFormatConfiguration inputFormatConfiguration;
    private final LineProtoTimestampAdapter lineUdpTimestampAdapter;
    private final String inputRoot;
    private final boolean lineUdpEnabled;
    private final int lineUdpOwnThreadAffinity;
    private final boolean lineUdpUnicast;
    private final boolean lineUdpOwnThread;
    private final int sqlCopyBufferSize;
    private final long sqlAppendPageSize;
    private final int sqlAnalyticColumnPoolCapacity;
    private final int sqlCreateTableModelPoolCapacity;
    private final int sqlColumnCastModelPoolCapacity;
    private final int sqlRenameTableModelPoolCapacity;
    private final int sqlWithClauseModelPoolCapacity;
    private final int sqlInsertModelPoolCapacity;
    private final int sqlGroupByPoolCapacity;
    private final int sqlGroupByMapCapacity;
    private final int sqlMaxSymbolNotEqualsCount;
    private final int sqlBindVariablePoolSize;
    private final DateLocale locale;
    private final String backupRoot;
    private final DateFormat backupDirTimestampFormat;
    private final CharSequence backupTempDirName;
    private final int backupMkdirMode;
    private final int sqlFloatToStrCastScale;
    private final int sqlDoubleToStrCastScale;
    private final PropPGWireDispatcherConfiguration propPGWireDispatcherConfiguration = new PropPGWireDispatcherConfiguration();
    private final boolean pgEnabled;
    private final boolean telemetryEnabled;
    private final int telemetryQueueCapacity;
    private final LineTcpReceiverConfiguration lineTcpReceiverConfiguration = new PropLineTcpReceiverConfiguration();
    private final IODispatcherConfiguration lineTcpReceiverDispatcherConfiguration = new PropLineTcpReceiverIODispatcherConfiguration();
    private final boolean lineTcpEnabled;
    private final WorkerPoolAwareConfiguration lineTcpWriterWorkerPoolConfiguration = new PropLineTcpWriterWorkerPoolConfiguration();
    private final WorkerPoolAwareConfiguration lineTcpIOWorkerPoolConfiguration = new PropLineTcpIOWorkerPoolConfiguration();
    private final Log log;
    private final PropHttpMinServerConfiguration httpMinServerConfiguration = new PropHttpMinServerConfiguration();
    private final PropHttpContextConfiguration httpContextConfiguration = new PropHttpContextConfiguration();
    private final boolean httpMinServerEnabled;
    private final PropHttpMinIODispatcherConfiguration httpMinIODispatcherConfiguration = new PropHttpMinIODispatcherConfiguration();
    private final PropSqlInterruptorConfiguration interruptorConfiguration = new PropSqlInterruptorConfiguration();
    private final int tableBlockWriterQueueCapacity;
    private final int sqlAnalyticStorePageSize;
    private final int sqlAnalyticStoreMaxPages;
    private final int sqlAnalyticRowIdPageSize;
    private final int sqlAnalyticRowIdMaxPages;
    private final int sqlAnalyticTreeKeyPageSize;
    private final int sqlAnalyticTreeKeyMaxPages;
    private final String databaseRoot;
    private final long maxRerunWaitCapMs;
    private final double rerunExponentialWaitMultiplier;
    private final int rerunInitialWaitQueueSize;
    private final int rerunMaxProcessingQueueSize;
    private final BuildInformation buildInformation;
    private final int columnIndexerQueueCapacity;
    private final int vectorAggregateQueueCapacity;
    private final int o3CallbackQueueCapacity;
    private final int o3PartitionQueueCapacity;
    private final int o3OpenColumnQueueCapacity;
    private final int o3CopyQueueCapacity;
    private final int o3UpdPartitionSizeQueueCapacity;
    private final int o3PurgeDiscoveryQueueCapacity;
    private final int o3PurgeQueueCapacity;
    private final int o3MaxUncommittedRows;
    private final long o3CommitHystersis;
    private final long instanceHashLo;
    private final long instanceHashHi;
    private final int sqlTxnScoreboardEntryCount;
    private final boolean o3QuickSortEnabled;
    private boolean httpAllowDeflateBeforeSend;
    private int[] httpWorkerAffinity;
    private int[] httpMinWorkerAffinity;
    private int connectionPoolInitialCapacity;
    private int connectionStringPoolCapacity;
    private int multipartHeaderBufferSize;
    private long multipartIdleSpinCount;
    private int recvBufferSize;
    private int requestHeaderBufferSize;
    private int httpWorkerCount;
    private boolean httpWorkerHaltOnError;
    private long httpWorkerYieldThreshold;
    private long httpWorkerSleepThreshold;
    private boolean httpServerKeepAlive;
    private int sendBufferSize;
    private CharSequence indexFileName;
    private String publicDirectory;
    private int httpActiveConnectionLimit;
    private int httpEventCapacity;
    private int httpIOQueueCapacity;
    private long httpIdleConnectionTimeout;
    private int httpInterestQueueCapacity;
    private int httpListenBacklog;
    private int httpSndBufSize;
    private int httpRcvBufSize;
    private int dateAdapterPoolCapacity;
    private int jsonCacheLimit;
    private int jsonCacheSize;
    private double maxRequiredDelimiterStdDev;
    private double maxRequiredLineLengthStdDev;
    private int metadataStringPoolCapacity;
    private int rollBufferLimit;
    private int rollBufferSize;
    private int textAnalysisMaxLines;
    private int textLexerStringPoolCapacity;
    private int timestampAdapterPoolCapacity;
    private int utf8SinkSize;
    private MimeTypesCache mimeTypesCache;
    private String keepAliveHeader;
    private int httpBindIPv4Address;
    private int httpBindPort;
    private int lineUdpBindIPV4Address;
    private int lineUdpPort;
    private int jsonQueryFloatScale;
    private int jsonQueryDoubleScale;
    private int jsonQueryConnectionCheckFrequency;
    private boolean httpFrozenClock;
    private boolean readOnlySecurityContext;
    private long maxHttpQueryResponseRowLimit;
    private boolean interruptOnClosedConnection;
    private int interruptorNIterationsPerCheck;
    private int interruptorBufferSize;
    private int pgNetActiveConnectionLimit;
    private int pgNetBindIPv4Address;
    private int pgNetBindPort;
    private int pgNetEventCapacity;
    private int pgNetIOQueueCapacity;
    private long pgNetIdleConnectionTimeout;
    private int pgNetInterestQueueCapacity;
    private int pgNetListenBacklog;
    private int pgNetRcvBufSize;
    private int pgNetSndBufSize;
    private int pgCharacterStoreCapacity;
    private int pgCharacterStorePoolCapacity;
    private int pgConnectionPoolInitialCapacity;
    private String pgPassword;
    private String pgUsername;
    private int pgFactoryCacheColumnCount;
    private int pgFactoryCacheRowCount;
    private int pgIdleRecvCountBeforeGivingUp;
    private int pgIdleSendCountBeforeGivingUp;
    private int pgMaxBlobSizeOnQuery;
    private int pgRecvBufferSize;
    private int pgSendBufferSize;
    private DateLocale pgDefaultLocale;
    private int[] pgWorkerAffinity;
    private int pgWorkerCount;
    private boolean pgHaltOnError;
    private long pgWorkerYieldThreshold;
    private long pgWorkerSleepThreshold;
    private boolean pgDaemonPool;
    private int pgInsertCacheBlockCount;
    private int pgInsertCacheRowCount;
    private int pgInsertPoolCapacity;
    private int pgNamedStatementCacheCapacity;
    private int pgNamesStatementPoolCapacity;
    private int pgPendingWritersCacheCapacity;
    private int lineTcpNetActiveConnectionLimit;
    private int lineTcpNetBindIPv4Address;
    private int lineTcpNetBindPort;
    private int lineTcpNetEventCapacity;
    private int lineTcpNetIOQueueCapacity;
    private long lineTcpNetIdleConnectionTimeout;
    private int lineTcpNetInterestQueueCapacity;
    private int lineTcpNetListenBacklog;
    private int lineTcpNetRcvBufSize;
    private int lineTcpConnectionPoolInitialCapacity;
    private LineProtoTimestampAdapter lineTcpTimestampAdapter;
    private int lineTcpMsgBufferSize;
    private int lineTcpMaxMeasurementSize;
    private int lineTcpWriterQueueCapacity;
    private int lineTcpWriterWorkerCount;
    private int[] lineTcpWriterWorkerAffinity;
    private boolean lineTcpWriterWorkerPoolHaltOnError;
    private long lineTcpWriterWorkerYieldThreshold;
    private long lineTcpWriterWorkerSleepThreshold;
    private int lineTcpIOWorkerCount;
    private int[] lineTcpIOWorkerAffinity;
    private boolean lineTcpIOWorkerPoolHaltOnError;
    private long lineTcpIOWorkerYieldThreshold;
    private long lineTcpIOWorkerSleepThreshold;
    private int lineTcpNUpdatesPerLoadRebalance;
    private double lineTcpMaxLoadRatio;
    private long lineTcpMaintenanceInterval;
    private String lineTcpAuthDbPath;
    private int lineDefaultPartitionBy;
    private boolean lineTcpAggressiveRecv;
    private long minIdleMsBeforeWriterRelease;
    private String httpVersion;
    private int httpMinWorkerCount;
    private boolean httpMinWorkerHaltOnError;
    private long httpMinWorkerYieldThreshold;
    private long httpMinWorkerSleepThreshold;
    private int httpMinBindIPv4Address;
    private int httpMinBindPort;
    private int httpMinEventCapacity;
    private int httpMinIOQueueCapacity;
    private long httpMinIdleConnectionTimeout;
    private int httpMinInterestQueueCapacity;
    private int httpMinListenBacklog;
    private int httpMinRcvBufSize;
    private int httpMinSndBufSize;

    public PropServerConfiguration(String root, Properties properties, @Nullable Map<String, String> env, Log log, BuildInformation buildInformation) throws ServerConfigurationException, JsonException {
        this.log = log;
        String databaseRoot = this.getString(properties, env, "cairo.root", "db");
        this.mkdirMode = this.getInt(properties, env, "cairo.mkdir.mode", 509);
        this.databaseRoot = new File(databaseRoot).isAbsolute() ? databaseRoot : new File(root, databaseRoot).getAbsolutePath();
        int cpuAvailable = Runtime.getRuntime().availableProcessors();
        int cpuUsed = 0;
        FilesFacade ff = this.cairoConfiguration.getFilesFacade();
        try (Path path = new Path();){
            long osPageSize;
            Rnd rnd;
            ff.mkdirs(path.of(this.databaseRoot).slash$(), this.mkdirMode);
            path.of(this.databaseRoot).concat("_tab_index.d").$();
            long tableIndexFd = TableUtils.openFileRWOrFail(ff, path);
            long fileSize = ff.length(tableIndexFd);
            if (fileSize < 8L && !ff.allocate(tableIndexFd, Files.PAGE_SIZE)) {
                ff.close(tableIndexFd);
                throw CairoException.instance(ff.errno()).put("Could not allocate [file=").put(path).put(", actual=").put(fileSize).put(", desired=").put(Files.PAGE_SIZE).put(']');
            }
            long tableIndexMem = TableUtils.mapRWOrClose(ff, path, tableIndexFd, Files.PAGE_SIZE);
            if (Os.compareAndSwap(tableIndexMem + 8L, 0L, (rnd = new Rnd(this.getCairoConfiguration().getMicrosecondClock().getTicks(), this.getCairoConfiguration().getMillisecondClock().getTicks())).nextLong()) == 0L) {
                Unsafe.getUnsafe().putLong(tableIndexMem + 16L, rnd.nextLong());
            }
            this.instanceHashLo = Unsafe.getUnsafe().getLong(tableIndexMem + 8L);
            this.instanceHashHi = Unsafe.getUnsafe().getLong(tableIndexMem + 16L);
            ff.munmap(tableIndexMem, Files.PAGE_SIZE);
            ff.close(tableIndexFd);
            this.httpMinServerEnabled = this.getBoolean(properties, env, "http.min.enabled", true);
            if (this.httpMinServerEnabled) {
                this.httpMinWorkerHaltOnError = this.getBoolean(properties, env, "http.min.worker.haltOnError", false);
                this.httpMinWorkerCount = this.getInt(properties, env, "http.min.worker.count", cpuAvailable > 16 ? 1 : 0);
                cpuUsed += this.httpMinWorkerCount;
                this.httpMinWorkerAffinity = this.getAffinity(properties, env, "http.min.worker.affinity", this.httpMinWorkerCount);
                this.httpMinWorkerYieldThreshold = this.getLong(properties, env, "http.min.worker.yield.threshold", 10L);
                this.httpMinWorkerSleepThreshold = this.getLong(properties, env, "http.min.worker.sleep.threshold", 10000L);
                this.parseBindTo(properties, env, "http.min.bind.to", "0.0.0.0:9003", (a, p) -> {
                    this.httpMinBindIPv4Address = a;
                    this.httpMinBindPort = p;
                });
                this.httpMinEventCapacity = this.getInt(properties, env, "http.min.net.event.capacity", 16);
                this.httpMinIOQueueCapacity = this.getInt(properties, env, "http.min.net.io.queue.capacity", 16);
                this.httpMinIdleConnectionTimeout = this.getLong(properties, env, "http.min.net.idle.connection.timeout", 300000L);
                this.httpMinInterestQueueCapacity = this.getInt(properties, env, "http.min.net.interest.queue.capacity", 16);
                this.httpMinListenBacklog = this.getInt(properties, env, "http.min.net.listen.backlog", 64);
                this.httpMinSndBufSize = this.getIntSize(properties, env, "http.min.net.snd.buf.size", 1024);
                this.httpMinRcvBufSize = this.getIntSize(properties, env, "http.net.rcv.buf.size", 1024);
            }
            this.httpServerEnabled = this.getBoolean(properties, env, "http.enabled", true);
            if (this.httpServerEnabled) {
                this.connectionPoolInitialCapacity = this.getInt(properties, env, "http.connection.pool.initial.capacity", 16);
                this.connectionStringPoolCapacity = this.getInt(properties, env, "http.connection.string.pool.capacity", 128);
                this.multipartHeaderBufferSize = this.getIntSize(properties, env, "http.multipart.header.buffer.size", 512);
                this.multipartIdleSpinCount = this.getLong(properties, env, "http.multipart.idle.spin.count", 10000L);
                this.recvBufferSize = this.getIntSize(properties, env, "http.receive.buffer.size", 0x100000);
                this.requestHeaderBufferSize = this.getIntSize(properties, env, "http.request.header.buffer.size", 64448);
                this.httpWorkerCount = this.getInt(properties, env, "http.worker.count", cpuAvailable > 16 ? 2 : 0);
                cpuUsed += this.httpWorkerCount;
                this.httpWorkerAffinity = this.getAffinity(properties, env, "http.worker.affinity", this.httpWorkerCount);
                this.httpWorkerHaltOnError = this.getBoolean(properties, env, "http.worker.haltOnError", false);
                this.httpWorkerYieldThreshold = this.getLong(properties, env, "http.worker.yield.threshold", 10L);
                this.httpWorkerSleepThreshold = this.getLong(properties, env, "http.worker.sleep.threshold", 10000L);
                this.sendBufferSize = this.getIntSize(properties, env, "http.send.buffer.size", 0x200000);
                this.indexFileName = this.getString(properties, env, "http.static.index.file.name", "index.html");
                this.httpFrozenClock = this.getBoolean(properties, env, "http.frozen.clock", false);
                this.httpAllowDeflateBeforeSend = this.getBoolean(properties, env, "http.allow.deflate.before.send", false);
                this.httpServerKeepAlive = this.getBoolean(properties, env, "http.server.keep.alive", true);
                this.httpVersion = this.getString(properties, env, "http.version", "HTTP/1.1");
                if (!this.httpVersion.endsWith(" ")) {
                    this.httpVersion = this.httpVersion + ' ';
                }
                int keepAliveTimeout = this.getInt(properties, env, "http.keep-alive.timeout", 5);
                int keepAliveMax = this.getInt(properties, env, "http.keep-alive.max", 10000);
                this.keepAliveHeader = keepAliveTimeout > 0 && keepAliveMax > 0 ? "Keep-Alive: timeout=" + keepAliveTimeout + ", max=" + keepAliveMax + "\r\n" : null;
                String publicDirectory = this.getString(properties, env, "http.static.public.directory", "public");
                this.publicDirectory = new File(publicDirectory).isAbsolute() ? publicDirectory : new File(root, publicDirectory).getAbsolutePath();
                this.httpActiveConnectionLimit = this.getInt(properties, env, "http.net.active.connection.limit", 256);
                this.httpEventCapacity = this.getInt(properties, env, "http.net.event.capacity", 1024);
                this.httpIOQueueCapacity = this.getInt(properties, env, "http.net.io.queue.capacity", 1024);
                this.httpIdleConnectionTimeout = this.getLong(properties, env, "http.net.idle.connection.timeout", 300000L);
                this.httpInterestQueueCapacity = this.getInt(properties, env, "http.net.interest.queue.capacity", 1024);
                this.httpListenBacklog = this.getInt(properties, env, "http.net.listen.backlog", 256);
                this.httpSndBufSize = this.getIntSize(properties, env, "http.net.snd.buf.size", 0x200000);
                this.httpRcvBufSize = this.getIntSize(properties, env, "http.net.rcv.buf.size", 0x200000);
                this.dateAdapterPoolCapacity = this.getInt(properties, env, "http.text.date.adapter.pool.capacity", 16);
                this.jsonCacheLimit = this.getIntSize(properties, env, "http.text.json.cache.limit", 16384);
                this.jsonCacheSize = this.getIntSize(properties, env, "http.text.json.cache.size", 8192);
                this.maxRequiredDelimiterStdDev = this.getDouble(properties, env, "http.text.max.required.delimiter.stddev", 0.1222);
                this.maxRequiredLineLengthStdDev = this.getDouble(properties, env, "http.text.max.required.line.length.stddev", 0.8);
                this.metadataStringPoolCapacity = this.getInt(properties, env, "http.text.metadata.string.pool.capacity", 128);
                this.rollBufferLimit = this.getIntSize(properties, env, "http.text.roll.buffer.limit", 0x400000);
                this.rollBufferSize = this.getIntSize(properties, env, "http.text.roll.buffer.size", 1024);
                this.textAnalysisMaxLines = this.getInt(properties, env, "http.text.analysis.max.lines", 1000);
                this.textLexerStringPoolCapacity = this.getInt(properties, env, "http.text.lexer.string.pool.capacity", 64);
                this.timestampAdapterPoolCapacity = this.getInt(properties, env, "http.text.timestamp.adapter.pool.capacity", 64);
                this.utf8SinkSize = this.getIntSize(properties, env, "http.text.utf8.sink.size", 4096);
                this.jsonQueryConnectionCheckFrequency = this.getInt(properties, env, "http.json.query.connection.check.frequency", 1000000);
                this.jsonQueryFloatScale = this.getInt(properties, env, "http.json.query.float.scale", 4);
                this.jsonQueryDoubleScale = this.getInt(properties, env, "http.json.query.double.scale", 12);
                this.readOnlySecurityContext = this.getBoolean(properties, env, "http.security.readonly", false);
                this.maxHttpQueryResponseRowLimit = this.getLong(properties, env, "http.security.max.response.rows", Long.MAX_VALUE);
                this.interruptOnClosedConnection = this.getBoolean(properties, env, "http.security.interrupt.on.closed.connection", true);
                this.interruptorNIterationsPerCheck = this.getInt(properties, env, "http.security.interruptor.iterations.per.check", 2000000);
                this.interruptorBufferSize = this.getInt(properties, env, "http.security.interruptor.buffer.size", 64);
                this.parseBindTo(properties, env, "http.bind.to", "0.0.0.0:9000", (a, p) -> {
                    this.httpBindIPv4Address = a;
                    this.httpBindPort = p;
                });
                path.of(new File(new File(root, CONFIG_DIRECTORY), "mime.types").getAbsolutePath()).$();
                this.mimeTypesCache = new MimeTypesCache(FilesFacadeImpl.INSTANCE, path);
            }
            this.maxRerunWaitCapMs = this.getLong(properties, env, "http.busy.retry.maximum.wait.before.retry", 1000L);
            this.rerunExponentialWaitMultiplier = this.getDouble(properties, env, "http.busy.retry.exponential.wait.multipier", 2.0);
            this.rerunInitialWaitQueueSize = this.getIntSize(properties, env, "http.busy.retry.initialWaitQueueSize", 64);
            this.rerunMaxProcessingQueueSize = this.getIntSize(properties, env, "http.busy.retry.maxProcessingQueueSize", 4096);
            this.pgEnabled = this.getBoolean(properties, env, "pg.enabled", true);
            if (this.pgEnabled) {
                this.pgNetActiveConnectionLimit = this.getInt(properties, env, "pg.net.active.connection.limit", 10);
                this.parseBindTo(properties, env, "pg.net.bind.to", "0.0.0.0:8812", (a, p) -> {
                    this.pgNetBindIPv4Address = a;
                    this.pgNetBindPort = p;
                });
                this.pgNetEventCapacity = this.getInt(properties, env, "pg.net.event.capacity", 1024);
                this.pgNetIOQueueCapacity = this.getInt(properties, env, "pg.net.io.queue.capacity", 1024);
                this.pgNetIdleConnectionTimeout = this.getLong(properties, env, "pg.net.idle.timeout", 300000L);
                this.pgNetInterestQueueCapacity = this.getInt(properties, env, "pg.net.interest.queue.capacity", 1024);
                this.pgNetListenBacklog = this.getInt(properties, env, "pg.net.listen.backlog", 50000);
                this.pgNetRcvBufSize = this.getIntSize(properties, env, "pg.net.recv.buf.size", -1);
                this.pgNetSndBufSize = this.getIntSize(properties, env, "pg.net.send.buf.size", -1);
                this.pgCharacterStoreCapacity = this.getInt(properties, env, "pg.character.store.capacity", 4096);
                this.pgCharacterStorePoolCapacity = this.getInt(properties, env, "pg.character.store.pool.capacity", 64);
                this.pgConnectionPoolInitialCapacity = this.getInt(properties, env, "pg.connection.pool.capacity", 64);
                this.pgPassword = this.getString(properties, env, "pg.password", "quest");
                this.pgUsername = this.getString(properties, env, "pg.user", "admin");
                this.pgFactoryCacheColumnCount = this.getInt(properties, env, "pg.factory.cache.column.count", 16);
                this.pgFactoryCacheRowCount = this.getInt(properties, env, "pg.factory.cache.row.count", 16);
                this.pgIdleRecvCountBeforeGivingUp = this.getInt(properties, env, "pg.idle.recv.count.before.giving.up", 10000);
                this.pgIdleSendCountBeforeGivingUp = this.getInt(properties, env, "pg.idle.send.count.before.giving.up", 10000);
                this.pgMaxBlobSizeOnQuery = this.getIntSize(properties, env, "pg.max.blob.size.on.query", 524288);
                this.pgRecvBufferSize = this.getIntSize(properties, env, "pg.recv.buffer.size", 0x100000);
                this.pgSendBufferSize = this.getIntSize(properties, env, "pg.send.buffer.size", 0x100000);
                String dateLocale = this.getString(properties, env, "pg.date.locale", "en");
                this.pgDefaultLocale = DateLocaleFactory.INSTANCE.getLocale(dateLocale);
                if (this.pgDefaultLocale == null) {
                    throw new ServerConfigurationException("pg.date.locale", dateLocale);
                }
                this.pgWorkerCount = this.getInt(properties, env, "pg.worker.count", cpuAvailable > 16 ? 2 : 0);
                cpuUsed += this.pgWorkerCount;
                this.pgWorkerAffinity = this.getAffinity(properties, env, "pg.worker.affinity", this.pgWorkerCount);
                this.pgHaltOnError = this.getBoolean(properties, env, "pg.halt.on.error", false);
                this.pgWorkerYieldThreshold = this.getLong(properties, env, "pg.worker.yield.threshold", 10L);
                this.pgWorkerSleepThreshold = this.getLong(properties, env, "pg.worker.sleep.threshold", 10000L);
                this.pgDaemonPool = this.getBoolean(properties, env, "pg.daemon.pool", true);
                this.pgInsertCacheBlockCount = this.getInt(properties, env, "pg.insert.cache.block.count", 8);
                this.pgInsertCacheRowCount = this.getInt(properties, env, "pg.insert.cache.row.count", 8);
                this.pgInsertPoolCapacity = this.getInt(properties, env, "pg.insert.pool.capacity", 64);
                this.pgNamedStatementCacheCapacity = this.getInt(properties, env, "pg.named.statement.cache.capacity", 32);
                this.pgNamesStatementPoolCapacity = this.getInt(properties, env, "pg.named.statement.pool.capacity", 32);
                this.pgPendingWritersCacheCapacity = this.getInt(properties, env, "pg.pending.writers.cache.capacity", 16);
            }
            this.commitMode = this.getCommitMode(properties, env, "cairo.commit.mode");
            this.createAsSelectRetryCount = this.getInt(properties, env, "cairo.create.as.select.retry.count", 5);
            this.defaultMapType = this.getString(properties, env, "cairo.default.map.type", "fast");
            this.defaultSymbolCacheFlag = this.getBoolean(properties, env, "cairo.default.symbol.cache.flag", true);
            this.defaultSymbolCapacity = this.getInt(properties, env, "cairo.default.symbol.capacity", 256);
            this.fileOperationRetryCount = this.getInt(properties, env, "cairo.file.operation.retry.count", 30);
            this.idleCheckInterval = this.getLong(properties, env, "cairo.idle.check.interval", 300000L);
            this.inactiveReaderTTL = this.getLong(properties, env, "cairo.inactive.reader.ttl", 120000L);
            this.inactiveWriterTTL = this.getLong(properties, env, "cairo.inactive.writer.ttl", 600000L);
            this.indexValueBlockSize = Numbers.ceilPow2(this.getIntSize(properties, env, "cairo.index.value.block.size", 256));
            this.maxSwapFileCount = this.getInt(properties, env, "cairo.max.swap.file.count", 30);
            this.parallelIndexThreshold = this.getInt(properties, env, "cairo.parallel.index.threshold", 100000);
            this.readerPoolMaxSegments = this.getInt(properties, env, "cairo.reader.pool.max.segments", 5);
            this.spinLockTimeoutUs = this.getLong(properties, env, "cairo.spin.lock.timeout", 1000000L);
            this.sqlCacheRows = this.getInt(properties, env, "cairo.cache.rows", 16);
            this.sqlCacheBlocks = this.getIntSize(properties, env, "cairo.cache.blocks", 4);
            this.sqlCharacterStoreCapacity = this.getInt(properties, env, "cairo.character.store.capacity", 1024);
            this.sqlCharacterStoreSequencePoolCapacity = this.getInt(properties, env, "cairo.character.store.sequence.pool.capacity", 64);
            this.sqlColumnPoolCapacity = this.getInt(properties, env, "cairo.column.pool.capacity", 4096);
            this.sqlCompactMapLoadFactor = this.getDouble(properties, env, "cairo.compact.map.load.factor", 0.7);
            this.sqlExpressionPoolCapacity = this.getInt(properties, env, "cairo.expression.pool.capacity", 8192);
            this.sqlFastMapLoadFactor = this.getDouble(properties, env, "cairo.fast.map.load.factor", 0.5);
            this.sqlJoinContextPoolCapacity = this.getInt(properties, env, "cairo.sql.join.context.pool.capacity", 64);
            this.sqlLexerPoolCapacity = this.getInt(properties, env, "cairo.lexer.pool.capacity", 2048);
            this.sqlMapKeyCapacity = this.getInt(properties, env, "cairo.sql.map.key.capacity", 0x200000);
            this.sqlMapPageSize = this.getIntSize(properties, env, "cairo.sql.map.page.size", 0x400000);
            this.sqlMapMaxPages = this.getIntSize(properties, env, "cairo.sql.map.max.pages", Integer.MAX_VALUE);
            this.sqlMapMaxResizes = this.getIntSize(properties, env, "cairo.sql.map.max.resizes", Integer.MAX_VALUE);
            this.sqlModelPoolCapacity = this.getInt(properties, env, "cairo.model.pool.capacity", 1024);
            this.sqlSortKeyPageSize = this.getLongSize(properties, env, "cairo.sql.sort.key.page.size", 0x400000L);
            this.sqlSortKeyMaxPages = this.getIntSize(properties, env, "cairo.sql.sort.key.max.pages", Integer.MAX_VALUE);
            this.sqlSortLightValuePageSize = this.getLongSize(properties, env, "cairo.sql.sort.light.value.page.size", 0x800000L);
            this.sqlSortLightValueMaxPages = this.getIntSize(properties, env, "cairo.sql.sort.light.value.max.pages", Integer.MAX_VALUE);
            this.sqlHashJoinValuePageSize = this.getIntSize(properties, env, "cairo.sql.hash.join.value.page.size", 0x1000000);
            this.sqlHashJoinValueMaxPages = this.getIntSize(properties, env, "cairo.sql.hash.join.value.max.pages", Integer.MAX_VALUE);
            this.sqlLatestByRowCount = this.getInt(properties, env, "cairo.sql.latest.by.row.count", 1000);
            this.sqlHashJoinLightValuePageSize = this.getIntSize(properties, env, "cairo.sql.hash.join.light.value.page.size", 0x100000);
            this.sqlHashJoinLightValueMaxPages = this.getIntSize(properties, env, "cairo.sql.hash.join.light.value.max.pages", Integer.MAX_VALUE);
            this.sqlSortValuePageSize = this.getIntSize(properties, env, "cairo.sql.sort.value.page.size", 0x1000000);
            this.sqlSortValueMaxPages = this.getIntSize(properties, env, "cairo.sql.sort.value.max.pages", Integer.MAX_VALUE);
            this.workStealTimeoutNanos = this.getLong(properties, env, "cairo.work.steal.timeout.nanos", 10000L);
            this.parallelIndexingEnabled = this.getBoolean(properties, env, "cairo.parallel.indexing.enabled", true);
            this.sqlJoinMetadataPageSize = this.getIntSize(properties, env, "cairo.sql.join.metadata.page.size", 16384);
            this.sqlJoinMetadataMaxResizes = this.getIntSize(properties, env, "cairo.sql.join.metadata.max.resizes", Integer.MAX_VALUE);
            this.sqlAnalyticColumnPoolCapacity = this.getInt(properties, env, "cairo.sql.analytic.column.pool.capacity", 64);
            this.sqlCreateTableModelPoolCapacity = this.getInt(properties, env, "cairo.sql.create.table.model.pool.capacity", 16);
            this.sqlColumnCastModelPoolCapacity = this.getInt(properties, env, "cairo.sql.column.cast.model.pool.capacity", 16);
            this.sqlRenameTableModelPoolCapacity = this.getInt(properties, env, "cairo.sql.rename.table.model.pool.capacity", 16);
            this.sqlWithClauseModelPoolCapacity = this.getInt(properties, env, "cairo.sql.with.clause.model.pool.capacity", 128);
            this.sqlInsertModelPoolCapacity = this.getInt(properties, env, "cairo.sql.insert.model.pool.capacity", 64);
            this.sqlCopyModelPoolCapacity = this.getInt(properties, env, "cairo.sql.copy.model.pool.capacity", 32);
            this.sqlCopyBufferSize = this.getIntSize(properties, env, "cairo.sql.copy.buffer.size", 0x200000);
            long sqlAppendPageSize = this.getLongSize(properties, env, "cairo.sql.append.page.size", 0x1000000L);
            this.sqlAppendPageSize = sqlAppendPageSize % (osPageSize = FilesFacadeImpl.INSTANCE.getPageSize()) == 0L ? sqlAppendPageSize : (sqlAppendPageSize / osPageSize + 1L) * osPageSize;
            this.sqlDoubleToStrCastScale = this.getInt(properties, env, "cairo.sql.double.cast.scale", 12);
            this.sqlFloatToStrCastScale = this.getInt(properties, env, "cairo.sql.float.cast.scale", 4);
            this.sqlGroupByMapCapacity = this.getInt(properties, env, "cairo.sql.groupby.map.capacity", 1024);
            this.sqlGroupByPoolCapacity = this.getInt(properties, env, "cairo.sql.groupby.pool.capacity", 1024);
            this.sqlMaxSymbolNotEqualsCount = this.getInt(properties, env, "cairo.sql.max.symbol.not.equals.count", 100);
            this.sqlBindVariablePoolSize = this.getInt(properties, env, "cairo.sql.bind.variable.pool.size", 8);
            String sqlCopyFormatsFile = this.getString(properties, env, "cairo.sql.copy.formats.file", "/text_loader.json");
            String dateLocale = this.getString(properties, env, "cairo.date.locale", "en");
            this.locale = DateLocaleFactory.INSTANCE.getLocale(dateLocale);
            if (this.locale == null) {
                throw new ServerConfigurationException("cairo.date.locale", dateLocale);
            }
            this.inputFormatConfiguration = new InputFormatConfiguration(new DateFormatFactory(), DateLocaleFactory.INSTANCE, new TimestampFormatFactory(), this.locale);
            try (JsonLexer lexer = new JsonLexer(1024, 1024);){
                this.inputFormatConfiguration.parseConfiguration(lexer, sqlCopyFormatsFile);
            }
            this.inputRoot = this.getString(properties, env, "cairo.sql.copy.root", null);
            this.backupRoot = this.getString(properties, env, "cairo.sql.backup.root", null);
            this.backupDirTimestampFormat = this.getTimestampFormat(properties, env);
            this.backupTempDirName = this.getString(properties, env, "cairo.sql.backup.dir.tmp.name", "tmp");
            this.backupMkdirMode = this.getInt(properties, env, "cairo.sql.backup.mkdir.mode", 509);
            this.tableBlockWriterQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.table.block.writer.queue.capacity", 256));
            this.columnIndexerQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.column.indexer.queue.capacity", 64));
            this.vectorAggregateQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.vector.aggregate.queue.capacity", 128));
            this.o3CallbackQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.callback.queue.capacity", 128));
            this.o3PartitionQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.partition.queue.capacity", 128));
            this.o3OpenColumnQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.open.column.queue.capacity", 128));
            this.o3CopyQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.copy.queue.capacity", 128));
            this.o3UpdPartitionSizeQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.upd.partition.size.queue.capacity", 128));
            this.o3PurgeDiscoveryQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.purge.discovery.queue.capacity", 128));
            this.o3PurgeQueueCapacity = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.purge.queue.capacity", 128));
            this.o3MaxUncommittedRows = this.getInt(properties, env, "cairo.o3.max.uncommitted.rows", 500000);
            this.o3CommitHystersis = this.getLong(properties, env, "cairo.o3.commit.hysteresis.in.ms", 300000L) * 1000L;
            this.o3QuickSortEnabled = this.getBoolean(properties, env, "cairo.o3.quicksort.enabled", false);
            this.sqlAnalyticStorePageSize = Numbers.ceilPow2(this.getIntSize(properties, env, "cairo.sql.analytic.store.page.size", 0x100000));
            this.sqlAnalyticStoreMaxPages = Numbers.ceilPow2(this.getIntSize(properties, env, "cairo.sql.analytic.store.max.pages", Integer.MAX_VALUE));
            this.sqlAnalyticRowIdPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, "cairo.sql.analytic.rowid.page.size", 524288));
            this.sqlAnalyticRowIdMaxPages = Numbers.ceilPow2(this.getInt(properties, env, "cairo.sql.analytic.rowid.max.pages", Integer.MAX_VALUE));
            this.sqlAnalyticTreeKeyPageSize = Numbers.ceilPow2(this.getIntSize(properties, env, "cairo.sql.analytic.tree.page.size", 524288));
            this.sqlAnalyticTreeKeyMaxPages = Numbers.ceilPow2(this.getInt(properties, env, "cairo.sql.analytic.tree.max.pages", Integer.MAX_VALUE));
            this.sqlTxnScoreboardEntryCount = Numbers.ceilPow2(this.getInt(properties, env, "cairo.o3.txn.scoreboard.entry.count", 16384));
            this.telemetryEnabled = this.getBoolean(properties, env, "telemetry.enabled", true);
            this.telemetryQueueCapacity = this.getInt(properties, env, "telemetry.queue.capacity", 512);
            this.parseBindTo(properties, env, "line.udp.bind.to", "0.0.0.0:9009", (a, p) -> {
                this.lineUdpBindIPV4Address = a;
                this.lineUdpPort = p;
            });
            this.lineUdpGroupIPv4Address = this.getIPv4Address(properties, env, "line.udp.join", "232.1.2.3");
            this.lineUdpCommitRate = this.getInt(properties, env, "line.udp.commit.rate", 1000000);
            this.lineUdpMsgBufferSize = this.getIntSize(properties, env, "line.udp.msg.buffer.size", 2048);
            this.lineUdpMsgCount = this.getInt(properties, env, "line.udp.msg.count", 10000);
            this.lineUdpReceiveBufferSize = this.getIntSize(properties, env, "line.udp.receive.buffer.size", 0x800000);
            this.lineUdpEnabled = this.getBoolean(properties, env, "line.udp.enabled", true);
            this.lineUdpOwnThreadAffinity = this.getInt(properties, env, "line.udp.own.thread.affinity", -1);
            this.lineUdpOwnThread = this.getBoolean(properties, env, "line.udp.own.thread", false);
            this.lineUdpUnicast = this.getBoolean(properties, env, "line.udp.unicast", false);
            this.lineUdpCommitMode = this.getCommitMode(properties, env, "line.udp.commit.mode");
            this.lineUdpTimestampAdapter = this.getLineTimestampAdaptor(properties, env, "line.udp.timestamp");
            this.lineTcpEnabled = this.getBoolean(properties, env, "line.tcp.enabled", true);
            if (this.lineTcpEnabled) {
                this.lineTcpNetActiveConnectionLimit = this.getInt(properties, env, "line.tcp.net.active.connection.limit", 10);
                this.parseBindTo(properties, env, "line.tcp.net.bind.to", "0.0.0.0:9009", (a, p) -> {
                    this.lineTcpNetBindIPv4Address = a;
                    this.lineTcpNetBindPort = p;
                });
                this.lineTcpNetEventCapacity = this.getInt(properties, env, "line.tcp.net.event.capacity", 1024);
                this.lineTcpNetIOQueueCapacity = this.getInt(properties, env, "line.tcp.net.io.queue.capacity", 256);
                this.lineTcpNetIdleConnectionTimeout = this.getLong(properties, env, "line.tcp.net.idle.timeout", 0L);
                this.lineTcpNetInterestQueueCapacity = this.getInt(properties, env, "line.tcp.net.interest.queue.capacity", 1024);
                this.lineTcpNetListenBacklog = this.getInt(properties, env, "line.tcp.net.listen.backlog", 50000);
                this.lineTcpNetRcvBufSize = this.getIntSize(properties, env, "line.tcp.net.recv.buf.size", -1);
                this.lineTcpConnectionPoolInitialCapacity = this.getInt(properties, env, "line.tcp.connection.pool.capacity", 64);
                this.lineTcpTimestampAdapter = this.getLineTimestampAdaptor(properties, env, "line.tcp.timestamp");
                this.lineTcpMsgBufferSize = this.getIntSize(properties, env, "line.tcp.msg.buffer.size", 32768);
                this.lineTcpMaxMeasurementSize = this.getIntSize(properties, env, "line.tcp.max.measurement.size", 4096);
                if (this.lineTcpMaxMeasurementSize > this.lineTcpMsgBufferSize) {
                    throw new IllegalArgumentException("line.tcp.max.measurement.size (" + this.lineTcpMaxMeasurementSize + ") cannot be more than line.tcp.msg.buffer.size (" + this.lineTcpMsgBufferSize + ")");
                }
                this.lineTcpWriterQueueCapacity = this.getInt(properties, env, "line.tcp.writer.queue.capacity", 128);
                this.lineTcpWriterWorkerCount = this.getInt(properties, env, "line.tcp.writer.worker.count", 1);
                cpuUsed += this.lineTcpWriterWorkerCount;
                this.lineTcpWriterWorkerAffinity = this.getAffinity(properties, env, "line.tcp.writer.worker.affinity", this.lineTcpWriterWorkerCount);
                this.lineTcpWriterWorkerPoolHaltOnError = this.getBoolean(properties, env, "line.tcp.writer.halt.on.error", false);
                this.lineTcpWriterWorkerYieldThreshold = this.getLong(properties, env, "line.tcp.writer.worker.yield.threshold", 10L);
                this.lineTcpWriterWorkerSleepThreshold = this.getLong(properties, env, "line.tcp.writer.worker.sleep.threshold", 10000L);
                int ilpTcpWorkerCount = cpuAvailable < 9 ? 0 : (cpuAvailable < 17 ? 2 : 6);
                this.lineTcpIOWorkerCount = this.getInt(properties, env, "line.tcp.io.worker.count", ilpTcpWorkerCount);
                cpuUsed += this.lineTcpIOWorkerCount;
                this.lineTcpIOWorkerAffinity = this.getAffinity(properties, env, "line.tcp.io.worker.affinity", this.lineTcpIOWorkerCount);
                this.lineTcpIOWorkerPoolHaltOnError = this.getBoolean(properties, env, "line.tcp.io.halt.on.error", false);
                this.lineTcpIOWorkerYieldThreshold = this.getLong(properties, env, "line.tcp.io.worker.yield.threshold", 10L);
                this.lineTcpIOWorkerSleepThreshold = this.getLong(properties, env, "line.tcp.io.worker.sleep.threshold", 10000L);
                this.lineTcpNUpdatesPerLoadRebalance = this.getInt(properties, env, "line.tcp.n.updates.per.load.balance", 10000000);
                this.lineTcpMaxLoadRatio = this.getDouble(properties, env, "line.tcp.max.load.ratio", 1.9);
                this.lineTcpMaintenanceInterval = this.getInt(properties, env, "line.tcp.maintenance.job.hysteresis.in.ms", 30000);
                this.lineTcpAuthDbPath = this.getString(properties, env, "line.tcp.auth.db.path", null);
                String defaultPartitionByProperty = this.getString(properties, env, "line.tcp.default.partition.by", "DAY");
                this.lineDefaultPartitionBy = PartitionBy.fromString(defaultPartitionByProperty);
                if (this.lineDefaultPartitionBy == -1) {
                    log.info().$("invalid partition by ").$(defaultPartitionByProperty).$("), will use DAY").$();
                    this.lineDefaultPartitionBy = 0;
                }
                if (null != this.lineTcpAuthDbPath) {
                    this.lineTcpAuthDbPath = new File(root, this.lineTcpAuthDbPath).getAbsolutePath();
                }
                this.lineTcpAggressiveRecv = this.getBoolean(properties, env, "line.tcp.io.aggressive.recv", false);
                this.minIdleMsBeforeWriterRelease = this.getLong(properties, env, "line.tcp.min.idle.ms.before.writer.release", 10000L);
            }
            this.sharedWorkerCount = this.getInt(properties, env, "shared.worker.count", Math.max(1, (cpuAvailable - 1) / 2 - cpuUsed));
            this.sharedWorkerAffinity = this.getAffinity(properties, env, "shared.worker.affinity", this.sharedWorkerCount);
            this.sharedWorkerHaltOnError = this.getBoolean(properties, env, "shared.worker.haltOnError", false);
            this.sharedWorkerYieldThreshold = this.getLong(properties, env, "shared.worker.yield.threshold", 10L);
            this.sharedWorkerSleepThreshold = this.getLong(properties, env, "shared.worker.sleep.threshold", 10000L);
            this.buildInformation = buildInformation;
        }
    }

    @Override
    public CairoConfiguration getCairoConfiguration() {
        return this.cairoConfiguration;
    }

    @Override
    public HttpServerConfiguration getHttpServerConfiguration() {
        return this.httpServerConfiguration;
    }

    @Override
    public HttpMinServerConfiguration getHttpMinServerConfiguration() {
        return this.httpMinServerConfiguration;
    }

    @Override
    public LineUdpReceiverConfiguration getLineUdpReceiverConfiguration() {
        return this.lineUdpReceiverConfiguration;
    }

    @Override
    public LineTcpReceiverConfiguration getLineTcpReceiverConfiguration() {
        return this.lineTcpReceiverConfiguration;
    }

    @Override
    public WorkerPoolConfiguration getWorkerPoolConfiguration() {
        return this.workerPoolConfiguration;
    }

    @Override
    public PGWireConfiguration getPGWireConfiguration() {
        return this.pgWireConfiguration;
    }

    private int[] getAffinity(Properties properties, @Nullable Map<String, String> env, String key, int httpWorkerCount) throws ServerConfigurationException {
        int[] result = new int[httpWorkerCount];
        String value = this.overrideWithEnv(properties, env, key);
        if (value == null) {
            Arrays.fill(result, -1);
        } else {
            String[] affinity = value.split(",");
            if (affinity.length != httpWorkerCount) {
                throw new ServerConfigurationException(key, "wrong number of affinity values");
            }
            for (int i = 0; i < httpWorkerCount; ++i) {
                try {
                    result[i] = Numbers.parseInt(affinity[i]);
                    continue;
                }
                catch (NumericException e) {
                    throw new ServerConfigurationException(key, "Invalid affinity value: " + affinity[i]);
                }
            }
        }
        return result;
    }

    protected boolean getBoolean(Properties properties, @Nullable Map<String, String> env, String key, boolean defaultValue) {
        String value = this.overrideWithEnv(properties, env, key);
        return value == null ? defaultValue : Boolean.parseBoolean(value);
    }

    private int getCommitMode(Properties properties, @Nullable Map<String, String> env, String key) {
        String commitMode = this.overrideWithEnv(properties, env, key);
        if (commitMode == null) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "nosync")) {
            return 2;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "async")) {
            return 0;
        }
        if (Chars.equalsLowerCaseAscii(commitMode, "sync")) {
            return 1;
        }
        return 2;
    }

    private double getDouble(Properties properties, @Nullable Map<String, String> env, String key, double defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseDouble(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    protected int getIPv4Address(Properties properties, Map<String, String> env, String key, String defaultValue) throws ServerConfigurationException {
        String value = this.getString(properties, env, key, defaultValue);
        try {
            return Net.parseIPv4(value);
        }
        catch (NetworkError e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private int getInt(Properties properties, @Nullable Map<String, String> env, String key, int defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseInt(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    protected int getIntSize(Properties properties, @Nullable Map<String, String> env, String key, int defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseIntSize(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private LineProtoTimestampAdapter getLineTimestampAdaptor(Properties properties, Map<String, String> env, String propNm) {
        String lineUdpTimestampSwitch;
        switch (lineUdpTimestampSwitch = this.getString(properties, env, propNm, "n")) {
            case "u": {
                return LineProtoMicroTimestampAdapter.INSTANCE;
            }
            case "ms": {
                return LineProtoMilliTimestampAdapter.INSTANCE;
            }
            case "s": {
                return LineProtoSecondTimestampAdapter.INSTANCE;
            }
            case "m": {
                return LineProtoMinuteTimestampAdapter.INSTANCE;
            }
            case "h": {
                return LineProtoHourTimestampAdapter.INSTANCE;
            }
        }
        return LineProtoNanoTimestampAdapter.INSTANCE;
    }

    private long getLong(Properties properties, @Nullable Map<String, String> env, String key, long defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseLong(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private long getLongSize(Properties properties, @Nullable Map<String, String> env, String key, long defaultValue) throws ServerConfigurationException {
        String value = this.overrideWithEnv(properties, env, key);
        try {
            return value != null ? Numbers.parseLongSize(value) : defaultValue;
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, value);
        }
    }

    private String getString(Properties properties, @Nullable Map<String, String> env, String key, String defaultValue) {
        String value = this.overrideWithEnv(properties, env, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    private DateFormat getTimestampFormat(Properties properties, @Nullable Map<String, String> env) {
        String pattern = this.overrideWithEnv(properties, env, "cairo.sql.backup.dir.datetime.format");
        TimestampFormatCompiler compiler = new TimestampFormatCompiler();
        if (null != pattern) {
            return compiler.compile(pattern);
        }
        return compiler.compile("yyyy-MM-dd");
    }

    private String overrideWithEnv(Properties properties, @Nullable Map<String, String> env, String key) {
        String envValue;
        String envCandidate = "QDB_" + key.replace('.', '_').toUpperCase();
        String string = envValue = env != null ? env.get(envCandidate) : null;
        if (envValue != null) {
            this.log.info().$("env config [key=").$(envCandidate).$(']').$();
            return envValue;
        }
        return properties.getProperty(key);
    }

    protected void parseBindTo(Properties properties, Map<String, String> env, String key, String defaultValue, BindToParser parser) throws ServerConfigurationException {
        int port;
        int ipv4;
        String bindTo = this.getString(properties, env, key, defaultValue);
        int colonIndex = bindTo.indexOf(58);
        if (colonIndex == -1) {
            throw new ServerConfigurationException(key, bindTo);
        }
        String ipv4Str = bindTo.substring(0, colonIndex);
        try {
            ipv4 = Net.parseIPv4(ipv4Str);
        }
        catch (NetworkError e) {
            throw new ServerConfigurationException(key, ipv4Str);
        }
        String portStr = bindTo.substring(colonIndex + 1);
        try {
            port = Numbers.parseInt(portStr);
        }
        catch (NumericException e) {
            throw new ServerConfigurationException(key, portStr);
        }
        parser.onReady(ipv4, port);
    }

    private class PropHttpMinServerConfiguration
    implements HttpMinServerConfiguration {
        private PropHttpMinServerConfiguration() {
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.httpMinIODispatcherConfiguration;
        }

        @Override
        public HttpContextConfiguration getHttpContextConfiguration() {
            return PropServerConfiguration.this.httpContextConfiguration;
        }

        @Override
        public WaitProcessorConfiguration getWaitProcessorConfiguration() {
            return PropServerConfiguration.this.httpWaitProcessorConfiguration;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpMinWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpMinWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpMinWorkerHaltOnError;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.httpMinWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.httpMinWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpMinServerEnabled;
        }
    }

    private class PropTelemetryConfiguration
    implements TelemetryConfiguration {
        private PropTelemetryConfiguration() {
        }

        @Override
        public boolean getEnabled() {
            return PropServerConfiguration.this.telemetryEnabled;
        }

        @Override
        public int getQueueCapacity() {
            return PropServerConfiguration.this.telemetryQueueCapacity;
        }
    }

    private class PropPGWireConfiguration
    implements PGWireConfiguration {
        private PropPGWireConfiguration() {
        }

        @Override
        public int getCharacterStoreCapacity() {
            return PropServerConfiguration.this.pgCharacterStoreCapacity;
        }

        @Override
        public int getCharacterStorePoolCapacity() {
            return PropServerConfiguration.this.pgCharacterStorePoolCapacity;
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.pgConnectionPoolInitialCapacity;
        }

        @Override
        public String getDefaultPassword() {
            return PropServerConfiguration.this.pgPassword;
        }

        @Override
        public String getDefaultUsername() {
            return PropServerConfiguration.this.pgUsername;
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.propPGWireDispatcherConfiguration;
        }

        @Override
        public int getFactoryCacheColumnCount() {
            return PropServerConfiguration.this.pgFactoryCacheColumnCount;
        }

        @Override
        public int getFactoryCacheRowCount() {
            return PropServerConfiguration.this.pgFactoryCacheRowCount;
        }

        @Override
        public int getIdleRecvCountBeforeGivingUp() {
            return PropServerConfiguration.this.pgIdleRecvCountBeforeGivingUp;
        }

        @Override
        public int getIdleSendCountBeforeGivingUp() {
            return PropServerConfiguration.this.pgIdleSendCountBeforeGivingUp;
        }

        @Override
        public int getInsertCacheBlockCount() {
            return PropServerConfiguration.this.pgInsertCacheBlockCount;
        }

        @Override
        public int getInsertCacheRowCount() {
            return PropServerConfiguration.this.pgInsertCacheRowCount;
        }

        @Override
        public int getInsertPoolCapacity() {
            return PropServerConfiguration.this.pgInsertPoolCapacity;
        }

        @Override
        public int getMaxBlobSizeOnQuery() {
            return PropServerConfiguration.this.pgMaxBlobSizeOnQuery;
        }

        @Override
        public int getNamedStatementCacheCapacity() {
            return PropServerConfiguration.this.pgNamedStatementCacheCapacity;
        }

        @Override
        public int getNamesStatementPoolCapacity() {
            return PropServerConfiguration.this.pgNamesStatementPoolCapacity;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPendingWritersCacheSize() {
            return PropServerConfiguration.this.pgPendingWritersCacheCapacity;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.pgRecvBufferSize;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.pgSendBufferSize;
        }

        @Override
        public String getServerVersion() {
            return "11.3";
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.pgDefaultLocale;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.pgWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.pgWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.pgHaltOnError;
        }

        @Override
        public boolean isDaemonPool() {
            return PropServerConfiguration.this.pgDaemonPool;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.pgWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.pgWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.pgEnabled;
        }
    }

    private class PropPGWireDispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropPGWireDispatcherConfiguration() {
        }

        @Override
        public int getActiveConnectionLimit() {
            return PropServerConfiguration.this.pgNetActiveConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.pgNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.pgNetBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "pg-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public int getEventCapacity() {
            return PropServerConfiguration.this.pgNetEventCapacity;
        }

        @Override
        public int getIOQueueCapacity() {
            return PropServerConfiguration.this.pgNetIOQueueCapacity;
        }

        @Override
        public long getIdleConnectionTimeout() {
            return PropServerConfiguration.this.pgNetIdleConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public int getInterestQueueCapacity() {
            return PropServerConfiguration.this.pgNetInterestQueueCapacity;
        }

        @Override
        public int getListenBacklog() {
            return PropServerConfiguration.this.pgNetListenBacklog;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.pgNetRcvBufSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.pgNetSndBufSize;
        }
    }

    private class PropWaitProcessorConfiguration
    implements WaitProcessorConfiguration {
        private PropWaitProcessorConfiguration() {
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getMaxWaitCapMs() {
            return PropServerConfiguration.this.maxRerunWaitCapMs;
        }

        @Override
        public double getExponentialWaitMultiplier() {
            return PropServerConfiguration.this.rerunExponentialWaitMultiplier;
        }

        @Override
        public int getInitialWaitQueueSize() {
            return PropServerConfiguration.this.rerunInitialWaitQueueSize;
        }

        @Override
        public int getMaxProcessingQueueSize() {
            return PropServerConfiguration.this.rerunMaxProcessingQueueSize;
        }
    }

    private class PropWorkerPoolConfiguration
    implements WorkerPoolConfiguration {
        private PropWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.sharedWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.sharedWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.sharedWorkerHaltOnError;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.sharedWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.sharedWorkerSleepThreshold;
        }
    }

    private class PropJsonQueryProcessorConfiguration
    implements JsonQueryProcessorConfiguration {
        private PropJsonQueryProcessorConfiguration() {
        }

        @Override
        public MillisecondClock getClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getConnectionCheckFrequency() {
            return PropServerConfiguration.this.jsonQueryConnectionCheckFrequency;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public int getFloatScale() {
            return PropServerConfiguration.this.jsonQueryFloatScale;
        }

        @Override
        public int getDoubleScale() {
            return PropServerConfiguration.this.jsonQueryDoubleScale;
        }

        @Override
        public CharSequence getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }

        @Override
        public long getMaxQueryResponseRowLimit() {
            return PropServerConfiguration.this.maxHttpQueryResponseRowLimit;
        }

        @Override
        public SqlInterruptorConfiguration getInterruptorConfiguration() {
            return PropServerConfiguration.this.interruptorConfiguration;
        }
    }

    private class PropLineTcpReceiverConfiguration
    implements LineTcpReceiverConfiguration {
        private PropLineTcpReceiverConfiguration() {
        }

        @Override
        public String getAuthDbPath() {
            return PropServerConfiguration.this.lineTcpAuthDbPath;
        }

        @Override
        public CairoSecurityContext getCairoSecurityContext() {
            return AllowAllCairoSecurityContext.INSTANCE;
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.lineTcpConnectionPoolInitialCapacity;
        }

        @Override
        public int getDefaultPartitionBy() {
            return PropServerConfiguration.this.lineDefaultPartitionBy;
        }

        @Override
        public WorkerPoolAwareConfiguration getIOWorkerPoolConfiguration() {
            return PropServerConfiguration.this.lineTcpIOWorkerPoolConfiguration;
        }

        @Override
        public long getMaintenanceInterval() {
            return PropServerConfiguration.this.lineTcpMaintenanceInterval;
        }

        @Override
        public double getMaxLoadRatio() {
            return PropServerConfiguration.this.lineTcpMaxLoadRatio;
        }

        @Override
        public int getMaxMeasurementSize() {
            return PropServerConfiguration.this.lineTcpMaxMeasurementSize;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public long getWriterIdleTimeout() {
            return PropServerConfiguration.this.minIdleMsBeforeWriterRelease;
        }

        @Override
        public int getNUpdatesPerLoadRebalance() {
            return PropServerConfiguration.this.lineTcpNUpdatesPerLoadRebalance;
        }

        @Override
        public IODispatcherConfiguration getNetDispatcherConfiguration() {
            return PropServerConfiguration.this.lineTcpReceiverDispatcherConfiguration;
        }

        @Override
        public int getNetMsgBufferSize() {
            return PropServerConfiguration.this.lineTcpMsgBufferSize;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public LineProtoTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineTcpTimestampAdapter;
        }

        @Override
        public int getWriterQueueCapacity() {
            return PropServerConfiguration.this.lineTcpWriterQueueCapacity;
        }

        @Override
        public WorkerPoolAwareConfiguration getWriterWorkerPoolConfiguration() {
            return PropServerConfiguration.this.lineTcpWriterWorkerPoolConfiguration;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineTcpEnabled;
        }

        @Override
        public boolean isIOAggressiveRecv() {
            return PropServerConfiguration.this.lineTcpAggressiveRecv;
        }
    }

    private class PropLineTcpIOWorkerPoolConfiguration
    implements WorkerPoolAwareConfiguration {
        private PropLineTcpIOWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.lineTcpIOWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.lineTcpIOWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.lineTcpIOWorkerPoolHaltOnError;
        }

        @Override
        public String getPoolName() {
            return "ilpio";
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.lineTcpIOWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class PropLineTcpWriterWorkerPoolConfiguration
    implements WorkerPoolAwareConfiguration {
        private PropLineTcpWriterWorkerPoolConfiguration() {
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.lineTcpWriterWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.lineTcpWriterWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.lineTcpWriterWorkerPoolHaltOnError;
        }

        @Override
        public String getPoolName() {
            return "ilpwriter";
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.lineTcpWriterWorkerSleepThreshold;
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    }

    private class PropLineTcpReceiverIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropLineTcpReceiverIODispatcherConfiguration() {
        }

        @Override
        public int getActiveConnectionLimit() {
            return PropServerConfiguration.this.lineTcpNetActiveConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineTcpNetBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.lineTcpNetBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "tcp-line-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public int getEventCapacity() {
            return PropServerConfiguration.this.lineTcpNetEventCapacity;
        }

        @Override
        public int getIOQueueCapacity() {
            return PropServerConfiguration.this.lineTcpNetIOQueueCapacity;
        }

        @Override
        public long getIdleConnectionTimeout() {
            return PropServerConfiguration.this.lineTcpNetIdleConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public int getInterestQueueCapacity() {
            return PropServerConfiguration.this.lineTcpNetInterestQueueCapacity;
        }

        @Override
        public int getListenBacklog() {
            return PropServerConfiguration.this.lineTcpNetListenBacklog;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.lineTcpNetRcvBufSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return -1;
        }
    }

    private class PropLineUdpReceiverConfiguration
    implements LineUdpReceiverConfiguration {
        private PropLineUdpReceiverConfiguration() {
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.lineUdpCommitMode;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.lineUdpBindIPV4Address;
        }

        @Override
        public int getCommitRate() {
            return PropServerConfiguration.this.lineUdpCommitRate;
        }

        @Override
        public int getGroupIPv4Address() {
            return PropServerConfiguration.this.lineUdpGroupIPv4Address;
        }

        @Override
        public int getMsgBufferSize() {
            return PropServerConfiguration.this.lineUdpMsgBufferSize;
        }

        @Override
        public int getMsgCount() {
            return PropServerConfiguration.this.lineUdpMsgCount;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getPort() {
            return PropServerConfiguration.this.lineUdpPort;
        }

        @Override
        public int getReceiveBufferSize() {
            return PropServerConfiguration.this.lineUdpReceiveBufferSize;
        }

        @Override
        public CairoSecurityContext getCairoSecurityContext() {
            return AllowAllCairoSecurityContext.INSTANCE;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.lineUdpEnabled;
        }

        @Override
        public boolean isUnicast() {
            return PropServerConfiguration.this.lineUdpUnicast;
        }

        @Override
        public boolean ownThread() {
            return PropServerConfiguration.this.lineUdpOwnThread;
        }

        @Override
        public int ownThreadAffinity() {
            return PropServerConfiguration.this.lineUdpOwnThreadAffinity;
        }

        @Override
        public LineProtoTimestampAdapter getTimestampAdapter() {
            return PropServerConfiguration.this.lineUdpTimestampAdapter;
        }
    }

    private class PropCairoConfiguration
    implements CairoConfiguration {
        private PropCairoConfiguration() {
        }

        @Override
        public int getBindVariablePoolSize() {
            return PropServerConfiguration.this.sqlBindVariablePoolSize;
        }

        @Override
        public int getO3PurgeDiscoveryQueueCapacity() {
            return PropServerConfiguration.this.o3PurgeDiscoveryQueueCapacity;
        }

        @Override
        public int getO3PurgeQueueCapacity() {
            return PropServerConfiguration.this.o3PurgeQueueCapacity;
        }

        @Override
        public int getSqlCopyBufferSize() {
            return PropServerConfiguration.this.sqlCopyBufferSize;
        }

        @Override
        public int getCopyPoolCapacity() {
            return PropServerConfiguration.this.sqlCopyModelPoolCapacity;
        }

        @Override
        public int getCreateAsSelectRetryCount() {
            return PropServerConfiguration.this.createAsSelectRetryCount;
        }

        @Override
        public CharSequence getDefaultMapType() {
            return PropServerConfiguration.this.defaultMapType;
        }

        @Override
        public boolean getDefaultSymbolCacheFlag() {
            return PropServerConfiguration.this.defaultSymbolCacheFlag;
        }

        @Override
        public int getDefaultSymbolCapacity() {
            return PropServerConfiguration.this.defaultSymbolCapacity;
        }

        @Override
        public int getFileOperationRetryCount() {
            return PropServerConfiguration.this.fileOperationRetryCount;
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public long getIdleCheckInterval() {
            return PropServerConfiguration.this.idleCheckInterval;
        }

        @Override
        public long getInactiveReaderTTL() {
            return PropServerConfiguration.this.inactiveReaderTTL;
        }

        @Override
        public long getInactiveWriterTTL() {
            return PropServerConfiguration.this.inactiveWriterTTL;
        }

        @Override
        public int getIndexValueBlockSize() {
            return PropServerConfiguration.this.indexValueBlockSize;
        }

        @Override
        public int getDoubleToStrCastScale() {
            return PropServerConfiguration.this.sqlDoubleToStrCastScale;
        }

        @Override
        public int getFloatToStrCastScale() {
            return PropServerConfiguration.this.sqlFloatToStrCastScale;
        }

        @Override
        public int getMaxSwapFileCount() {
            return PropServerConfiguration.this.maxSwapFileCount;
        }

        @Override
        public MicrosecondClock getMicrosecondClock() {
            return MicrosecondClockImpl.INSTANCE;
        }

        @Override
        public MillisecondClock getMillisecondClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public NanosecondClock getNanosecondClock() {
            return NanosecondClockImpl.INSTANCE;
        }

        @Override
        public int getMkDirMode() {
            return PropServerConfiguration.this.mkdirMode;
        }

        @Override
        public int getParallelIndexThreshold() {
            return PropServerConfiguration.this.parallelIndexThreshold;
        }

        @Override
        public int getReaderPoolMaxSegments() {
            return PropServerConfiguration.this.readerPoolMaxSegments;
        }

        @Override
        public CharSequence getRoot() {
            return PropServerConfiguration.this.databaseRoot;
        }

        @Override
        public CharSequence getInputRoot() {
            return PropServerConfiguration.this.inputRoot;
        }

        @Override
        public CharSequence getBackupRoot() {
            return PropServerConfiguration.this.backupRoot;
        }

        @Override
        public DateFormat getBackupDirTimestampFormat() {
            return PropServerConfiguration.this.backupDirTimestampFormat;
        }

        @Override
        public CharSequence getBackupTempDirName() {
            return PropServerConfiguration.this.backupTempDirName;
        }

        @Override
        public int getBackupMkDirMode() {
            return PropServerConfiguration.this.backupMkdirMode;
        }

        @Override
        public long getSpinLockTimeoutUs() {
            return PropServerConfiguration.this.spinLockTimeoutUs;
        }

        @Override
        public int getSqlCharacterStoreCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreCapacity;
        }

        @Override
        public int getSqlCharacterStoreSequencePoolCapacity() {
            return PropServerConfiguration.this.sqlCharacterStoreSequencePoolCapacity;
        }

        @Override
        public int getSqlColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnPoolCapacity;
        }

        @Override
        public double getSqlCompactMapLoadFactor() {
            return PropServerConfiguration.this.sqlCompactMapLoadFactor;
        }

        @Override
        public int getSqlExpressionPoolCapacity() {
            return PropServerConfiguration.this.sqlExpressionPoolCapacity;
        }

        @Override
        public double getSqlFastMapLoadFactor() {
            return PropServerConfiguration.this.sqlFastMapLoadFactor;
        }

        @Override
        public int getSqlJoinContextPoolCapacity() {
            return PropServerConfiguration.this.sqlJoinContextPoolCapacity;
        }

        @Override
        public int getSqlLexerPoolCapacity() {
            return PropServerConfiguration.this.sqlLexerPoolCapacity;
        }

        @Override
        public int getSqlMapKeyCapacity() {
            return PropServerConfiguration.this.sqlMapKeyCapacity;
        }

        @Override
        public int getSqlMapPageSize() {
            return PropServerConfiguration.this.sqlMapPageSize;
        }

        @Override
        public int getSqlMapMaxPages() {
            return PropServerConfiguration.this.sqlMapMaxPages;
        }

        @Override
        public int getSqlMapMaxResizes() {
            return PropServerConfiguration.this.sqlMapMaxResizes;
        }

        @Override
        public int getSqlModelPoolCapacity() {
            return PropServerConfiguration.this.sqlModelPoolCapacity;
        }

        @Override
        public long getSqlSortKeyPageSize() {
            return PropServerConfiguration.this.sqlSortKeyPageSize;
        }

        @Override
        public int getSqlSortKeyMaxPages() {
            return PropServerConfiguration.this.sqlSortKeyMaxPages;
        }

        @Override
        public long getSqlSortLightValuePageSize() {
            return PropServerConfiguration.this.sqlSortLightValuePageSize;
        }

        @Override
        public int getSqlSortLightValueMaxPages() {
            return PropServerConfiguration.this.sqlSortLightValueMaxPages;
        }

        @Override
        public int getSqlHashJoinValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinValuePageSize;
        }

        @Override
        public int getSqlHashJoinValueMaxPages() {
            return PropServerConfiguration.this.sqlHashJoinValueMaxPages;
        }

        @Override
        public int getSqlAnalyticStorePageSize() {
            return PropServerConfiguration.this.sqlAnalyticStorePageSize;
        }

        @Override
        public int getSqlAnalyticStoreMaxPages() {
            return PropServerConfiguration.this.sqlAnalyticStoreMaxPages;
        }

        @Override
        public int getSqlAnalyticRowIdPageSize() {
            return PropServerConfiguration.this.sqlAnalyticRowIdPageSize;
        }

        @Override
        public int getSqlAnalyticRowIdMaxPages() {
            return PropServerConfiguration.this.sqlAnalyticRowIdMaxPages;
        }

        @Override
        public int getSqlAnalyticTreeKeyPageSize() {
            return PropServerConfiguration.this.sqlAnalyticTreeKeyPageSize;
        }

        @Override
        public int getSqlAnalyticTreeKeyMaxPages() {
            return PropServerConfiguration.this.sqlAnalyticTreeKeyMaxPages;
        }

        @Override
        public long getSqlLatestByRowCount() {
            return PropServerConfiguration.this.sqlLatestByRowCount;
        }

        @Override
        public int getSqlHashJoinLightValuePageSize() {
            return PropServerConfiguration.this.sqlHashJoinLightValuePageSize;
        }

        @Override
        public int getSqlHashJoinLightValueMaxPages() {
            return PropServerConfiguration.this.sqlHashJoinLightValueMaxPages;
        }

        @Override
        public int getSqlSortValuePageSize() {
            return PropServerConfiguration.this.sqlSortValuePageSize;
        }

        @Override
        public int getSqlSortValueMaxPages() {
            return PropServerConfiguration.this.sqlSortValueMaxPages;
        }

        @Override
        public TextConfiguration getTextConfiguration() {
            return PropServerConfiguration.this.textConfiguration;
        }

        @Override
        public long getWorkStealTimeoutNanos() {
            return PropServerConfiguration.this.workStealTimeoutNanos;
        }

        @Override
        public boolean isParallelIndexingEnabled() {
            return PropServerConfiguration.this.parallelIndexingEnabled;
        }

        @Override
        public int getSqlJoinMetadataPageSize() {
            return PropServerConfiguration.this.sqlJoinMetadataPageSize;
        }

        @Override
        public int getSqlJoinMetadataMaxResizes() {
            return PropServerConfiguration.this.sqlJoinMetadataMaxResizes;
        }

        @Override
        public int getAnalyticColumnPoolCapacity() {
            return PropServerConfiguration.this.sqlAnalyticColumnPoolCapacity;
        }

        @Override
        public int getCreateTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlCreateTableModelPoolCapacity;
        }

        @Override
        public int getColumnCastModelPoolCapacity() {
            return PropServerConfiguration.this.sqlColumnCastModelPoolCapacity;
        }

        @Override
        public int getRenameTableModelPoolCapacity() {
            return PropServerConfiguration.this.sqlRenameTableModelPoolCapacity;
        }

        @Override
        public int getWithClauseModelPoolCapacity() {
            return PropServerConfiguration.this.sqlWithClauseModelPoolCapacity;
        }

        @Override
        public int getInsertPoolCapacity() {
            return PropServerConfiguration.this.sqlInsertModelPoolCapacity;
        }

        @Override
        public int getCommitMode() {
            return PropServerConfiguration.this.commitMode;
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.locale;
        }

        @Override
        public int getGroupByPoolCapacity() {
            return PropServerConfiguration.this.sqlGroupByPoolCapacity;
        }

        @Override
        public int getMaxSymbolNotEqualsCount() {
            return PropServerConfiguration.this.sqlMaxSymbolNotEqualsCount;
        }

        @Override
        public int getGroupByMapCapacity() {
            return PropServerConfiguration.this.sqlGroupByMapCapacity;
        }

        @Override
        public boolean enableTestFactories() {
            return false;
        }

        @Override
        public TelemetryConfiguration getTelemetryConfiguration() {
            return PropServerConfiguration.this.telemetryConfiguration;
        }

        @Override
        public long getAppendPageSize() {
            return PropServerConfiguration.this.sqlAppendPageSize;
        }

        @Override
        public int getTableBlockWriterQueueCapacity() {
            return PropServerConfiguration.this.tableBlockWriterQueueCapacity;
        }

        @Override
        public int getColumnIndexerQueueCapacity() {
            return PropServerConfiguration.this.columnIndexerQueueCapacity;
        }

        @Override
        public int getVectorAggregateQueueCapacity() {
            return PropServerConfiguration.this.vectorAggregateQueueCapacity;
        }

        @Override
        public int getO3CallbackQueueCapacity() {
            return PropServerConfiguration.this.o3CallbackQueueCapacity;
        }

        @Override
        public int getO3PartitionQueueCapacity() {
            return PropServerConfiguration.this.o3PartitionQueueCapacity;
        }

        @Override
        public int getO3OpenColumnQueueCapacity() {
            return PropServerConfiguration.this.o3OpenColumnQueueCapacity;
        }

        @Override
        public int getO3CopyQueueCapacity() {
            return PropServerConfiguration.this.o3CopyQueueCapacity;
        }

        @Override
        public int getO3PartitionUpdateQueueCapacity() {
            return PropServerConfiguration.this.o3UpdPartitionSizeQueueCapacity;
        }

        @Override
        public BuildInformation getBuildInformation() {
            return PropServerConfiguration.this.buildInformation;
        }

        @Override
        public long getDatabaseIdHi() {
            return PropServerConfiguration.this.instanceHashHi;
        }

        @Override
        public long getDatabaseIdLo() {
            return PropServerConfiguration.this.instanceHashLo;
        }

        @Override
        public int getTxnScoreboardEntryCount() {
            return PropServerConfiguration.this.sqlTxnScoreboardEntryCount;
        }

        @Override
        public int getO3MaxUncommittedRows() {
            return PropServerConfiguration.this.o3MaxUncommittedRows;
        }

        @Override
        public long getO3CommitHysteresis() {
            return PropServerConfiguration.this.o3CommitHystersis;
        }

        @Override
        public boolean isO3QuickSortEnabled() {
            return PropServerConfiguration.this.o3QuickSortEnabled;
        }
    }

    private class PropHttpServerConfiguration
    implements HttpServerConfiguration {
        private PropHttpServerConfiguration() {
        }

        @Override
        public IODispatcherConfiguration getDispatcherConfiguration() {
            return PropServerConfiguration.this.httpIODispatcherConfiguration;
        }

        @Override
        public HttpContextConfiguration getHttpContextConfiguration() {
            return PropServerConfiguration.this.httpContextConfiguration;
        }

        @Override
        public JsonQueryProcessorConfiguration getJsonQueryProcessorConfiguration() {
            return PropServerConfiguration.this.jsonQueryProcessorConfiguration;
        }

        @Override
        public int getQueryCacheBlocks() {
            return PropServerConfiguration.this.sqlCacheBlocks;
        }

        @Override
        public int getQueryCacheRows() {
            return PropServerConfiguration.this.sqlCacheRows;
        }

        @Override
        public WaitProcessorConfiguration getWaitProcessorConfiguration() {
            return PropServerConfiguration.this.httpWaitProcessorConfiguration;
        }

        @Override
        public StaticContentProcessorConfiguration getStaticContentProcessorConfiguration() {
            return PropServerConfiguration.this.staticContentProcessorConfiguration;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.httpServerEnabled;
        }

        @Override
        public int[] getWorkerAffinity() {
            return PropServerConfiguration.this.httpWorkerAffinity;
        }

        @Override
        public int getWorkerCount() {
            return PropServerConfiguration.this.httpWorkerCount;
        }

        @Override
        public boolean haltOnError() {
            return PropServerConfiguration.this.httpWorkerHaltOnError;
        }

        @Override
        public long getYieldThreshold() {
            return PropServerConfiguration.this.httpWorkerYieldThreshold;
        }

        @Override
        public long getSleepThreshold() {
            return PropServerConfiguration.this.httpWorkerSleepThreshold;
        }
    }

    private class PropHttpContextConfiguration
    implements HttpContextConfiguration {
        private PropHttpContextConfiguration() {
        }

        @Override
        public boolean allowDeflateBeforeSend() {
            return PropServerConfiguration.this.httpAllowDeflateBeforeSend;
        }

        @Override
        public MillisecondClock getClock() {
            return PropServerConfiguration.this.httpFrozenClock ? StationaryMillisClock.INSTANCE : MillisecondClockImpl.INSTANCE;
        }

        @Override
        public int getConnectionPoolInitialCapacity() {
            return PropServerConfiguration.this.connectionPoolInitialCapacity;
        }

        @Override
        public int getConnectionStringPoolCapacity() {
            return PropServerConfiguration.this.connectionStringPoolCapacity;
        }

        @Override
        public boolean getDumpNetworkTraffic() {
            return false;
        }

        @Override
        public String getHttpVersion() {
            return PropServerConfiguration.this.httpVersion;
        }

        @Override
        public int getMultipartHeaderBufferSize() {
            return PropServerConfiguration.this.multipartHeaderBufferSize;
        }

        @Override
        public long getMultipartIdleSpinCount() {
            return PropServerConfiguration.this.multipartIdleSpinCount;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRecvBufferSize() {
            return PropServerConfiguration.this.recvBufferSize;
        }

        @Override
        public int getRequestHeaderBufferSize() {
            return PropServerConfiguration.this.requestHeaderBufferSize;
        }

        @Override
        public int getSendBufferSize() {
            return PropServerConfiguration.this.sendBufferSize;
        }

        @Override
        public boolean getServerKeepAlive() {
            return PropServerConfiguration.this.httpServerKeepAlive;
        }

        @Override
        public boolean readOnlySecurityContext() {
            return PropServerConfiguration.this.readOnlySecurityContext;
        }
    }

    private class PropSqlInterruptorConfiguration
    implements SqlInterruptorConfiguration {
        private PropSqlInterruptorConfiguration() {
        }

        @Override
        public int getBufferSize() {
            return PropServerConfiguration.this.interruptorBufferSize;
        }

        @Override
        public int getCountOfIterationsPerCheck() {
            return PropServerConfiguration.this.interruptorNIterationsPerCheck;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public boolean isEnabled() {
            return PropServerConfiguration.this.interruptOnClosedConnection;
        }
    }

    private class PropTextConfiguration
    implements TextConfiguration {
        private PropTextConfiguration() {
        }

        @Override
        public int getDateAdapterPoolCapacity() {
            return PropServerConfiguration.this.dateAdapterPoolCapacity;
        }

        @Override
        public int getJsonCacheLimit() {
            return PropServerConfiguration.this.jsonCacheLimit;
        }

        @Override
        public int getJsonCacheSize() {
            return PropServerConfiguration.this.jsonCacheSize;
        }

        @Override
        public double getMaxRequiredDelimiterStdDev() {
            return PropServerConfiguration.this.maxRequiredDelimiterStdDev;
        }

        @Override
        public double getMaxRequiredLineLengthStdDev() {
            return PropServerConfiguration.this.maxRequiredLineLengthStdDev;
        }

        @Override
        public int getMetadataStringPoolCapacity() {
            return PropServerConfiguration.this.metadataStringPoolCapacity;
        }

        @Override
        public int getRollBufferLimit() {
            return PropServerConfiguration.this.rollBufferLimit;
        }

        @Override
        public int getRollBufferSize() {
            return PropServerConfiguration.this.rollBufferSize;
        }

        @Override
        public int getTextAnalysisMaxLines() {
            return PropServerConfiguration.this.textAnalysisMaxLines;
        }

        @Override
        public int getTextLexerStringPoolCapacity() {
            return PropServerConfiguration.this.textLexerStringPoolCapacity;
        }

        @Override
        public int getTimestampAdapterPoolCapacity() {
            return PropServerConfiguration.this.timestampAdapterPoolCapacity;
        }

        @Override
        public int getUtf8SinkSize() {
            return PropServerConfiguration.this.utf8SinkSize;
        }

        @Override
        public InputFormatConfiguration getInputFormatConfiguration() {
            return PropServerConfiguration.this.inputFormatConfiguration;
        }

        @Override
        public DateLocale getDefaultDateLocale() {
            return PropServerConfiguration.this.locale;
        }
    }

    private class PropHttpMinIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropHttpMinIODispatcherConfiguration() {
        }

        @Override
        public int getActiveConnectionLimit() {
            return PropServerConfiguration.this.httpActiveConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.httpMinBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.httpMinBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "http-min-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public int getEventCapacity() {
            return PropServerConfiguration.this.httpMinEventCapacity;
        }

        @Override
        public int getIOQueueCapacity() {
            return PropServerConfiguration.this.httpMinIOQueueCapacity;
        }

        @Override
        public long getIdleConnectionTimeout() {
            return PropServerConfiguration.this.httpMinIdleConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public int getInterestQueueCapacity() {
            return PropServerConfiguration.this.httpMinInterestQueueCapacity;
        }

        @Override
        public int getListenBacklog() {
            return PropServerConfiguration.this.httpMinListenBacklog;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.httpMinRcvBufSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.httpMinSndBufSize;
        }
    }

    private class PropHttpIODispatcherConfiguration
    implements IODispatcherConfiguration {
        private PropHttpIODispatcherConfiguration() {
        }

        @Override
        public int getActiveConnectionLimit() {
            return PropServerConfiguration.this.httpActiveConnectionLimit;
        }

        @Override
        public int getBindIPv4Address() {
            return PropServerConfiguration.this.httpBindIPv4Address;
        }

        @Override
        public int getBindPort() {
            return PropServerConfiguration.this.httpBindPort;
        }

        @Override
        public MillisecondClock getClock() {
            return MillisecondClockImpl.INSTANCE;
        }

        @Override
        public String getDispatcherLogName() {
            return "http-server";
        }

        @Override
        public EpollFacade getEpollFacade() {
            return EpollFacadeImpl.INSTANCE;
        }

        @Override
        public int getEventCapacity() {
            return PropServerConfiguration.this.httpEventCapacity;
        }

        @Override
        public int getIOQueueCapacity() {
            return PropServerConfiguration.this.httpIOQueueCapacity;
        }

        @Override
        public long getIdleConnectionTimeout() {
            return PropServerConfiguration.this.httpIdleConnectionTimeout;
        }

        @Override
        public int getInitialBias() {
            return 1;
        }

        @Override
        public int getInterestQueueCapacity() {
            return PropServerConfiguration.this.httpInterestQueueCapacity;
        }

        @Override
        public int getListenBacklog() {
            return PropServerConfiguration.this.httpListenBacklog;
        }

        @Override
        public NetworkFacade getNetworkFacade() {
            return NetworkFacadeImpl.INSTANCE;
        }

        @Override
        public int getRcvBufSize() {
            return PropServerConfiguration.this.httpRcvBufSize;
        }

        @Override
        public SelectFacade getSelectFacade() {
            return SelectFacadeImpl.INSTANCE;
        }

        @Override
        public int getSndBufSize() {
            return PropServerConfiguration.this.httpSndBufSize;
        }
    }

    private class PropStaticContentProcessorConfiguration
    implements StaticContentProcessorConfiguration {
        private PropStaticContentProcessorConfiguration() {
        }

        @Override
        public FilesFacade getFilesFacade() {
            return FilesFacadeImpl.INSTANCE;
        }

        @Override
        public CharSequence getIndexFileName() {
            return PropServerConfiguration.this.indexFileName;
        }

        @Override
        public MimeTypesCache getMimeTypesCache() {
            return PropServerConfiguration.this.mimeTypesCache;
        }

        @Override
        public CharSequence getPublicDirectory() {
            return PropServerConfiguration.this.publicDirectory;
        }

        @Override
        public String getKeepAliveHeader() {
            return PropServerConfiguration.this.keepAliveHeader;
        }
    }

    @FunctionalInterface
    protected static interface BindToParser {
        public void onReady(int var1, int var2);
    }
}

