/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.BuildInformation;
import io.questdb.BuildInformationHolder;
import io.questdb.PropServerConfiguration;
import io.questdb.ServerConfigurationException;
import io.questdb.TelemetryJob;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.O3CallbackJob;
import io.questdb.cairo.O3CopyJob;
import io.questdb.cairo.O3OpenColumnJob;
import io.questdb.cairo.O3PartitionJob;
import io.questdb.cairo.O3PurgeDiscoveryJob;
import io.questdb.cairo.O3PurgeJob;
import io.questdb.cairo.O3Utils;
import io.questdb.cutlass.http.HttpServer;
import io.questdb.cutlass.json.JsonException;
import io.questdb.cutlass.line.tcp.LineTcpServer;
import io.questdb.cutlass.line.udp.LineProtoReceiver;
import io.questdb.cutlass.line.udp.LinuxMMLineProtoReceiver;
import io.questdb.cutlass.pgwire.PGWireServer;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.log.LogRecord;
import io.questdb.mp.WorkerPool;
import io.questdb.network.NetworkError;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.Os;
import io.questdb.std.Vect;
import io.questdb.std.datetime.millitime.Dates;
import io.questdb.std.str.Path;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.concurrent.locks.LockSupport;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import sun.misc.Signal;

public class ServerMain {
    private static final String VERSION_TXT = "version.txt";
    protected PropServerConfiguration configuration;

    public ServerMain(String[] args) throws Exception {
        BuildInformation buildInformation = ServerMain.fetchBuildInformation();
        System.err.printf("QuestDB server %s%nCopyright (C) 2014-%d, all rights reserved.%n%n", buildInformation.getQuestDbVersion(), Dates.getYear(System.currentTimeMillis()));
        if (args.length < 1) {
            System.err.println("Root directory name expected");
            return;
        }
        if (Os.type == -2) {
            System.err.println("QuestDB requires 64-bit JVM");
            return;
        }
        CharSequenceObjHashMap<String> optHash = ServerMain.hashArgs(args);
        Log log = LogFactory.getLog("server-main");
        String rootDirectory = optHash.get("-d");
        ServerMain.extractSite(rootDirectory, log);
        Properties properties = new Properties();
        String configurationFileName = "/server.conf";
        File configurationFile = new File(new File(rootDirectory, "conf"), "/server.conf");
        try (FileInputStream is = new FileInputStream(configurationFile);){
            properties.load(is);
        }
        this.readServerConfiguration(rootDirectory, properties, log, buildInformation);
        log.info().$("open database [id=").$(this.configuration.getCairoConfiguration().getDatabaseIdLo()).$('.').$(this.configuration.getCairoConfiguration().getDatabaseIdHi()).$(']').$();
        log.info().$("platform [bit=").$(System.getProperty("sun.arch.data.model")).$(']').$();
        switch (Os.type) {
            case 3: {
                log.info().$("OS: windows-amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 2: {
                log.info().$("OS: linux-amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 1: {
                log.info().$("OS: apple-amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 6: {
                log.info().$("OS: apple-silicon").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 4: {
                log.info().$("OS: linux-arm64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            case 5: {
                log.info().$("OS: freebsd-amd64").$(Vect.getSupportedInstructionSetName()).$();
                break;
            }
            default: {
                log.error().$("Unsupported OS").$(Vect.getSupportedInstructionSetName()).$();
            }
        }
        WorkerPool workerPool = new WorkerPool(this.configuration.getWorkerPoolConfiguration());
        FunctionFactoryCache functionFactoryCache = new FunctionFactoryCache(this.configuration.getCairoConfiguration(), ServiceLoader.load(FunctionFactory.class));
        ObjList<Closeable> instancesToClean = new ObjList<Closeable>();
        LogFactory.configureFromSystemProperties(workerPool);
        CairoEngine cairoEngine = new CairoEngine(this.configuration.getCairoConfiguration());
        workerPool.assign(cairoEngine.getWriterMaintenanceJob());
        instancesToClean.add(cairoEngine);
        TelemetryJob telemetryJob = new TelemetryJob(cairoEngine, functionFactoryCache);
        instancesToClean.add(telemetryJob);
        if (this.configuration.getCairoConfiguration().getTelemetryConfiguration().getEnabled()) {
            workerPool.assign(telemetryJob);
        }
        workerPool.assignCleaner(Path.CLEANER);
        workerPool.assign(new O3CallbackJob(cairoEngine.getMessageBus()));
        workerPool.assign(new O3PartitionJob(cairoEngine.getMessageBus()));
        workerPool.assign(new O3OpenColumnJob(cairoEngine.getMessageBus()));
        workerPool.assign(new O3CopyJob(cairoEngine.getMessageBus()));
        workerPool.assign(new O3PurgeDiscoveryJob(cairoEngine.getMessageBus(), workerPool.getWorkerCount()));
        workerPool.assign(new O3PurgeJob(cairoEngine.getMessageBus()));
        O3Utils.initBuf(workerPool.getWorkerCount() + 1);
        try {
            this.initQuestDb(workerPool, cairoEngine, log);
            instancesToClean.add(this.createHttpServer(workerPool, log, cairoEngine, functionFactoryCache));
            instancesToClean.add(this.createMinHttpServer(workerPool, log, cairoEngine, functionFactoryCache));
            if (this.configuration.getPGWireConfiguration().isEnabled()) {
                instancesToClean.add(PGWireServer.create(this.configuration.getPGWireConfiguration(), workerPool, log, cairoEngine, functionFactoryCache));
            }
            if (this.configuration.getLineUdpReceiverConfiguration().isEnabled()) {
                if (Os.type == 2 || Os.type == 4) {
                    instancesToClean.add(new LinuxMMLineProtoReceiver(this.configuration.getLineUdpReceiverConfiguration(), cairoEngine, workerPool));
                } else {
                    instancesToClean.add(new LineProtoReceiver(this.configuration.getLineUdpReceiverConfiguration(), cairoEngine, workerPool));
                }
            }
            instancesToClean.add(LineTcpServer.create(this.configuration.getLineTcpReceiverConfiguration(), workerPool, log, cairoEngine));
            this.startQuestDb(workerPool, cairoEngine, log);
            if (this.configuration.getHttpServerConfiguration().isEnabled()) {
                ServerMain.logWebConsoleUrls(log, this.configuration);
            }
            System.gc();
            if (Os.type != 3 && optHash.get("-n") == null) {
                Signal.handle(new Signal("HUP"), signal -> {});
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                System.err.println(new Date() + " QuestDB is shutting down");
                ServerMain.shutdownQuestDb(workerPool, instancesToClean);
                System.err.println(new Date() + " QuestDB is down");
            }));
        }
        catch (NetworkError e) {
            log.error().$(e.getMessage()).$();
            LockSupport.parkNanos(10000000L);
            System.exit(55);
        }
    }

    public static void deleteOrException(File file) {
        if (!file.exists()) {
            return;
        }
        ServerMain.deleteDirContentsOrException(file);
        boolean deleted = false;
        for (int retryCount = 3; retryCount > 0 && !(deleted = file.delete()); --retryCount) {
            Thread.yield();
        }
        if (!deleted) {
            throw new RuntimeException("Cannot delete file " + file);
        }
    }

    public static void main(String[] args) throws Exception {
        new ServerMain(args);
    }

    private static void logWebConsoleUrls(Log log, PropServerConfiguration configuration) throws SocketException {
        LogRecord record = log.info().$("web console URL(s):").$('\n').$('\n');
        int httpBindIP = configuration.getHttpServerConfiguration().getDispatcherConfiguration().getBindIPv4Address();
        int httpBindPort = configuration.getHttpServerConfiguration().getDispatcherConfiguration().getBindPort();
        if (httpBindIP == 0) {
            Enumeration<NetworkInterface> nets = NetworkInterface.getNetworkInterfaces();
            for (NetworkInterface networkInterface : Collections.list(nets)) {
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                for (InetAddress inetAddress : Collections.list(inetAddresses)) {
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    record.$('\t').$("http:/").$(inetAddress).$(':').$(httpBindPort).$('\n');
                }
            }
            record.$('\n').$();
        } else {
            record.$('\t').$("http://").$ip(httpBindIP).$(':').$(httpBindPort).$('\n').$();
        }
    }

    private static CharSequenceObjHashMap<String> hashArgs(String[] args) {
        CharSequenceObjHashMap<String> optHash = new CharSequenceObjHashMap<String>();
        String flag = null;
        for (String s : args) {
            if (s.startsWith("-")) {
                if (flag != null) {
                    optHash.put(flag, "");
                }
                flag = s;
                continue;
            }
            if (flag != null) {
                optHash.put(flag, s);
                flag = null;
                continue;
            }
            System.err.println("Unknown arg: " + s);
            System.exit(55);
        }
        if (flag != null) {
            optHash.put(flag, "");
        }
        return optHash;
    }

    private static long getPublicVersion(String publicDir) throws IOException {
        File f = new File(publicDir, VERSION_TXT);
        if (f.exists()) {
            try (FileInputStream fis = new FileInputStream(f);){
                byte[] buf = new byte[128];
                int len = fis.read(buf);
                long l = Long.parseLong(new String(buf, 0, len));
                return l;
            }
        }
        return Long.MIN_VALUE;
    }

    private static void setPublicVersion(String publicDir, long version) throws IOException {
        File f = new File(publicDir, VERSION_TXT);
        try (FileOutputStream fos = new FileOutputStream(f);){
            byte[] buf = Long.toString(version).getBytes();
            fos.write(buf, 0, buf.length);
        }
    }

    private static void extractSite(String dir, Log log) throws IOException {
        String publicZip = "/io/questdb/site/public.zip";
        String publicDir = dir + "/public";
        byte[] buffer = new byte[0x100000];
        URL resource = ServerMain.class.getResource("/io/questdb/site/public.zip");
        long thisVersion = Long.MIN_VALUE;
        if (resource == null) {
            log.error().$("did not find Web Console build at '").$("/io/questdb/site/public.zip").$("'. Proceeding without Web Console checks").$();
        } else {
            thisVersion = resource.openConnection().getLastModified();
        }
        long oldVersion = ServerMain.getPublicVersion(publicDir);
        if (thisVersion > oldVersion) {
            block31: {
                try (InputStream is = ServerMain.class.getResourceAsStream("/io/questdb/site/public.zip");){
                    if (is != null) {
                        try (ZipInputStream zip = new ZipInputStream(is);){
                            ZipEntry ze;
                            while ((ze = zip.getNextEntry()) != null) {
                                File dest = new File(publicDir, ze.getName());
                                if (!ze.isDirectory()) {
                                    ServerMain.copyInputStream(true, buffer, dest, zip, log);
                                }
                                zip.closeEntry();
                            }
                            break block31;
                        }
                    }
                    log.error().$("could not find site [resource=").$("/io/questdb/site/public.zip").$(']').$();
                }
            }
            ServerMain.setPublicVersion(publicDir, thisVersion);
            ServerMain.copyConfResource(dir, false, buffer, "conf/date.formats", log);
            ServerMain.copyConfResource(dir, true, buffer, "conf/mime.types", log);
            ServerMain.copyConfResource(dir, false, buffer, "conf/server.conf", log);
        } else {
            log.info().$("web console is up to date").$();
        }
    }

    private static void copyConfResource(String dir, boolean force, byte[] buffer, String res, Log log) throws IOException {
        File out = new File(dir, res);
        try (InputStream is = ServerMain.class.getResourceAsStream("/io/questdb/site/" + res);){
            if (is != null) {
                ServerMain.copyInputStream(force, buffer, out, is, log);
            }
        }
    }

    private static void copyInputStream(boolean force, byte[] buffer, File out, InputStream is, Log log) throws IOException {
        boolean exists = out.exists();
        if (force || !exists) {
            File dir = out.getParentFile();
            if (!dir.exists() && !dir.mkdirs()) {
                log.error().$("could not create directory [path=").$(dir).$(']').$();
                return;
            }
            try (FileOutputStream fos = new FileOutputStream(out);){
                int n;
                while ((n = is.read(buffer, 0, buffer.length)) > 0) {
                    fos.write(buffer, 0, n);
                }
            }
            log.info().$("extracted [path=").$(out).$(']').$();
            return;
        }
        log.debug().$("skipped [path=").$(out).$(']').$();
    }

    private static void deleteDirContentsOrException(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            File[] files;
            if (ServerMain.notSymlink(file) && (files = file.listFiles()) != null) {
                for (File f : files) {
                    ServerMain.deleteOrException(f);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot delete dir contents: " + file, e);
        }
    }

    private static boolean notSymlink(File file) throws IOException {
        File fileInCanonicalDir;
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        if (File.separatorChar == '\\') {
            return true;
        }
        if (file.getParentFile() == null) {
            fileInCanonicalDir = file;
        } else {
            File canonicalDir = file.getParentFile().getCanonicalFile();
            fileInCanonicalDir = new File(canonicalDir, file.getName());
        }
        return fileInCanonicalDir.getCanonicalFile().equals(fileInCanonicalDir.getAbsoluteFile());
    }

    protected static void shutdownQuestDb(WorkerPool workerPool, ObjList<? extends Closeable> instancesToClean) {
        workerPool.halt();
        Misc.freeObjList(instancesToClean);
    }

    private static CharSequence getQuestDbVersion(Attributes manifestAttributes) {
        String version = manifestAttributes.getValue("Implementation-Version");
        return version != null ? version : "[DEVELOPMENT]";
    }

    private static CharSequence getJdkVersion(Attributes manifestAttributes) {
        String version = manifestAttributes.getValue("Build-Jdk");
        return version != null ? version : "Unknown Version";
    }

    private static CharSequence getCommitHash(Attributes manifestAttributes) {
        String version = manifestAttributes.getValue("Build-Commit-Hash");
        return version != null ? version : "Unknown Version";
    }

    private static BuildInformation fetchBuildInformation() throws IOException {
        Attributes manifestAttributes = ServerMain.getManifestAttributes();
        return new BuildInformationHolder(ServerMain.getQuestDbVersion(manifestAttributes), ServerMain.getJdkVersion(manifestAttributes), ServerMain.getCommitHash(manifestAttributes));
    }

    private static Attributes getManifestAttributes() throws IOException {
        Enumeration<URL> resources = ServerMain.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream is = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(is);
                Attributes attributes = manifest.getMainAttributes();
                if (!"org.questdb".equals(attributes.getValue("Implementation-Vendor-Id"))) continue;
                Attributes attributes2 = manifest.getMainAttributes();
                return attributes2;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return new Attributes();
    }

    protected HttpServer createHttpServer(WorkerPool workerPool, Log log, CairoEngine cairoEngine, FunctionFactoryCache functionFactoryCache) {
        return HttpServer.create(this.configuration.getHttpServerConfiguration(), workerPool, log, cairoEngine, functionFactoryCache);
    }

    protected HttpServer createMinHttpServer(WorkerPool workerPool, Log log, CairoEngine cairoEngine, FunctionFactoryCache functionFactoryCache) {
        return HttpServer.createMin(this.configuration.getHttpMinServerConfiguration(), workerPool, log, cairoEngine, functionFactoryCache);
    }

    protected void initQuestDb(WorkerPool workerPool, CairoEngine cairoEngine, Log log) {
    }

    protected void readServerConfiguration(String rootDirectory, Properties properties, Log log, BuildInformation buildInformation) throws ServerConfigurationException, JsonException {
        this.configuration = new PropServerConfiguration(rootDirectory, properties, System.getenv(), log, buildInformation);
    }

    protected void startQuestDb(WorkerPool workerPool, CairoEngine cairoEngine, Log log) {
        workerPool.start(log);
    }
}

