/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TableWriter;
import io.questdb.cairo.security.AllowAllCairoSecurityContext;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.griffin.CompiledQuery;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.griffin.SqlCompiler;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContextImpl;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Long256;
import io.questdb.std.Misc;
import io.questdb.std.NanosecondClock;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.str.Path;
import io.questdb.tasks.TelemetryTask;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public class TelemetryJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(TelemetryJob.class);
    private static final CharSequence tableName = "telemetry";
    private static final CharSequence configTableName = "telemetry_config";
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final RingQueue<TelemetryTask> queue;
    private final SCSequence subSeq;
    private boolean enabled;
    private TableWriter writer;
    private final QueueConsumer<TelemetryTask> myConsumer = this::newRowConsumer;
    private TableWriter writerConfig;

    public TelemetryJob(CairoEngine engine) throws SqlException {
        this(engine, null);
    }

    public TelemetryJob(CairoEngine engine, @Nullable FunctionFactoryCache functionFactoryCache) throws SqlException {
        this.configuration = engine.getConfiguration();
        this.clock = this.configuration.getMicrosecondClock();
        this.enabled = this.configuration.getTelemetryConfiguration().getEnabled();
        this.queue = engine.getTelemetryQueue();
        this.subSeq = engine.getTelemetrySubSequence();
        try (SqlCompiler compiler = new SqlCompiler(engine, engine.getMessageBus(), functionFactoryCache);){
            SqlExecutionContextImpl sqlExecutionContext = new SqlExecutionContextImpl(engine, 1, engine.getMessageBus());
            sqlExecutionContext.with(AllowAllCairoSecurityContext.INSTANCE, null, null);
            try (Path path = new Path();){
                if (this.getTableStatus(path, tableName) == 1) {
                    compiler.compile("CREATE TABLE " + tableName + " (created timestamp, event short, origin short) timestamp(created)", sqlExecutionContext);
                }
                if (this.getTableStatus(path, configTableName) == 1) {
                    compiler.compile("CREATE TABLE " + configTableName + " (id long256, enabled boolean)", sqlExecutionContext);
                }
            }
            try {
                this.writer = engine.getWriter(AllowAllCairoSecurityContext.INSTANCE, tableName);
            }
            catch (CairoException ex) {
                LOG.error().$("could not open [table=`").utf8(tableName).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
                this.enabled = false;
                if (compiler != null) {
                    if (var4_4 != null) {
                        try {
                            compiler.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        compiler.close();
                    }
                }
                return;
            }
            try {
                this.writerConfig = engine.getWriter(AllowAllCairoSecurityContext.INSTANCE, configTableName);
            }
            catch (CairoException ex) {
                Misc.free(this.writer);
                LOG.error().$("could not open [table=`").utf8(configTableName).$("`, ex=").$(ex.getFlyweightMessage()).$(", errno=").$(ex.getErrno()).$(']').$();
                this.enabled = false;
                if (compiler != null) {
                    if (var4_4 != null) {
                        try {
                            compiler.close();
                        }
                        catch (Throwable throwable) {
                            var4_4.addSuppressed(throwable);
                        }
                    } else {
                        compiler.close();
                    }
                }
                return;
            }
            CompiledQuery cc = compiler.compile(configTableName + " LIMIT -1", sqlExecutionContext);
            try (RecordCursor cursor = cc.getRecordCursorFactory().getCursor(sqlExecutionContext);){
                if (cursor.hasNext()) {
                    Record record = cursor.getRecord();
                    boolean _enabled = record.getBool(1);
                    if (this.enabled != _enabled) {
                        TableWriter.Row row = this.writerConfig.newRow();
                        Long256 l256 = record.getLong256A(0);
                        row.putLong256(0, l256);
                        row.putBool(1, this.enabled);
                        row.append();
                        this.writerConfig.commit();
                        LOG.info().$("instance config changes [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(this.enabled).$(']').$();
                    } else {
                        Long256 l256 = record.getLong256A(0);
                        LOG.error().$("instance [id=").$256(l256.getLong0(), l256.getLong1(), 0L, 0L).$(", enabled=").$(this.enabled).$(']').$();
                    }
                } else {
                    MicrosecondClock clock = this.configuration.getMicrosecondClock();
                    NanosecondClock nanosecondClock = this.configuration.getNanosecondClock();
                    TableWriter.Row row = this.writerConfig.newRow();
                    long a = nanosecondClock.getTicks();
                    long b = clock.getTicks();
                    row.putLong256(0, a, b, 0L, 0L);
                    row.putBool(1, this.enabled);
                    row.append();
                    this.writerConfig.commit();
                    LOG.info().$("new instance [id=").$256(a, b, 0L, 0L).$(", enabled=").$(this.enabled).$(']').$();
                }
            }
            this.newRow((short)100);
        }
    }

    @Override
    public void close() {
        if (this.enabled) {
            this.runSerially();
            this.newRow((short)101);
            this.writer.commit();
            Misc.free(this.writer);
            Misc.free(this.writerConfig);
        }
    }

    public int getTableStatus(Path path, CharSequence tableName) {
        return TableUtils.exists(this.configuration.getFilesFacade(), path, this.configuration.getRoot(), tableName, 0, tableName.length());
    }

    @Override
    public boolean runSerially() {
        if (this.enabled && this.subSeq.consumeAll(this.queue, this.myConsumer)) {
            this.writer.commit();
        }
        return false;
    }

    private void newRow(short event) {
        if (this.enabled) {
            try {
                TableWriter.Row row = this.writer.newRow(this.clock.getTicks());
                row.putShort(1, event);
                row.putShort(2, (short)1);
                row.append();
            }
            catch (CairoException e) {
                LOG.error().$("Could not insert a new row in telemetry table [error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).$(']').$();
            }
        }
    }

    private void newRowConsumer(TelemetryTask telemetryRow) {
        try {
            TableWriter.Row row = this.writer.newRow(telemetryRow.created);
            row.putShort(1, telemetryRow.event);
            row.putShort(2, telemetryRow.origin);
            row.append();
        }
        catch (CairoException e) {
            LOG.error().$("Could not insert a new row in telemetry table [error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).$(']').$();
        }
    }
}

