/*
 * Decompiled with CFR 0.152.
 */
package io.questdb;

import io.questdb.MessageBus;
import io.questdb.MessageBusImpl;
import io.questdb.cairo.CairoEngine;
import io.questdb.griffin.FunctionFactoryCache;
import io.questdb.log.Log;
import io.questdb.mp.WorkerPool;
import io.questdb.mp.WorkerPoolConfiguration;
import java.io.Closeable;
import org.jetbrains.annotations.Nullable;

public interface WorkerPoolAwareConfiguration
extends WorkerPoolConfiguration {
    public static final WorkerPoolAwareConfiguration USE_SHARED_CONFIGURATION = new WorkerPoolAwareConfiguration(){

        @Override
        public int[] getWorkerAffinity() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getWorkerCount() {
            return 0;
        }

        @Override
        public boolean haltOnError() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEnabled() {
            return true;
        }
    };

    public static WorkerPool configureWorkerPool(WorkerPoolAwareConfiguration configuration, WorkerPool sharedPool) {
        return configuration.getWorkerCount() > 0 ? new WorkerPool(configuration) : sharedPool;
    }

    @Nullable
    public static <T extends Closeable, C extends WorkerPoolAwareConfiguration> T create(C configuration, WorkerPool sharedWorkerPool, Log log, CairoEngine cairoEngine, ServerFactory<T, C> factory, FunctionFactoryCache functionFactoryCache) {
        if (configuration.isEnabled()) {
            WorkerPool localPool = WorkerPoolAwareConfiguration.configureWorkerPool(configuration, sharedWorkerPool);
            boolean local = localPool != sharedWorkerPool;
            MessageBus bus = local ? new MessageBusImpl(cairoEngine.getConfiguration()) : cairoEngine.getMessageBus();
            T server = factory.create(configuration, cairoEngine, localPool, local, bus, functionFactoryCache);
            if (local) {
                localPool.start(log);
            }
            return server;
        }
        return null;
    }

    public boolean isEnabled();

    @FunctionalInterface
    public static interface ServerFactory<T extends Closeable, C> {
        public T create(C var1, CairoEngine var2, WorkerPool var3, boolean var4, @Nullable MessageBus var5, @Nullable FunctionFactoryCache var6);
    }
}

